/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class PoshElement
implements PropertyChangeListener {
    private PoshElement _parent;
    private Set<PoshElementListener> strutureListeners = new HashSet<PoshElementListener>();
    private Set<PropertyChangeListener> propertyListeners = new HashSet<PropertyChangeListener>();

    PoshElement() {
        this.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PoshPlan rootNode = this.getRootNode();
        if (rootNode != null) {
            rootNode.treePropertyChanged(event);
        }
    }

    public Set<PoshElementListener> getDataNodeListeners() {
        return Collections.unmodifiableSet(this.strutureListeners);
    }

    public synchronized void addPoshTreeChangeListener(PoshElementListener listener) {
        this.strutureListeners.add(listener);
        this.addPropertyChangeListener(listener);
    }

    public synchronized boolean isPoshTreeChangeListener(PoshElementListener listener) {
        return this.strutureListeners.contains(listener);
    }

    public synchronized void removePoshTreeChangeListener(PoshElementListener listener) {
        this.strutureListeners.remove(listener);
        this.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyListeners.add(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyListeners.remove(l);
    }

    protected synchronized void firePropertyChange(String name, Object o, Object n) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener listener : listeners = this.propertyListeners.toArray(new PropertyChangeListener[0])) {
            listener.propertyChange(new PropertyChangeEvent(this, name, o, n));
        }
    }

    public int getNumberOfChildInstances(Class searchedClass) {
        int numEl = 0;
        for (PoshElement node : this.getChildDataNodes()) {
            if (!node.getClass().equals(searchedClass)) continue;
            ++numEl;
        }
        return numEl;
    }

    public abstract DataFlavor getDataFlavor();

    public abstract List<PoshElement> getChildDataNodes();

    public abstract String getDisplayName();

    public synchronized void emitChildNode(PoshElement emitedChild) {
        PoshElementListener[] listenersArray;
        this.treeChanged(PoshTreeEvent.NEW_CHILD_NODE, emitedChild);
        for (PoshElementListener listener : listenersArray = this.getDataNodeListeners().toArray(new PoshElementListener[0])) {
            listener.nodeChanged(PoshTreeEvent.NEW_CHILD_NODE, emitedChild);
        }
        List<PoshElement> children = emitedChild.getChildDataNodes();
        for (PoshElement child : children) {
            emitedChild.emitChildNode(child);
        }
    }

    protected synchronized void emitChildMove(PoshElement childNode, int relativeMove) {
        PoshElementListener[] listenersArray;
        this.treeChanged(PoshTreeEvent.CHILD_NODE_MOVED, childNode);
        for (PoshElementListener listener : listenersArray = this.getDataNodeListeners().toArray(new PoshElementListener[0])) {
            listener.nodeChanged(PoshTreeEvent.CHILD_NODE_MOVED, childNode);
        }
    }

    public synchronized void emitNodeDeleted() {
        PoshElementListener[] listenersArray;
        this.treeChanged(PoshTreeEvent.NODE_DELETED, this);
        for (PoshElementListener listener : listenersArray = this.getDataNodeListeners().toArray(new PoshElementListener[0])) {
            listener.nodeChanged(PoshTreeEvent.NODE_DELETED, this);
        }
    }

    private void treeChanged(PoshTreeEvent event, PoshElement child) {
        PoshPlan rootNode = this.getRootNode();
        if (rootNode != null) {
            rootNode.treeChanged(event, child);
        }
    }

    protected void setParent(PoshElement parent) {
        this._parent = parent;
    }

    public PoshElement getParent() {
        return this._parent;
    }

    public PoshPlan getRootNode() {
        PoshElement cur = this;
        while (cur.getParent() != null) {
            cur = cur.getParent();
        }
        if (cur instanceof PoshPlan) {
            return (PoshPlan)cur;
        }
        return null;
    }

    public abstract void addChildDataNode(PoshElement var1) throws ParseException;

    public abstract boolean moveChild(PoshElement var1, int var2);

    public abstract void neutralizeChild(PoshElement var1);

    protected int getRelativePosition(PoshElement newNode) {
        int dataNodePos = 0;
        int newNodePos = 0;
        int index = 0;
        for (PoshElement sibling : this._parent.getChildDataNodes()) {
            if (sibling == this) {
                dataNodePos = index;
            }
            if (sibling == newNode) {
                newNodePos = index;
            }
            ++index;
        }
        return dataNodePos - newNodePos;
    }

    public final void remove() {
        for (PoshElement child : this.getChildDataNodes()) {
            child.remove();
        }
        this.emitNodeDeleted();
        this.strutureListeners.clear();
    }

    public final void neutralize() {
        this.getParent().neutralizeChild(this);
    }
}

