package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.CompetencePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace.StackElement;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/**
 * Executor for competence.
 * @author Honza
 */
final class CExecutor extends AbstractExecutor implements ElementExecutor {

    private SenseListExecutor goalExecutor;
    private List<CEExecutor> ceExecutors = new ArrayList<CEExecutor>();

    /**
     * Create new competence executor
     * @param plan plan used to resolve names of primitives into S/A/AP/C
     * @param c competence to execute
     * @param ctx variable context of competence
     * @param log logger to record actions of this executor, can be null
     */
    public CExecutor(PoshPlan plan, Competence c, VariableContext ctx, Logger log) {
        super(ctx, log);
        goalExecutor = new SenseListExecutor(c.getGoal(), ctx, log);

        for (CompetencePriorityElement cpe : c.getPriorityElements()) {
            for (CompetenceElement ce : cpe.getElements()) {
                ceExecutors.add(new CEExecutor(plan, ce, ctx, log));
            }
        }
    }

    /**
     * Check if goal is not satisfied, if it is, there is no need to continue to
     * execute this competence.
     * <p>
     * For all CE in priority order:
     *   Check if CE retry limit hasn't been exceeded and if the CE trigger is valid.
     *   If eleemnt is primitive, fire it.
     *   If it is AP or C, return it as next element
     *
     * If none of CE can be fired, the C failed and there is no need to continue;
     *
     * @param workExecuter
     * @return
     */
    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        // is goal satisfied?
        if (goalExecutor.fire(workExecuter, false)) {
            return new FireResult(FireResult.Type.FULFILLED);
        }

        for (CEExecutor ceExecutor : ceExecutors) {
            if (ceExecutor.isReady(workExecuter)) {
                StackElement stackElement = new StackElement(CompetenceElement.class, ceExecutor.getName(), ceExecutor);
                return new FireResult(FireResult.Type.FOLLOW, stackElement);
            }
        }
        // If no element was fired, we have failed
        return new FireResult(FireResult.Type.FAILED);
    }
}
