package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace.StackElement;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.logging.Logger;

/**
 * Executor for AP.
 * If successfull, return specified result, otehrwise FAIL.
 * @author Honza
 */
class APExecutor extends AbstractExecutor implements ElementExecutor {
    private ActionPattern actionPattern;
    private PoshPlan plan;
    private int index = 0;
    private FireResult.Type result;

    /**
     * Create a new AP executor
     * @param plan plan, we will use it to look up what are actions in ap
     * @param ap ap that will be executed.
     * @param result what to return in case of successful AP execution (SURFACE or FULFILLED)
     * @param ctx
     * @param log logger to record actions of this executor, can be null
     */
    APExecutor(PoshPlan plan, ActionPattern ap, FireResult.Type result, VariableContext ctx, Logger log) {
        super(ctx, log);

        this.result = result;
        this.index = 0;

        this.plan = plan;
        this.actionPattern = ap;
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        if (index == actionPattern.getTriggeredActions().size()) {
            return new FireResult(result);
        }
        TriggeredAction action = actionPattern.getTriggeredActions().get(index++);
        StackElement stackElement = createActionExecutor(plan, action.getActionCall());
        return new FireResult(FireResult.Type.FOLLOW, stackElement);
    }

    /**
     * Create an executor for the passed action according to what it really is (C/AP/P).
     * @param plan
     * @param action
     * @return
     */
    private StackElement createActionExecutor(PoshPlan plan, Sense.SenseCall actionCall) {
        String actionName = actionCall.getName();

        for (ActionPattern ap : plan.getActionPatterns()) {
            if (actionName.equals(ap.getNodeName())) {
                return new StackElement(ActionPattern.class, actionName,
                        new APExecutor(plan, ap, FireResult.Type.SURFACE, new VariableContext(ctx, actionCall.getParameters(), ap.getParameters()), log));
            }
        }
        for (Competence c : plan.getCompetences()) {
            if (actionName.equals(c.getNodeName())) {
                return new StackElement(Competence.class, actionName, new CExecutor(plan, c,
                        new VariableContext(ctx, actionCall.getParameters(), c.getParameters()), log));
            }
        }
        return new StackElement(TriggeredAction.class, actionName,
                new PrimitiveExecutor(
                actionCall,
                FireResult.Type.SURFACE,
                FireResult.Type.FAILED,
                new VariableContext(ctx, actionCall.getParameters()),
                log));
    }
}
