/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;
import cz.cuni.pogamut.shed.widget.editor.ArgumentsTableModel;
import cz.cuni.pogamut.shed.widget.editor.TableArgument;
import cz.cuni.pogamut.shed.widget.editor.TableArgumentFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;

class ArgumentsTableModelFactory {
    private ArgumentsTableModelFactory() {
    }

    public static ArgumentsTableModel createNodeModel(FormalParameters params, Arguments args) {
        LinkedList<TableArgument> modelArgs = new LinkedList<TableArgument>();
        for (Arguments.Argument arg : args) {
            String argName = arg.getName();
            if (!argName.startsWith("$")) continue;
            boolean argOverridesParam = false;
            for (FormalParameters.Parameter param : params) {
                String paramName = param.getName();
                if (!paramName.equals(argName)) continue;
                argOverridesParam = true;
            }
            if (argOverridesParam) continue;
            modelArgs.add(TableArgumentFactory.createFromArgument(arg));
        }
        return new ArgumentsTableModel(modelArgs, true);
    }

    public static ArgumentsTableModel createLeafModel(ParamInfo[] params, Arguments args) {
        LinkedList<TableArgument> modelArgs = new LinkedList<TableArgument>();
        for (Arguments.Argument arg : args) {
            ParamInfo info = ArgumentsTableModelFactory.getParamInfo(params, arg.getName());
            modelArgs.add(TableArgumentFactory.createFromArgument(arg, info));
        }
        HashSet<String> argNamesSet = new HashSet<String>(Arrays.asList(args.getAllNames()));
        for (ParamInfo param : params) {
            boolean planPassesValue = argNamesSet.contains(param.name);
            if (planPassesValue) continue;
            modelArgs.add(TableArgumentFactory.createBlank(param));
        }
        return new ArgumentsTableModel(modelArgs, false);
    }

    private static ParamInfo getParamInfo(ParamInfo[] paramsInfo, String searchedParam) {
        for (ParamInfo info : paramsInfo) {
            if (!info.name.equals(searchedParam)) continue;
            return info;
        }
        return null;
    }
}

