/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.INamedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.shed.presenter.AbstractLapElementListener;
import cz.cuni.pogamut.shed.presenter.AbstractPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.IReplaceExpandedAction;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.AttachmentEnvelope;
import cz.cuni.pogamut.shed.widget.ExpandedActionEnvelope;
import cz.cuni.pogamut.shed.widget.ShedCreationContainer;
import cz.cuni.pogamut.shed.widget.ShedScene;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import org.netbeans.api.visual.action.WidgetAction;

class ExpandedActionPresenter
extends AbstractPresenter
implements IPresenter,
IReplaceExpandedAction {
    private final ExpandedActionUpdater<TriggeredAction> actionExpansionUpdater;
    private final ExpandedActionUpdater<Competence> compatenceExpansionUpdater;
    private final ExpandedActionUpdater<ActionPattern> actionPatternExpansionUpdater;
    private final CompetenceListenersManager competenceListenersUpdater;
    private final ActionPatternListenersManager actionPatternListenersUpdater;
    private final TriggeredAction action;
    private final ExpandedActionEnvelope envelope;
    private final LapChain chain;

    public ExpandedActionPresenter(ShedScene scene, ShedPresenter presenter, ExpandedActionEnvelope envelope, TriggeredAction action, LapChain chain) {
        super(scene, presenter);
        this.action = action;
        this.envelope = envelope;
        this.chain = chain;
        this.actionExpansionUpdater = new ExpandedActionUpdater(this, action, "taName");
        this.actionPatternExpansionUpdater = new ExpandedActionUpdater(this, action, "apName");
        this.compatenceExpansionUpdater = new ExpandedActionUpdater(this, action, "cnName");
        this.competenceListenersUpdater = new CompetenceListenersManager((IReplaceExpandedAction)this, action, (PoshElementListener<Competence>)this.compatenceExpansionUpdater);
        this.actionPatternListenersUpdater = new ActionPatternListenersManager((IReplaceExpandedAction)this, action, (PoshElementListener<ActionPattern>)this.actionPatternExpansionUpdater);
    }

    @Override
    public void register() {
        this.envelope.setPresenter(this);
        PoshPlan lapPlan = this.presenter.getLapTree();
        assert (lapPlan == this.action.getRootNode());
        lapPlan.addElementListener((PoshElementListener)this.competenceListenersUpdater);
        lapPlan.addElementListener((PoshElementListener)this.actionPatternListenersUpdater);
        this.action.addElementListener(this.actionExpansionUpdater);
        for (ActionPattern actionPattern : lapPlan.getActionPatterns()) {
            actionPattern.addElementListener(this.actionPatternExpansionUpdater);
        }
        for (Competence competence : lapPlan.getCompetences()) {
            competence.addElementListener(this.compatenceExpansionUpdater);
        }
    }

    @Override
    public void unregister() {
        PoshPlan lapPlan = this.presenter.getLapTree();
        for (Competence competence : lapPlan.getCompetences()) {
            competence.removeElementListener(this.compatenceExpansionUpdater);
        }
        for (ActionPattern actionPattern : lapPlan.getActionPatterns()) {
            actionPattern.removeElementListener(this.actionPatternExpansionUpdater);
        }
        this.action.removeElementListener(this.actionExpansionUpdater);
        lapPlan.removeElementListener((PoshElementListener)this.actionPatternListenersUpdater);
        lapPlan.removeElementListener((PoshElementListener)this.competenceListenersUpdater);
        this.envelope.setPresenter(null);
    }

    @Override
    public Action[] getMenuActions() {
        return null;
    }

    @Override
    public void replaceExpandedAction(TriggeredAction actionToExpand) {
        assert (this.action == actionToExpand);
        LapPath actionPathFragment = LapPath.getLinkPath((PoshElement)this.action);
        LapPath chainPath = this.chain.toPath();
        LapPath actionPath = chainPath.concat(actionPathFragment.subpath(1, actionPathFragment.length()));
        ShedCreationContainer<AttachmentEnvelope> newAttachment = this.scene.getWidgetFactory().createAttachmentEnvelope(actionPath, this.action);
        this.envelope.changeAttachmentWidget(newAttachment.getWidget());
        this.scene.update();
        this.scene.addArrows(newAttachment.getArrows());
        this.scene.update();
        this.scene.repaint();
    }

    @Override
    public WidgetAction getEditAction() {
        return null;
    }

    private static class ActionPatternListenersManager
    extends AbstractListenersManager<ActionPattern> {
        ActionPatternListenersManager(IReplaceExpandedAction replaceActionWidget, TriggeredAction action, PoshElementListener<ActionPattern> listener) {
            super(replaceActionWidget, action, listener);
        }

        public void childElementAdded(PoshPlan parent, PoshElement child) {
            if (this.isActionPattern(child)) {
                ActionPattern addedActionPattern = this.extractActionPattern(parent.getActionPatterns(), child);
                addedActionPattern.addElementListener(this.listener);
                this.updateAttachment((INamedElement)addedActionPattern);
            }
        }

        public void childElementRemoved(PoshPlan parent, PoshElement child, int removedChildPosition) {
            if (this.isActionPattern(child)) {
                ActionPattern removedActionPattern = (ActionPattern)child;
                removedActionPattern.removeElementListener(this.listener);
                this.updateAttachment((INamedElement)removedActionPattern);
            }
        }
    }

    private static class CompetenceListenersManager
    extends AbstractListenersManager<Competence> {
        CompetenceListenersManager(IReplaceExpandedAction replaceActionWidget, TriggeredAction action, PoshElementListener<Competence> listener) {
            super(replaceActionWidget, action, listener);
        }

        public void childElementAdded(PoshPlan parent, PoshElement child) {
            if (this.isCompetence(child)) {
                Competence addedCompetence = this.extractCompetence(parent.getCompetences(), child);
                addedCompetence.addElementListener(this.listener);
                this.updateAttachment((INamedElement)addedCompetence);
            }
        }

        public void childElementRemoved(PoshPlan parent, PoshElement child, int removedChildPosition) {
            if (this.isCompetence(child)) {
                Competence removedCompetence = (Competence)child;
                removedCompetence.removeElementListener(this.listener);
                this.updateAttachment((INamedElement)removedCompetence);
            }
        }
    }

    private static abstract class AbstractListenersManager<STRUCTURE extends PoshElement>
    extends AbstractLapElementListener<PoshPlan> {
        protected final IReplaceExpandedAction replaceActionWidget;
        protected final TriggeredAction action;
        protected final PoshElementListener<STRUCTURE> listener;

        public AbstractListenersManager(IReplaceExpandedAction replaceActionWidget, TriggeredAction action, PoshElementListener<STRUCTURE> listener) {
            this.replaceActionWidget = replaceActionWidget;
            this.action = action;
            this.listener = listener;
        }

        protected void updateAttachment(INamedElement modifiedElement) {
            String elementName;
            String actionName = this.action.getName();
            boolean actionReferencesElement = actionName.equals(elementName = modifiedElement.getName());
            if (actionReferencesElement) {
                this.replaceActionWidget.replaceExpandedAction(this.action);
            }
        }

        public void childElementMoved(PoshPlan parent, PoshElement child, int oldIndex, int newIndex) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    private static class ExpandedActionUpdater<T extends PoshElement>
    implements PoshElementListener<T> {
        private final IReplaceExpandedAction actionBranchReplacer;
        private final TriggeredAction action;
        private final String nameProperty;

        ExpandedActionUpdater(IReplaceExpandedAction actionBranchReplacer, TriggeredAction action, String nameProperty) {
            this.actionBranchReplacer = actionBranchReplacer;
            this.action = action;
            this.nameProperty = nameProperty;
        }

        public void childElementAdded(T parent, PoshElement child) {
        }

        public void childElementMoved(T parent, PoshElement child, int oldIndex, int newIndex) {
        }

        public void childElementRemoved(T parent, PoshElement child, int removedChildIndex) {
        }

        public void propertyChange(PropertyChangeEvent changeEvent) {
            if (changeEvent.getPropertyName().equals(this.nameProperty)) {
                String actionName = this.action.getName();
                String oldElementName = (String)changeEvent.getOldValue();
                boolean referencedOldName = actionName.equals(oldElementName);
                String newElementName = (String)changeEvent.getNewValue();
                boolean referencesNewName = actionName.equals(newElementName);
                if (referencedOldName || referencesNewName) {
                    this.actionBranchReplacer.replaceExpandedAction(this.action);
                }
            }
        }
    }
}

