/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.pogamut.shed.widget.editor.TableArgument;
import cz.cuni.pogamut.shed.widget.editor.TableParameter;
import java.awt.Rectangle;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.widget.Widget;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

abstract class ShedEditorProvider<NODE, EDITOR extends JComponent>
implements InplaceEditorProvider<EDITOR> {
    final NODE node;
    final LapChain chain;

    public ShedEditorProvider(NODE node, LapChain chain) {
        this.node = node;
        this.chain = chain;
    }

    public final void notifyOpened(InplaceEditorProvider.EditorController ec, Widget widget, EDITOR c) {
    }

    public final Rectangle getInitialEditorComponentBounds(InplaceEditorProvider.EditorController controller, Widget widget, EDITOR editor, Rectangle viewBounds) {
        return null;
    }

    public final EnumSet<InplaceEditorProvider.ExpansionDirection> getExpansionDirections(InplaceEditorProvider.EditorController ec, Widget widget, EDITOR c) {
        return EnumSet.of(InplaceEditorProvider.ExpansionDirection.BOTTOM, InplaceEditorProvider.ExpansionDirection.RIGHT);
    }

    void notify(String message) {
        NotifyDescriptor.Message infoMessage = new NotifyDescriptor.Message((Object)message, 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)infoMessage);
    }

    String convertEditorArg(List<TableArgument> editorArgs, Arguments args) {
        StringBuilder sb = new StringBuilder();
        VariableContext ctx = this.chain.subchain(0, this.chain.size() - 1).createContext();
        for (TableArgument editorArg : editorArgs) {
            try {
                Arguments.Argument arg = editorArg.createArgument(ctx);
                args.add((Object)arg);
            }
            catch (IllegalStateException ex) {
                boolean valueIsBlank = editorArg.getValueString().isEmpty();
                boolean variableIsDefined = ctx.hasVariable(editorArg.getName());
                if (valueIsBlank && variableIsDefined) continue;
                sb.append(editorArg.getName());
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    String convertEditorParams(List<TableParameter> editorParams, Arguments args) {
        StringBuilder sb = new StringBuilder();
        for (TableParameter editorParam : editorParams) {
            if (!editorParam.isOverriden()) continue;
            try {
                VariableContext ctx = this.chain.subchain(0, this.chain.size() - 1).createContext();
                Arguments.Argument arg = editorParam.createOverrideArgument(ctx);
                args.add((Object)arg);
            }
            catch (IllegalStateException ex) {
                sb.append(editorParam.getName());
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

