/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget;

import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenterFactory;
import cz.cuni.pogamut.shed.presenter.ShedPresenterFactory;
import cz.cuni.pogamut.shed.widget.ShedCreationContainer;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedWidgetFactory;
import cz.cuni.pogamut.shed.widget.SlotEnvelope;

public class LapSceneFactory {
    public static ShedScene createShedScene(PoshPlan plan) {
        assert (plan.getDriveCollection().getDrives().isEmpty());
        assert (plan.getDriveCollection().getGoal().isEmpty());
        ShedScene scene = new ShedScene(plan);
        ShedPresenterFactory presenterFactory = new ShedPresenterFactory(scene, plan, scene.getPresenter());
        ShedWidgetFactory widgetFactory = new ShedWidgetFactory(scene, plan, presenterFactory);
        scene.setWidgetFactory(widgetFactory);
        LapSceneFactory.registerDriveCollectionPresenters(scene, presenterFactory, plan.getDriveCollection());
        return scene;
    }

    public static ShedScene createDashScene(PoshPlan plan, ShedScene scene, IPresenterFactory presenterFactory) {
        ShedWidgetFactory widgetFactory = new ShedWidgetFactory(scene, plan, presenterFactory);
        scene.setWidgetFactory(widgetFactory);
        LapSceneFactory.registerDriveCollectionPresenters(scene, presenterFactory, plan.getDriveCollection());
        int driveId = 0;
        for (DriveElement drive : plan.getDriveCollection().getDrives()) {
            LapPath drivePath = LapPath.DRIVE_COLLECTION_PATH.concat(LapType.DRIVE_ELEMENT, driveId++);
            ShedCreationContainer<SlotEnvelope> driveContainer = widgetFactory.createDriveEnvelope(drivePath, drive);
            scene.getDrivesEnvelope().add(driveContainer.getWidget());
            scene.addArrows(driveContainer.getArrows());
        }
        scene.update();
        return scene;
    }

    private static void registerDriveCollectionPresenters(ShedScene scene, IPresenterFactory presenterFactory, DriveCollection driveCollection) {
        IPresenter dcPresenter = presenterFactory.createDriveCollectionPresenter(LapPath.DRIVE_COLLECTION_PATH, driveCollection);
        dcPresenter.register();
        IPresenter goalPresenter = presenterFactory.createTriggerPresenter(driveCollection, driveCollection.getGoal(), scene.getGoalEnvelope(), new LapChain());
        goalPresenter.register();
    }
}

