/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.explorer;

import cz.cuni.pogamut.posh.explorer.Crawler;
import cz.cuni.pogamut.posh.explorer.CrawlerListener;
import cz.cuni.pogamut.posh.explorer.PrimitiveData;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;

public class NameMapCrawler
implements CrawlerListener<PrimitiveData> {
    private final ShedPresenter presenter;
    private Set<PrimitiveData> crawledNames = new HashSet<PrimitiveData>();

    public NameMapCrawler(ShedPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void started(Crawler<PrimitiveData> crawler) {
        assert (SwingUtilities.isEventDispatchThread());
        for (PrimitiveData record : this.crawledNames) {
            String key = record.classFQN;
            this.presenter.setNameMapping(key, null);
        }
        this.crawledNames.clear();
    }

    @Override
    public void crawledData(Crawler<PrimitiveData> crawler, Collection<PrimitiveData> data) {
        assert (SwingUtilities.isEventDispatchThread());
        this.crawledNames.addAll(data);
        for (PrimitiveData record : data) {
            String key = record.classFQN;
            this.presenter.setNameMapping(key, record);
        }
    }

    @Override
    public void finished(Crawler<PrimitiveData> crawler, boolean error) {
        assert (SwingUtilities.isEventDispatchThread());
    }
}

