/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.posh.widget.GhostWidget;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.accept.DataNodeExTransferable;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.List;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.widget.Widget;

class DnDMoveProvider
implements MoveProvider {
    private GhostWidget ghost;
    private PoshScene scene;
    Border FUTILE_BORDER = BorderFactory.createRoundedBorder((int)0, (int)0, (Color)new Color(223, 106, 109), (Color)Color.BLACK);
    Border ACCEPTING_BORDER = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createRoundedBorder((int)0, (int)0, (Color)new Color(109, 243, 86), (Color)Color.BLACK), BorderFactory.createLineBorder((int)1), BorderFactory.createLineBorder((int)1), BorderFactory.createLineBorder((int)1)});

    DnDMoveProvider(PoshScene scene) {
        this.scene = scene;
    }

    public void movementStarted(Widget arg0) {
        PoshWidget widget = (PoshWidget)arg0;
        this.ghost = new GhostWidget(widget);
        this.scene.addGhostWidget(this.ghost);
        widget.select(widget, widget.getLocation(), false);
    }

    private PoshWidget<? extends PoshElement> findContainingWidget(Point center) {
        for (Widget widget : this.scene.getPoshWidgets()) {
            Rectangle rect = (Rectangle)widget.getClientArea().clone();
            rect.setLocation(widget.getLocation());
            if (!rect.contains(center) || !(widget instanceof PoshWidget)) continue;
            return (PoshWidget)widget;
        }
        return null;
    }

    public void movementFinished(Widget arg0) {
        this.scene.removeGhostWidget(this.ghost);
        Point center = this.getGhostCenter();
        PoshWidget<? extends PoshElement> hitWidget = this.findContainingWidget(center);
        if (hitWidget == null) {
            return;
        }
        if (hitWidget == this.ghost.associatedWidget) {
            return;
        }
        List<AbstractAcceptAction> acceptProviders = hitWidget.getAcceptProviders();
        for (AbstractAcceptAction acceptProvider : acceptProviders) {
            DataFlavor ghostDataFlavor = this.ghost.associatedWidget.getDataNode().getDataFlavor();
            DataFlavor acceptDataFlavor = acceptProvider.getDataFlavor();
            if (!acceptDataFlavor.equals(ghostDataFlavor)) continue;
            this.dropGhostOnWidget(hitWidget, acceptProvider);
            break;
        }
    }

    private void dropGhostOnWidget(PoshWidget destination, AbstractAcceptAction acceptAction) {
        DataNodeExTransferable tr = new DataNodeExTransferable((PoshElement)this.ghost.associatedWidget.getDataNode());
        Object widgetDataNode = this.ghost.associatedWidget.getDataNode();
        PoshElement originalParent = widgetDataNode.getParent();
        originalParent.neutralizeChild(widgetDataNode);
        for (PoshElement originalChild : originalParent.getChildDataNodes()) {
            if (originalChild instanceof TriggeredAction) {
                TriggeredAction actionChild = (TriggeredAction)originalChild;
                actionChild.setActionName("cz.cuni.amis.pogamut.sposh.ut2004.actions.DoNothing");
            }
            if (!(originalChild instanceof Sense)) continue;
            Sense senseChild = (Sense)originalChild;
            senseChild.setSenseName("cz.cuni.amis.pogamut.sposh.ut2004.senses.Succeed");
        }
        acceptAction.accept(destination, null, (Transferable)((Object)tr));
        this.scene.validate();
    }

    private Point getGhostCenter() {
        Point center = (Point)this.ghost.getLocation().clone();
        center.translate((int)this.ghost.getBounds().getWidth() / 2, (int)this.ghost.getBounds().getHeight() / 2);
        return center;
    }

    public Point getOriginalLocation(Widget widget) {
        return widget.getLocation();
    }

    public void setNewLocation(Widget w, Point currentLocation) {
        this.ghost.setPreferredLocation(currentLocation);
        Point center = this.getGhostCenter();
        PoshWidget<? extends PoshElement> hitWidget = this.findContainingWidget(center);
        if (hitWidget == null) {
            this.ghost.setBorder(this.FUTILE_BORDER);
            return;
        }
        List<AbstractAcceptAction> acceptProviders = hitWidget.getAcceptProviders();
        for (AbstractAcceptAction acceptProvider : acceptProviders) {
            DataFlavor ghostDataFlavor = this.ghost.associatedWidget.getDataNode().getDataFlavor();
            DataFlavor acceptDataFlavor = acceptProvider.getDataFlavor();
            if (!acceptDataFlavor.equals(ghostDataFlavor)) continue;
            this.ghost.setBorder(this.ACCEPTING_BORDER);
            return;
        }
        this.ghost.setBorder(this.FUTILE_BORDER);
    }
}

