/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.properties;

import java.util.Arrays;
import org.openide.nodes.PropertySupport;

public class ComboBoxProperty<T>
extends PropertySupport.Reflection<Integer> {
    public ComboBoxProperty(T[] items, Class tClass, Object propertyObject, String getter, String setter) throws NoSuchMethodException {
        super(new Items((Object[])items, tClass, propertyObject, getter, setter), Integer.class, "getItemId", "setItemId");
        int[] intValues = new int[items.length];
        String[] stringKeys = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            intValues[i] = i;
            stringKeys[i] = items[i].toString();
        }
        this.setValue("intValues", intValues);
        this.setValue("stringKeys", stringKeys);
    }

    private static class Items<T> {
        private T[] items;
        private Class tClass;
        private Object propertyObject;
        private String getter;
        private String setter;

        private Items(T[] list, Class tClass, Object propertyObject, String getter, String setter) {
            this(list, 0, tClass, propertyObject, getter, setter);
        }

        private Items(T[] list, int selected, Class tClass, Object propertyObject, String getter, String setter) {
            this.items = Arrays.copyOf(list, list.length);
            this.propertyObject = propertyObject;
            this.getter = getter;
            this.setter = setter;
        }

        public Integer getItemId() throws Exception {
            T currentItem = this.getProperty();
            for (int i = 0; i < this.items.length; ++i) {
                if (!this.items[i].equals(currentItem)) continue;
                return i;
            }
            throw new IllegalStateException("Currently selected value is not in object.");
        }

        public void setItemId(Integer newItemId) throws Exception {
            if (newItemId == null) {
                return;
            }
            if (newItemId >= this.items.length) {
                return;
            }
            if (newItemId < 0) {
                return;
            }
            this.setProperty(this.items[newItemId]);
        }

        private void setProperty(T newItem) throws Exception {
            this.propertyObject.getClass().getMethod(this.setter, this.tClass).invoke(this.propertyObject, newItem);
        }

        private T getProperty() throws Exception {
            return (T)this.propertyObject.getClass().getMethod(this.getter, new Class[0]).invoke(this.propertyObject, new Object[0]);
        }
    }
}

