/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.explorer;

import cz.cuni.pogamut.posh.explorer.CrawlerListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class Crawler<T> {
    protected final Set<CrawlerListener<T>> listeners = new HashSet<CrawlerListener<T>>();
    protected final Set<CrawlerListener<T>> listenersUm = Collections.unmodifiableSet(this.listeners);
    protected final Set<T> cache = new HashSet<T>();
    protected final Set<T> cacheUm = Collections.unmodifiableSet(this.cache);

    public abstract String getName();

    public abstract String getDescription();

    public abstract void crawl();

    public abstract void die();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addListener(CrawlerListener<T> listener) {
        Set<CrawlerListener<T>> set = this.listeners;
        synchronized (set) {
            return this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeListener(CrawlerListener<T> listener) {
        Set<CrawlerListener<T>> set = this.listeners;
        synchronized (set) {
            return this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyStarted() {
        Set<CrawlerListener<T>> set = this.listeners;
        synchronized (set) {
            HashSet<CrawlerListener<T>> listenersCopy = new HashSet<CrawlerListener<T>>(this.listeners);
            for (CrawlerListener crawlerListener : listenersCopy) {
                crawlerListener.started(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyCrawledData(Collection<T> data) {
        this.cache.addAll(data);
        Set<CrawlerListener<T>> set = this.listeners;
        synchronized (set) {
            HashSet<CrawlerListener<T>> listenersCopy = new HashSet<CrawlerListener<T>>(this.listeners);
            for (CrawlerListener crawlerListener : listenersCopy) {
                crawlerListener.crawledData(this, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyFinished(boolean error) {
        Set<CrawlerListener<T>> set = this.listeners;
        synchronized (set) {
            HashSet<CrawlerListener<T>> listenersCopy = new HashSet<CrawlerListener<T>>(this.listeners);
            for (CrawlerListener crawlerListener : listenersCopy) {
                crawlerListener.finished(this, error);
            }
        }
    }
}

