/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.view;

import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.pogamut.posh.PoshEditorSupport;
import cz.cuni.pogamut.posh.explorer.Crawler;
import cz.cuni.pogamut.posh.explorer.CrawlerExplorerFactory;
import cz.cuni.pogamut.posh.explorer.CrawlerListener;
import cz.cuni.pogamut.posh.explorer.PrimitiveData;
import cz.cuni.pogamut.posh.view.TreeCollapseImprint;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.kidview.SimpleDriveCollectionWidget;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

public class KidViewElement
implements MultiViewElement {
    private final PoshPlan plan;
    private PoshEditorSupport support;
    private TreeCollapseImprint collapseImprint;
    private PoshScene scene;
    private JComponent panel;
    private JScrollPane scrollPane;
    private JToolBar toolbar;
    private final Lookup lookup;
    private InstanceContent ic;
    CrawlerListener<PrimitiveData> actionsListener = new CrawlerListener<PrimitiveData>(){

        @Override
        public void started(Crawler<PrimitiveData> crawler) {
        }

        private void updateActionName(PoshWidget<? extends PoshElement> widget, String name, String newName) {
            if (newName == null) {
                KidViewElement.this.scene.getActionsFQNMapping().remove(name);
            } else {
                KidViewElement.this.scene.getActionsFQNMapping().put(name, newName);
            }
        }

        @Override
        public void crawledData(Crawler<PrimitiveData> crawler, Collection<PrimitiveData> data) {
            for (PrimitiveData info : data) {
                this.updateActionName(KidViewElement.this.scene.getRootWidget(), info.classFQN, info.name);
            }
        }

        @Override
        public void finished(Crawler<PrimitiveData> crawler, boolean error) {
            assert (SwingUtilities.isEventDispatchThread());
            KidViewElement.this.scene.repaint();
        }
    };
    CrawlerListener<PrimitiveData> sensesListener = new CrawlerListener<PrimitiveData>(){

        @Override
        public void started(Crawler<PrimitiveData> crawler) {
        }

        private void updateSenseName(PoshWidget<? extends PoshElement> widget, String name, String newName) {
            if (newName == null) {
                KidViewElement.this.scene.getSensesFQNMapping().remove(name);
            } else {
                KidViewElement.this.scene.getSensesFQNMapping().put(name, newName);
            }
        }

        @Override
        public void crawledData(Crawler<PrimitiveData> crawler, Collection<PrimitiveData> data) {
            for (PrimitiveData info : data) {
                this.updateSenseName(KidViewElement.this.scene.getRootWidget(), info.classFQN, info.name);
            }
        }

        @Override
        public void finished(Crawler<PrimitiveData> crawler, boolean error) {
            assert (SwingUtilities.isEventDispatchThread());
            KidViewElement.this.scene.repaint();
        }
    };
    JTabbedPane explorer;
    boolean explorerCreated = false;

    public KidViewElement(PoshEditorSupport support) {
        this.support = support;
        this.plan = new PoshPlan();
        this.scene = new PoshScene();
        this.scene.setSourceUpdater(new SourceUpdater(this.plan, support));
        this.ic = new InstanceContent();
        this.lookup = new ProxyLookup(new Lookup[]{support.getDataObject().getNodeDelegate().getLookup(), new AbstractLookup((AbstractLookup.Content)this.ic)});
        this.panel = this.createVisualRepresentation();
    }

    private Project getProject() {
        return FileOwnerQuery.getOwner((FileObject)this.support.getDataObject().getPrimaryFile());
    }

    private JComponent createVisualRepresentation() {
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.scene.createView());
        Project project = this.getProject();
        if (project == null) {
            return this.scrollPane;
        }
        this.explorer = new JTabbedPane();
        this.explorer.setPreferredSize(this.explorer.getMinimumSize());
        JSplitPane rootPanel = new JSplitPane(1, this.scrollPane, this.explorer);
        rootPanel.resetToPreferredSizes();
        return rootPanel;
    }

    public synchronized JComponent getVisualRepresentation() {
        return this.panel;
    }

    private void refresh(InputStream stream) throws ParseException, CycleException {
        this.plan.synchronizePlan(stream);
        this.scene.clearPoshWidgets();
        this.scene.setRootWidget(new SimpleDriveCollectionWidget(this.scene, this.plan.getDriveCollection(), null));
        this.plan.emitTree();
        this.scene.setSourceUpdater(new SourceUpdater(this.plan, this.support));
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
        }
        return this.toolbar;
    }

    public Action[] getActions() {
        return this.support.getDataObject().getNodeDelegate().getActions(false);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void componentShowing() {
        this.support.notifyModified();
        this.regenerateTreeFromSource();
        Project project = this.getProject();
        if (project != null && !this.explorerCreated) {
            this.explorer.addTab("Competences", CrawlerExplorerFactory.createCompetenceExplorer(this.plan));
            this.explorer.addTab("Action patterns", CrawlerExplorerFactory.createAPExplorer(this.plan));
            this.explorer.addTab("Actions", CrawlerExplorerFactory.createActionsExplorer(project, this.actionsListener));
            this.explorer.addTab("Senses", CrawlerExplorerFactory.createSensesExplorer(project, this.sensesListener));
            this.explorerCreated = true;
        }
    }

    public void componentHidden() {
    }

    public void componentActivated() {
    }

    public void componentDeactivated() {
    }

    public UndoRedo getUndoRedo() {
        return null;
    }

    public void setMultiViewCallback(MultiViewElementCallback mvec) {
        mvec.requestVisible();
        mvec.requestActive();
    }

    public CloseOperationState canCloseElement() {
        DataObject dObj = this.support.getDataObject();
        if (dObj.isModified()) {
            AbstractAction saveAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        KidViewElement.this.support.saveDocument();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            AbstractAction discardAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KidViewElement.this.support.onCloseDiscard();
                }
            };
            return MultiViewFactory.createUnsafeCloseState((String)this.support.messageSave(), (Action)saveAction, (Action)discardAction);
        }
        return CloseOperationState.STATE_OK;
    }

    private void regenerateTreeFromSource() {
        try {
            this.scrollPane.setViewportView(this.scene.getView());
            this.refresh(this.support.getInputStream());
            if (this.collapseImprint != null) {
                this.collapseImprint.restore(this.scene.getRootWidget());
            }
            this.collapseImprint = null;
        }
        catch (ParseException ex) {
            this.scrollPane.setViewportView(new ParseErrorPane(ex));
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class ParseErrorPane
    extends JEditorPane {
        private ParseErrorPane(ParseException exception) {
            super("text/html", "<html><head><style>.errorbox {}.boxtitle {\tbackground-color: rgb(157, 173, 198);\ttext-align: center;}.boxtitle h2 {\tmargin: 0;\tpadding: 15px 30px 5px;\tcolor: white;\tfont-weight: bold;\tfont-size: 1.5em;}.boxtext {\tbackground-color: rgb(230, 230, 230);\tpadding: 5px 50px 31px;}</style></head><body><div class=\"errorbox\">  <div class=\"boxtitle\"><h2>Syntax error</h2></div>  <div class=\"boxtext\">    <p>There is a problem in syntax of supplied posh plan. To remedy this situation, switch to source view and correct syntax error.</p>    <p>The syntax error will be marked by red exclamation mark at the line of error. Description of error will be in tooltip of the exclamation mark.</p>    <p><b>Error:</b> " + exception.getMessage().replace("<", "&lt;").replace(">", "&gt;") + "</p>" + "  </div>" + "</div>" + "</body>" + "</html>");
        }
    }

    public static final class SourceUpdater
    implements Runnable {
        private PoshEditorSupport support;
        private PoshPlan plan;

        private SourceUpdater(PoshPlan plan, PoshEditorSupport support) {
            this.plan = plan;
            this.support = support;
        }

        public void update() {
            NbDocument.runAtomic((StyledDocument)this.support.getDocument(), (Runnable)this);
        }

        @Override
        public void run() {
            try {
                String planString = this.plan.toString();
                this.support.getDocument().remove(0, this.support.getDocument().getLength());
                this.support.getDocument().insertString(0, planString, null);
                this.support.notifyModified();
                this.support.setModified();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

