/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.explorer;

import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.pogamut.posh.explorer.AbstractCrawler;
import cz.cuni.pogamut.posh.explorer.PrimitiveData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;

abstract class ClassCrawler
extends AbstractCrawler<PrimitiveData> {
    protected final Project project;
    protected final String fqn;

    protected ClassCrawler(Project project, String fqn) {
        this.project = project;
        this.fqn = fqn;
    }

    @Override
    public final synchronized void crawl() {
        ClasspathInfo cpi = this.getClasspathInfo(this.project);
        ClassIndex ci = cpi.getClassIndex();
        ElementHandle<TypeElement> ancestor = this.getTypeOfClass(ci, this.fqn);
        if (ancestor == null) {
            return;
        }
        this.notifyStarted();
        Set<ElementHandle<TypeElement>> list = this.getAllSubtypes(ci, ancestor);
        JavaSource js = JavaSource.create((ClasspathInfo)cpi, (FileObject[])new FileObject[0]);
        try {
            FilterAbstract filter = new FilterAbstract(list);
            js.runUserActionTask((Task)filter, true);
            this.notifyCrawledData(filter.getResult());
            this.notifyFinished(false);
            return;
        }
        catch (IOException ex) {
            list.clear();
            this.notifyFinished(true);
            return;
        }
    }

    @Override
    public void die() {
    }

    private static class FilterAbstract
    implements Task<CompilationController> {
        private final Set<ElementHandle<TypeElement>> set;
        private Set<PrimitiveData> result;
        private static final Logger log = Logger.getLogger(FilterAbstract.class.getName());

        FilterAbstract(Set<ElementHandle<TypeElement>> set) {
            this.set = set;
        }

        public Set<PrimitiveData> getResult() {
            assert (this.result != null);
            return this.result;
        }

        private boolean isPublic(TypeElement type) {
            return type.getModifiers().contains((Object)Modifier.PUBLIC);
        }

        private boolean isAbstract(TypeElement type) {
            return type.getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        private TypeMirror getTypeMirror4Class(CompilationController cc, String classFQN) {
            TypeElement te = cc.getElements().getTypeElement(classFQN);
            if (te == null) {
                return null;
            }
            return te.asType();
        }

        private AnnotationMirror findAnnotationMirror(Element element, TypeMirror annotationType) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationType.toString().equals(annotationMirror.getAnnotationType().toString())) continue;
                return annotationMirror;
            }
            return null;
        }

        private <T> T getAnnotationValue(Class<T> cls, String elementName, String attributeName, AnnotationValue annotationValue) {
            Object value = annotationValue.getValue();
            if (cls.isInstance(value)) {
                return (T)value;
            }
            log.warning("Element " + elementName + " has an annotation with with attribute \"" + attributeName + "\", that should be " + cls.getCanonicalName() + ", but it " + value.getClass().getCanonicalName() + ".");
            return null;
        }

        private PrimitiveData getInfo(String classFQN, AnnotationMirror annotation) {
            String name = null;
            String description = null;
            ArrayList<String> tags = Collections.EMPTY_LIST;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
                List tagList;
                Name entryName = entry.getKey().getSimpleName();
                AnnotationValue entryValue = entry.getValue();
                if (entryName.contentEquals("name")) {
                    name = this.getAnnotationValue(String.class, classFQN, "name", entryValue);
                    continue;
                }
                if (entryName.contentEquals("description")) {
                    description = this.getAnnotationValue(String.class, classFQN, "description", entryValue);
                    continue;
                }
                if (!entryName.contentEquals("tags") || (tagList = this.getAnnotationValue(List.class, classFQN, "tags", entryValue)) == null) continue;
                tags = new ArrayList<String>(tagList.size());
                for (AnnotationValue tagValue : tagList) {
                    String tag = this.getAnnotationValue(String.class, classFQN, "tags", tagValue);
                    if (tag == null) continue;
                    tags.add(tag);
                }
            }
            return new PrimitiveData(classFQN, name, description, tags.toArray(new String[tags.size()]));
        }

        public void run(CompilationController cc) throws Exception {
            String annotationFQN = PrimitiveInfo.class.getCanonicalName();
            TypeMirror annotationType = this.getTypeMirror4Class(cc, annotationFQN);
            if (annotationType == null) {
                throw new ClassNotFoundException("Unable to find class " + annotationFQN);
            }
            this.result = new HashSet<PrimitiveData>();
            for (ElementHandle<TypeElement> element : this.set) {
                TypeElement type = (TypeElement)element.resolve((CompilationInfo)cc);
                if (this.isAbstract(type) || !this.isPublic(type)) continue;
                String classFQN = element.getQualifiedName();
                AnnotationMirror annotation = this.findAnnotationMirror(type, annotationType);
                if (annotation != null) {
                    this.result.add(this.getInfo(classFQN, annotation));
                    continue;
                }
                this.result.add(new PrimitiveData(classFQN, null, null, new String[0]));
            }
        }
    }
}

