/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.Goal;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.accept.AcceptAP2TA;
import cz.cuni.pogamut.posh.widget.accept.AcceptComp2TA;
import cz.cuni.pogamut.posh.widget.accept.AcceptTA2TA;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.kidview.NamedBasicWidget;
import cz.cuni.pogamut.posh.widget.kidview.SimpleCompetenceElementWidget;
import cz.cuni.pogamut.posh.widget.kidview.SimpleGoalWidget;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public class SimpleRoleCompetenceWidget
extends NamedBasicWidget<TriggeredAction> {
    Competence compNode;

    public SimpleRoleCompetenceWidget(PoshScene poshScene, TriggeredAction dataNode, PoshWidget<? extends PoshElement> parent, Competence compNode) {
        super(poshScene, dataNode, parent);
        this.compNode = compNode;
        this.compNode.addElementListener((PoshElementListener)this);
        this.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new CompInplaceEditor(dataNode, compNode)));
    }

    @Override
    protected PoshWidget.PropertyNode createPropertiesNode() {
        return new PoshWidget.PropertyNode((PoshElement)this.compNode, this);
    }

    public void regenerate() {
        this.deleteChildrenWidgets();
        this.createCh();
    }

    private void deleteChildrenWidgets() {
        for (PoshWidget<PoshElement> widget : this.getChildNodes()) {
            this.getPoshScene().deletePoshWidget(widget);
        }
    }

    private void createCh() {
        LinkedList<Competence> fringe = new LinkedList<Competence>();
        fringe.add(this.compNode);
        while (!fringe.isEmpty()) {
            PoshElement head = (PoshElement)fringe.poll();
            Set listeners = head.getElementListeners();
            for (PoshElementListener listener : listeners) {
                PoshWidget widget;
                if (!(listener instanceof PoshWidget) || !(widget = (PoshWidget)listener).isAncestor(this)) continue;
                for (PoshElement child : head.getChildDataNodes()) {
                    widget.nodeChanged(PoshTreeEvent.NEW_CHILD_NODE, child);
                }
            }
            fringe.addAll(head.getChildDataNodes());
        }
    }

    @Override
    protected PoshNodeType getType() {
        return PoshNodeType.COMPETENCE;
    }

    @Override
    protected List<AbstractMenuAction> createMenuActions() {
        LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();
        list.add(new AbstractMenuAction<Competence>("Add competence element", this.compNode){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newElement = this.getIdentifierFromDialog("Name of new choice");
                if (newElement == null) {
                    return;
                }
                try {
                    CompetenceElement element = LapElementsFactory.createCompetenceElement((String)newElement);
                    ((Competence)this.dataNode).addElement(element);
                }
                catch (DuplicateNameException ex) {
                    this.errorDialog(ex.getMessage());
                }
            }
        });
        int numCEs = ((TriggeredAction)this.getDataNode()).getParent().getNumberOfChildInstances(TriggeredAction.class);
        if (numCEs > 1) {
            list.add(new DeleteNodeAction("Delete element", this.getDataNode()));
        }
        return list;
    }

    @Override
    protected void addChildWidget(PoshElement dataNode) {
        if (dataNode instanceof Goal) {
            SimpleGoalWidget goalWidget = new SimpleGoalWidget(this.getPoshScene(), (Goal)dataNode, this);
            this.getChildNodes().add(0, goalWidget);
            this.getPoshScene().addPoshWidget(goalWidget, true);
        } else if (dataNode instanceof CompetenceElement) {
            SimpleCompetenceElementWidget compElemWidget = new SimpleCompetenceElementWidget(this.getPoshScene(), (CompetenceElement)dataNode, (PoshWidget<? extends PoshElement>)this);
            this.getChildNodes().add(compElemWidget);
            this.getPoshScene().addPoshWidget(compElemWidget, true);
        }
    }

    @Override
    public void elementPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("taName")) {
            this.changeTriggeredActionWidgets((TriggeredAction)this.getDataNode());
            this.doRepaint();
        }
        if (evt.getPropertyName().equals("cnName")) {
            this.changeTriggeredActionWidgets((TriggeredAction)this.getDataNode());
            this.doRepaint();
        }
    }

    @Override
    protected List<AbstractAcceptAction> getAcceptProviders() {
        LinkedList<AbstractAcceptAction> list = new LinkedList<AbstractAcceptAction>();
        list.add(new AcceptTA2TA((TriggeredAction)this.getDataNode()));
        list.add(new AcceptAP2TA((TriggeredAction)this.getDataNode()));
        list.add(new AcceptComp2TA((TriggeredAction)this.getDataNode()));
        return list;
    }

    @Override
    protected void deleteWidgetFromScene(PoshElement dataNode) {
        super.deleteWidgetFromScene(dataNode);
        this.compNode.removeElementListener((PoshElementListener)this);
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);
        try {
            PropertySupport.Reflection nameProp = new PropertySupport.Reflection((Object)this.compNode, String.class, "getNodeName", "setNodeName");
            nameProp.setName("cnName");
            nameProp.setDisplayName("Name of competence node");
            set.put(new Node.Property[]{nameProp});
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sheet;
    }

    protected static class CompInplaceEditor
    implements TextFieldInplaceEditor {
        private TriggeredAction action;
        private Competence competence;

        protected CompInplaceEditor(TriggeredAction action, Competence competence) {
            this.action = action;
            this.competence = competence;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return this.action.getName();
        }

        public void setText(Widget widget, String string) {
            String compName = this.competence.getName();
            String actionName = this.action.getName();
            try {
                this.competence.setName(string);
                this.action.setActionName(string);
            }
            catch (Exception ex) {
                try {
                    this.action.setActionName(actionName);
                    this.competence.setName(compName);
                }
                catch (Exception ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                }
            }
        }
    }
}

