/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget.structure;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.PoshWidgetChildren;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.structure.StrWidgetFactory;
import java.awt.Point;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.widget.Widget;

public abstract class StrBasicWidget<T extends PoshElement>
extends PoshWidget<T> {
    protected StrBasicWidget(PoshScene poshScene, T dataNode, PoshWidget parent) {
        super(poshScene, dataNode, parent);
    }

    protected abstract List<AbstractMenuAction> createMenuActions();

    @Override
    public final JPopupMenu getPopupMenu(Widget arg0, Point arg1) {
        JPopupMenu menu = new JPopupMenu("Popup menu");
        List<AbstractMenuAction> actionList = this.createMenuActions();
        for (AbstractMenuAction action : actionList) {
            JMenuItem item = new JMenuItem(action.getDescription());
            item.addActionListener(action);
            menu.add(item);
        }
        return menu;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void nodeChanged(PoshTreeEvent event, PoshElement dataNode) {
        if (event == PoshTreeEvent.NEW_CHILD_NODE) {
            if (!this.getPoshScene().isInMainLayer(this)) throw new RuntimeException(" PoshError: widget not part of layer, but asked for child");
            this.addChildWidget(dataNode);
        } else if (event == PoshTreeEvent.NODE_DELETED) {
            this.deleteWidgetFromScene(dataNode);
        } else {
            if (event != PoshTreeEvent.CHILD_NODE_MOVED) throw new IllegalArgumentException("Event " + event + " shouldn't exist.");
            this.moveChildWidget(dataNode);
        }
        this.doRepaint();
    }

    protected abstract void addChildWidget(PoshElement var1);

    protected void moveChildWidget(PoshElement movedChildDN) {
        this.synchronizeDataNodeWidgets(null);
    }

    protected void deleteWidgetFromScene(PoshElement dataNode) {
        if (this.getDataNode() != dataNode) {
            throw new RuntimeException("Associated datanode " + this.getDataNode().getClass() + " is not matching to passed one" + dataNode.getClass());
        }
        this.deleteWidgetTree(this);
    }

    protected void deleteWidgetTree(PoshWidget widget) {
        PoshWidget[] children;
        for (PoshWidget child : children = widget.getChildNodes().toArray(new PoshWidget[0])) {
            this.deleteWidgetTree(child);
        }
        widget.getChildNodes().clear();
        this.getPoshScene().deletePoshWidget(widget);
        this.getDataNode().getRootNode().removeListenersFromTree((PoshElementListener)widget);
        PoshWidget widgetParent = widget.getParent();
        if (widgetParent == null) {
            return;
        }
        widgetParent.getChildNodes().remove((Object)widget);
    }

    private boolean isElementInWidgets(PoshElement element, Collection<PoshWidget> widgets) {
        for (PoshWidget widget : widgets) {
            if (widget.getDataNode() != element) continue;
            return true;
        }
        return false;
    }

    private List<PoshWidget> getUnassociatedWidgets(List<PoshElement> elements, List<PoshWidget> widgets) {
        LinkedList<PoshWidget> unassociated = new LinkedList<PoshWidget>();
        for (PoshWidget widget : widgets) {
            if (elements.contains(widget.getDataNode())) continue;
            unassociated.add(widget);
        }
        return unassociated;
    }

    protected void synchronizeDataNodeWidgets(PoshElement newChild) {
        Object dn = this.getDataNode();
        List dnChildren = dn.getChildDataNodes();
        PoshWidgetChildren widgetChildren = this.getChildNodes();
        LinkedList<PoshElement> missingDN = new LinkedList<PoshElement>();
        for (PoshElement dnChild : dnChildren) {
            if (this.isElementInWidgets(dnChild, widgetChildren)) continue;
            missingDN.add(dnChild);
        }
        List<PoshWidget> extraWidgets = this.getUnassociatedWidgets(dnChildren, widgetChildren);
        for (PoshWidget extraWidget : extraWidgets) {
            this.deleteWidgetTree(extraWidget);
        }
        for (PoshElement newDN : missingDN) {
            PoshWidget newWidget = StrWidgetFactory.createWidgetFromDN(this.getPoshScene(), newDN, this);
            this.newChildWidget(newWidget);
        }
        if (widgetChildren.size() != dnChildren.size()) {
            throw new RuntimeException("Size is not equal \n" + this.getDNList() + this.getWidgetList());
        }
        PoshWidget[] widgetsArray = widgetChildren.toArray(new PoshWidget[0]);
        int i = 0;
        for (PoshElement dnChild : dnChildren) {
            for (PoshWidget widget : widgetsArray) {
                if (widget.getDataNode() != dnChild) continue;
                widgetChildren.set(i, widget);
                ++i;
            }
        }
        this.isSynchronized();
    }

    public void isSynchronized() {
        Object associatedDN = this.getDataNode();
        if (associatedDN == null) {
            throw new RuntimeException("Widget " + this.getName() + " " + this.getCommentText() + " doesn't have an associated data node.");
        }
        List dnChildren = associatedDN.getChildDataNodes();
        PoshWidgetChildren widgetChildren = this.getChildNodes();
        if (dnChildren.size() != widgetChildren.size()) {
            throw new RuntimeException("Widget " + this.getName() + " " + this.getCommentText() + " doesn't have an associated data node.\n" + this.getDNList() + this.getWidgetList());
        }
        int i = 0;
        for (PoshElement dnChild : dnChildren) {
            if (((PoshWidget)((Object)widgetChildren.get(i))).getDataNode() != dnChild) {
                throw new RuntimeException("Widget " + this.getName() + " " + this.getCommentText() + " has child with widget-datanode michmatch at " + i + "\n" + this.getDNList() + this.getWidgetList());
            }
            ++i;
        }
    }

    protected String getWidgetList() {
        PoshWidgetChildren widgetChildren = this.getChildNodes();
        String res = "List of widgets" + widgetChildren.size() + "(" + ((Object)((Object)this)).getClass().getSimpleName() + ")\n";
        for (PoshWidget widget : widgetChildren) {
            res = res + " * " + widget.getName() + ' ' + widget.getCommentText() + '(' + ((Object)((Object)widget)).getClass().getSimpleName() + ")\n";
        }
        return res;
    }

    protected String getDNList() {
        List dnChildren = this.getDataNode().getChildDataNodes();
        String res = "List of data nodes " + dnChildren.size() + "(" + this.getDataNode().getClass().getSimpleName() + ")\n";
        for (PoshElement dn : dnChildren) {
            res = res + " * " + dn.getDisplayName() + ' ' + dn.getClass().getSimpleName() + '\n';
        }
        return res;
    }

    protected void newChildWidget(PoshWidget newChild) {
        this.getChildNodes().add(newChild);
        this.getPoshScene().addPoshWidget(newChild, true);
    }
}

