/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.DrivePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.Freq;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.elements.Triggers;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.accept.AcceptDrive2Drive;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.kidview.SimpleBasicWidget;
import cz.cuni.pogamut.posh.widget.kidview.SimpleTriggersWidget;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

class SimpleDriveWidget
extends SimpleBasicWidget<DrivePriorityElement> {
    private DriveElement driveElement;

    SimpleDriveWidget(PoshScene scene, DrivePriorityElement associatedDataNode, PoshWidget parent) {
        super(scene, associatedDataNode, parent);
    }

    @Override
    protected PoshWidget.PropertyNode createPropertiesNode() {
        Object element = this.getDataNode();
        if (this.driveElement != null) {
            element = this.driveElement;
        }
        return new PoshWidget.PropertyNode((PoshElement)element, this);
    }

    @Override
    protected PoshNodeType getType() {
        return PoshNodeType.DRIVE_ELEMENT;
    }

    @Override
    protected List<AbstractMenuAction> createMenuActions() {
        LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();
        int numDrives = ((DrivePriorityElement)this.getDataNode()).getParent().getNumberOfChildInstances(DrivePriorityElement.class);
        if (numDrives > 1) {
            list.add(new DeleteNodeAction("Delete drive", (PoshElement)this.getDataNode()));
        }
        return list;
    }

    @Override
    protected void addChildWidget(PoshElement dataNode) {
        if (dataNode instanceof DriveElement) {
            assert (this.driveElement == null);
            this.driveElement = (DriveElement)dataNode;
            dataNode.addPoshTreeChangeListener((PoshElementListener)this);
            this.setHeadlineText(dataNode.getDisplayName());
            this.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new DriveElementInplaceEditor(this.driveElement)));
        } else if (dataNode instanceof Triggers) {
            SimpleTriggersWidget triggersWidget = new SimpleTriggersWidget(this.getPoshScene(), dataNode, (PoshWidget)this);
            this.getChildNodes().add(triggersWidget);
            this.getPoshScene().addPoshWidget(triggersWidget, true);
        } else if (dataNode instanceof TriggeredAction) {
            this.addTriggeredActionWidgets((TriggeredAction)dataNode);
        } else {
            throw new RuntimeException("Drive " + this.getName() + " got new child: " + dataNode.getClass().getName() + " but no such class accepted.");
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("deName")) {
            this.setHeadlineText((String)evt.getNewValue());
            this.doRepaint();
        }
    }

    @Override
    protected List<AbstractAcceptAction> getAcceptProviders() {
        LinkedList<AbstractAcceptAction> list = new LinkedList<AbstractAcceptAction>();
        list.add(new AcceptDrive2Drive((DrivePriorityElement)this.getDataNode()));
        return list;
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);
        try {
            PropertySupport.Reflection nameProp = new PropertySupport.Reflection((Object)this.driveElement, String.class, "getDriveName", "setDriveName");
            PropertySupport.Reflection freqNumProp = new PropertySupport.Reflection((Object)this.driveElement, Double.class, "getFreqNum", "setFreqNum");
            PropertySupport.Reflection freqUnitsProp = new PropertySupport.Reflection((Object)this.driveElement, Integer.class, "getFreqUnits", "setFreqUnits");
            PropertySupport.Reflection commentProp = new PropertySupport.Reflection((Object)this.driveElement, String.class, "getComment", "setComment");
            int[] intValues = new int[Freq.FreqUnits.values().length];
            String[] stringKeys = new String[Freq.FreqUnits.values().length];
            int index = 0;
            for (Freq.FreqUnits unit : Freq.FreqUnits.values()) {
                intValues[index] = unit.getId();
                stringKeys[index] = unit.toString();
                ++index;
            }
            freqUnitsProp.setValue("intValues", (Object)intValues);
            freqUnitsProp.setValue("stringKeys", (Object)stringKeys);
            nameProp.setName("deName");
            freqNumProp.setName("deFreqNum");
            freqUnitsProp.setName("deFreqUnits");
            commentProp.setName("deComment");
            nameProp.setDisplayName("Name of drive element");
            freqNumProp.setDisplayName("Frequency ammount");
            freqUnitsProp.setDisplayName("Units of frequency");
            commentProp.setDisplayName("Comment");
            set.put(new Node.Property[]{nameProp, freqNumProp, freqUnitsProp, commentProp});
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sheet;
    }

    private static class DriveElementInplaceEditor
    implements TextFieldInplaceEditor {
        private DriveElement de;

        private DriveElementInplaceEditor(DriveElement de) {
            this.de = de;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return this.de.getDisplayName();
        }

        public void setText(Widget widget, String newDEName) {
            this.de.setDriveName(newDEName);
        }
    }
}

