/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidgetChildren;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.kidview.SimpleRoleCompetenceWidget;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.AcceptProvider;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.windows.TopComponent;

public abstract class PoshWidget<T extends PoshElement>
extends Widget
implements PoshElementListener,
PopupMenuProvider {
    private static final Router orthoRouter = RouterFactory.createOrthogonalSearchRouter((LayerWidget[])new LayerWidget[0]);
    private T dataNode;
    private ConnectionWidget connection;
    private PoshWidget parent;
    private PoshWidgetChildren children;
    private boolean isCollapsed = false;
    private String headlineString = "[NOT SET]";
    private String commentString = "[NOT SET]";
    protected PropertyNode propertyNode = null;
    public final int width = 150;
    public final int height = 35;
    private final int arrowWidth = 10;
    private static Font boldFont = new Font("Helvetica", 1, 12);
    private static Font italicFont = new Font("Helvetica", 2, 10);

    protected PoshWidget(PoshScene scene, T node, PoshWidget parentWidget) {
        super((Scene)scene);
        this.parent = parentWidget;
        this.dataNode = node;
        this.dataNode.addPoshTreeChangeListener((PoshElementListener)this);
        this.children = new PoshWidgetChildren();
        this.setHeadlineText(this.getName());
        this.setCommentText(this.getType().toString());
        SelectProvider collapseProvider = new SelectProvider(){

            public boolean isAimingAllowed(Widget arg0, Point arg1, boolean arg2) {
                return false;
            }

            public boolean isSelectionAllowed(Widget widget, Point localPosition, boolean invertSelection) {
                return localPosition.x > 140;
            }

            public void select(Widget arg0, Point arg1, boolean arg2) {
                PoshWidget.this.setCollapsed(!PoshWidget.this.isCollapsed);
            }
        };
        this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)collapseProvider));
        for (AbstractAcceptAction provider : this.getAcceptProviders()) {
            this.getActions().addAction(ActionFactory.createAcceptAction((AcceptProvider)provider));
        }
        if (this.getParent() != null) {
            this.connection = new ConnectionWidget((Scene)scene);
            Anchor parentAnchor = AnchorFactory.createDirectionalAnchor((Widget)this.getParent(), (AnchorFactory.DirectionalAnchorKind)AnchorFactory.DirectionalAnchorKind.HORIZONTAL);
            Anchor nodeAnchor = AnchorFactory.createDirectionalAnchor((Widget)this, (AnchorFactory.DirectionalAnchorKind)AnchorFactory.DirectionalAnchorKind.HORIZONTAL);
            this.connection.setSourceAnchor(parentAnchor);
            this.connection.setTargetAnchor(nodeAnchor);
            this.connection.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
            this.connection.setRouter(orthoRouter);
        }
    }

    public final PoshWidgetChildren getChildNodes() {
        return this.children;
    }

    public String getHeadlineText() {
        return this.headlineString;
    }

    public String getCommentText() {
        return this.commentString;
    }

    protected void setCommentText(String text) {
        this.commentString = text;
        this.updateToolTipText();
    }

    public boolean isAncestor(SimpleRoleCompetenceWidget ancestorWidget) {
        for (PoshWidget parentWidget = this; parentWidget != null; parentWidget = parentWidget.getParent()) {
            if (parentWidget != ancestorWidget) continue;
            return true;
        }
        return false;
    }

    protected void setHeadlineText(String text) {
        this.headlineString = text;
        this.updateToolTipText();
    }

    private void updateToolTipText() {
        this.setToolTipText(this.getHeadlineText() + "\n" + this.getCommentText());
    }

    protected abstract List<AbstractAcceptAction> getAcceptProviders();

    protected abstract PoshNodeType getType();

    public String getName() {
        return this.getDataNode().getDisplayName();
    }

    public abstract JPopupMenu getPopupMenu(Widget var1, Point var2);

    public T getDataNode() {
        return this.dataNode;
    }

    protected void setDataNode(T associatedDataNode) {
        this.dataNode = associatedDataNode;
    }

    public PoshScene getPoshScene() {
        return (PoshScene)super.getScene();
    }

    public PoshWidget getParent() {
        return this.parent;
    }

    protected Sheet createSheet() {
        return Sheet.createDefault();
    }

    protected final Node getPropertiesNode() {
        if (this.propertyNode == null) {
            this.propertyNode = this.createPropertiesNode();
        }
        return this.propertyNode;
    }

    protected PropertyNode createPropertiesNode() {
        return new PropertyNode((PoshElement)this.getDataNode(), this);
    }

    public void select(Widget arg0, Point arg1, boolean arg2) {
        TopComponent tc = TopComponent.getRegistry().getActivated();
        this.getPoshScene().setFocusedWidget(this);
        if (tc != null) {
            tc.setActivatedNodes(new Node[]{this.getPropertiesNode()});
        }
    }

    public final ConnectionWidget getConnection() {
        return this.connection;
    }

    public String toString() {
        return this.getType().toString() + " " + this.headlineString;
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    public void setCollapsed(boolean newCollapsedState) {
        this.isCollapsed = newCollapsedState;
        this.getPoshScene().consolidate();
    }

    protected void doRepaint() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaint();
            this.getScene().validate();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PoshWidget.this.repaint();
                    PoshWidget.this.getScene().validate();
                }
            });
        }
    }

    protected Rectangle calculateClientArea() {
        return new Rectangle(0, 0, 150, 35);
    }

    protected void paintWidget() {
        Graphics2D g = this.getGraphics();
        g.setColor(this.getType().getColor());
        g.fillRect(0, 0, 150, 35);
        int collapseWidth = 0;
        if (!this.getChildNodes().isEmpty()) {
            collapseWidth = 10;
            g.setColor(this.getType().getColor().darker());
            if (this.isCollapsed()) {
                g.fillPolygon(new int[]{140, 150, 140}, new int[]{0, 17, 35}, 3);
            } else {
                g.fillPolygon(new int[]{150, 140, 150}, new int[]{0, 17, 35}, 3);
            }
        }
        g.setColor(Color.BLACK);
        int xofs = 4;
        int maxTextWidth = 150 - xofs - collapseWidth;
        FontMetrics boldMetrics = g.getFontMetrics(boldFont);
        String renderedHeadlineString = this.getFittingString(this.getHeadlineText(), boldMetrics, maxTextWidth);
        g.setFont(boldFont);
        g.drawString(renderedHeadlineString, xofs, boldMetrics.getHeight());
        FontMetrics italicMetrics = g.getFontMetrics(italicFont);
        String renderCommentString = this.getFittingString(this.getCommentText(), italicMetrics, maxTextWidth);
        g.setFont(italicFont);
        g.drawString(renderCommentString, xofs, boldMetrics.getHeight() + italicMetrics.getHeight());
    }

    private String getFittingString(String text, FontMetrics metrics, int maxWidth) {
        if (metrics.stringWidth(text) < maxWidth) {
            return text;
        }
        for (int index = text.length() - 1; index > 0; --index) {
            String shorter = text.substring(0, index).concat("...");
            if (metrics.stringWidth(shorter) >= maxWidth) continue;
            return shorter;
        }
        return "...";
    }

    protected static class PropertyNode
    extends AbstractNode {
        private PoshWidget widget;

        public PropertyNode(PoshElement element, PoshWidget widget) {
            super(Children.LEAF);
            this.widget = widget;
        }

        protected Sheet createSheet() {
            return this.widget.createSheet();
        }
    }
}

