package cz.cuni.pogamut.posh.widget.structure;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.SolTime.TimeUnits;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.menuactions.AddCPE2Comp;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;
import org.openide.nodes.Node.Property;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

/**
 *
 * @author Honza
 */
public class StrCompNodeWidget extends StrBasicWidget<Competence> {
	public StrCompNodeWidget(PoshScene poshScene, Competence dataNode, PoshWidget parent) {
		super(poshScene, dataNode, parent);
	}

	@Override
	protected List<AbstractMenuAction> createMenuActions() {
		LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();

		list.add(new AddCPE2Comp(getDataNode()));

                if (getDataNode().getParent().getNumberOfChildInstances(getDataNode().getClass()) > 1) {
                    list.add(new DeleteNodeAction("Delete", getDataNode()));
                }
		return list;
	}

	@Override
	protected void addChildWidget(PoshElement dataNode) {
		synchronizeDataNodeWidgets(dataNode);
	}

	@Override
	protected List<AbstractAcceptAction> getAcceptProviders() {
		// todo: implement
		return new LinkedList<AbstractAcceptAction>();
	}

	@Override
	protected PoshNodeType getType() {
		return PoshNodeType.COMPETENCE;
	}

        @Override
	public void propertyChange(PropertyChangeEvent evt) {
                if (Competence.cnName.equals(evt.getPropertyName())) {
                    this.setHeadlineText((String)evt.getNewValue());
                }
	}


}
