/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget;

import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.pogamut.posh.widget.DnDMoveProvider;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.PoshWidgetChildren;
import java.awt.Point;
import java.util.List;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class PoshScene
extends GraphScene {
    private LayerWidget mainLayer;
    private LayerWidget connectionLayer;
    private LayerWidget dndLayer;
    private PoshWidget rootWidget;
    private static final int slotInsetX = 35;
    private static final int slotInsetY = 15;

    public PoshScene() {
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_CHILDREN);
        this.getActions().addAction(ActionFactory.createPanAction());
        this.getActions().addAction(ActionFactory.createZoomAction((double)1.25, (boolean)false));
        this.mainLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.mainLayer);
        this.connectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.connectionLayer);
        this.dndLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.dndLayer);
        this.validate();
    }

    public void clearPoshWidgets() {
        if (this.getRootWidget() != null) {
            this.clearPoshSubTree(this.getRootWidget());
            this.rootWidget = null;
        }
        this.validate();
    }

    public boolean isInMainLayer(PoshWidget widget) {
        return this.mainLayer.getChildren().contains((Object)widget);
    }

    private void clearPoshSubTree(PoshWidget node) {
        PoshWidgetChildren childNodes = node.getChildNodes();
        if (childNodes != null) {
            for (PoshWidget childNode : childNodes) {
                this.clearPoshSubTree(childNode);
            }
        }
        this.deletePoshWidget(node);
        this.validate();
    }

    public void setParsingError() {
        this.connectionLayer.setVisible(false);
        this.mainLayer.setVisible(false);
        this.validate();
    }

    public void consolidate() {
        this.validate();
        this.consolidate(this.rootWidget, 0, 0, false);
        this.validate();
    }

    public void deletePoshWidget(PoshWidget widget) {
        widget.getDataNode().getRootNode().removeListenersFromTree((PoshElementListener)widget);
        if (!this.mainLayer.getChildren().contains((Object)widget)) {
            System.out.println("Widget is not child of mainLayer. " + widget.getName() + " " + (Object)((Object)widget.getType()) + ". Probably widget representing multiple data nodes.");
            this.validate();
            return;
        }
        this.mainLayer.removeChild((Widget)widget);
        if (widget.getConnection() != null) {
            this.connectionLayer.removeChild((Widget)widget.getConnection());
        }
        this.validate();
    }

    private int consolidate(PoshWidget root, int x, int y, boolean ancestorCollapsed) {
        Point origin = new Point(x * (root.width + 35), y * (root.height + 15));
        if (root.getPreferredLocation() == null) {
            root.setPreferredLocation(origin);
        } else {
            this.getScene().getSceneAnimator().animatePreferredLocation((Widget)root, origin);
        }
        int height = 0;
        boolean rootCollapsed = ancestorCollapsed;
        if (root.isCollapsed()) {
            rootCollapsed = true;
        }
        for (PoshWidget child : root.getChildNodes()) {
            height += this.consolidate(child, x + 1, y + height, rootCollapsed);
        }
        if (root.getConnection() != null) {
            root.getConnection().setVisible(!ancestorCollapsed);
            this.validate();
        }
        root.setVisible(!ancestorCollapsed);
        this.validate();
        if (root.getChildNodes().isEmpty()) {
            return 1;
        }
        if (root.isCollapsed()) {
            return 1;
        }
        return height;
    }

    public PoshWidget getRootWidget() {
        return this.rootWidget;
    }

    public void setRootWidget(PoshWidget node) {
        this.connectionLayer.setVisible(true);
        this.mainLayer.setVisible(true);
        if (this.rootWidget != null) {
            this.deletePoshWidget(this.rootWidget);
        }
        this.rootWidget = node;
        node.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)node));
        node.getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)ActionFactory.createFreeMoveStrategy(), (MoveProvider)new DnDMoveProvider(this)));
        this.mainLayer.addChild((Widget)node);
        this.validate();
    }

    public void addPoshWidget(PoshWidget newWidget, boolean consolidate) {
        newWidget.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)newWidget));
        newWidget.getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)ActionFactory.createFreeMoveStrategy(), (MoveProvider)new DnDMoveProvider(this)));
        this.mainLayer.addChild((Widget)newWidget);
        this.connectionLayer.addChild((Widget)newWidget.getConnection());
        this.validate();
        if (consolidate) {
            this.consolidate();
        }
    }

    protected Widget attachNodeWidget(Object node) {
        return null;
    }

    protected Widget attachEdgeWidget(Object node) {
        return null;
    }

    protected void attachEdgeSourceAnchor(Object arg0, Object arg1, Object arg2) {
    }

    protected void attachEdgeTargetAnchor(Object arg0, Object arg1, Object arg2) {
    }

    protected void addGhostWidget(Widget ghost) {
        this.dndLayer.addChild(ghost);
    }

    protected void removeGhostWidget(Widget ghost) {
        this.dndLayer.removeChild(ghost);
    }

    protected List<Widget> getPoshWidgets() {
        return this.mainLayer.getChildren();
    }
}

