/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.view;

import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.pogamut.posh.PoshEditorSupport;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.structure.StrRootWidget;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.awt.UndoRedo;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class StructureEditor
implements MultiViewElement {
    private PoshEditorSupport support;
    private PoshScene scene;
    private JScrollPane scrollPane;
    private JToolBar toolbar;

    public StructureEditor(PoshEditorSupport support) {
        this.support = support;
        this.scene = new PoshScene();
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.scene.createView());
    }

    public void refresh(PoshPlan plan) {
        this.scene.clearPoshWidgets();
        this.scene.setRootWidget(new StrRootWidget(this.scene, plan, null));
        plan.emitTree();
    }

    public JComponent getVisualRepresentation() {
        return this.scrollPane;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
        }
        return this.toolbar;
    }

    public Action[] getActions() {
        return this.support.getDataObject().getNodeDelegate().getActions(false);
    }

    public Lookup getLookup() {
        return this.support.getDataObject().getNodeDelegate().getLookup();
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void componentShowing() {
        try {
            PoshParser parser = new PoshParser(this.support.getInputStream());
            this.refresh(parser.parsePlan());
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void componentHidden() {
    }

    public void componentActivated() {
    }

    public void componentDeactivated() {
    }

    public UndoRedo getUndoRedo() {
        return null;
    }

    public void setMultiViewCallback(MultiViewElementCallback mvec) {
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }
}

