package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import java.awt.Point;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.widget.Widget;


/**
 * Basic widget for KidView. 
 * 
 * Events are handled individually in methods 
 *   addChildWidget
 *   deleteWidgetFromScene
 *   moveChildWidget
 * 
 * @author Honza
 */
public abstract class SimpleBasicWidget<T extends PoshElement> extends PoshWidget<T> {

	protected SimpleBasicWidget(PoshScene poshScene, T dataNode, PoshWidget parent) {
		super(poshScene, dataNode, parent);
	}

	@Override
	public final void nodeChanged(PoshTreeEvent event, PoshElement dataNode) {
		if (event == PoshTreeEvent.NEW_CHILD_NODE) {
			if (this.getPoshScene().isInMainLayer(this)) {
				this.addChildWidget(dataNode);
			} else {
				System.out.println(" PoshError: widget not part of layer, but asked for child");
			}
		} else if (event == PoshTreeEvent.NODE_DELETED) {
			this.deleteWidgetFromScene(dataNode);
		} else if (event == PoshTreeEvent.CHILD_NODE_MOVED) {
			this.moveChildWidget(dataNode);
		} else {
			throw new IllegalArgumentException("Argument (" + event + ") shouldn't exist.");
		}
		doRepaint();
	}


	/**
	 * Key functionm that is called when dataNode is moved
	 * Since KidView closely resembles PoshPlan structure, just one function
	 * for all should be enough.
	 * 
	 * We don't know what or where was it moved.
	 * @param movedChildDN data node that was moved in POSH plan.
	 */
	protected void moveChildWidget(PoshElement movedChildDN) {
/*		System.out.println("");
		System.out.println(getDataNode().getClass().getSimpleName() + ": " + getDataNode().getDisplayName() + " mas moved child " + movedChildDN.getDisplayName());
		System.out.println("-------------------------------");
*/		// what children do I have?
		List<PoshWidget> widgetChildren = getChildNodes();
		List<PoshElement> nodeChildren = movedChildDN.getParent().getChildDataNodes();

/*		for (PoshElement n : nodeChildren) {
			System.out.println("  NC " + n.getDisplayName());
		}
		System.out.println("");

		//FIXME: I can be RoleWidget like SimpleAPRoleWidget, but in reality, my

		for (PoshWidget w : widgetChildren) {
			System.out.println("  WC " + w.getName());
		}

		System.out.println("");

		System.out.println("DataNode moved: " + movedChildDN.getDisplayName());
*/
		// fixme: border cases when movedChildDN is not in lists
		// find new position in node
		int movedDataNodeIndex =
			this.getIndexOfElement(nodeChildren, movedChildDN);
//		System.out.println("New position of moved data node: " + movedDataNodeIndex);

		// Get widget currently associated with passed dataNode
		PoshWidget dataNodeAssociatedWidget =
			this.getAssociatedWidget(widgetChildren, movedChildDN);
//		System.out.println("Associated widget: " + dataNodeAssociatedWidget.toString());


		// find position in widget
		int currentDataNodeWidgetIndex =
			this.getIndexOfElement(widgetChildren, dataNodeAssociatedWidget);

//		System.out.println("Original position representing DN: " + currentDataNodeWidgetIndex);
//		System.out.println("New position position of widget representing DN: " + movedDataNodeIndex);

		// now move
		this.moveChildWidgetNode(currentDataNodeWidgetIndex, movedDataNodeIndex);
	}

	/**
	 * This is called when node is added as child
	 * @param dataNode
	 */
	protected abstract void addChildWidget(PoshElement dataNode);

	/**
	 * Common function for deleting widget from scene
	 */
	protected void deleteWidgetFromScene(PoshElement dataNode) {
		// delete all children widgets
		deleteWidgetSubtree(this);
		// delete this widget

		this.getPoshScene().deletePoshWidget(this);
		this.getDataNode().removePoshTreeChangeListener(this);

		PoshPlan root = this.getDataNode().getRootNode();

		root.removeListenersFromTree(this);

		if (this.getParent() != null) {
			this.getParent().getChildNodes().remove(this);
		}
		this.getPoshScene().consolidate();
	}

	/**
	 * Delete all widgets from tree with root <code>widget</code> =
	 * remove all children from scene and children will remove itself from
	 * listeners of the POSh tree.
	 *
	 * @param widget
	 */
	private void deleteWidgetSubtree(PoshWidget widget) {
		for (PoshWidget child : widget.getChildNodes()) {
//			System.out.println(" .. Delete " + child.getName());
			deleteWidgetSubtree(child);
			this.getPoshScene().deletePoshWidget(child);
			this.getDataNode().removePoshTreeChangeListener(child);
		}
		widget.getChildNodes().clear();
	}

	/**
	 * Create actions for context menu.
	 * @return not null, list of actions for context menu
	 */
	abstract protected List<AbstractMenuAction> createMenuActions();

	@Override
	final public JPopupMenu getPopupMenu(Widget arg0, Point arg1) {
		JPopupMenu menu = new JPopupMenu("Popup menu");

		// create action list
		List<AbstractMenuAction> actionList = createMenuActions();

		for (AbstractMenuAction action : actionList) {
			JMenuItem item = new JMenuItem(action.getDescription());
			item.addActionListener(action);
			menu.add(item);
		}

		return menu;
	}

	/**
	 * Go through list of all Competences and check is Action name
	 * from Triggered action is Competence
	 * 
	 * @param ta
	 * @return null is no such competenceNode found, else found node
	 */
	private Competence isComp(TriggeredAction ta) {
		String name = ta.getActionName();
		PoshPlan rootNode = ta.getRootNode();

		for (Competence competence : rootNode.getCompetences()) {
			if (competence.getNodeName().equals(name)) {
				return competence;
			}
		}
		return null;
	}

	/**
	 * Go through list of all APs and check is Action name
	 * from Triggered action is an AP.
	 * 
	 * @param ta
	 * @return null is not such ap found
	 */
	private ActionPattern isAP(TriggeredAction ta) {
		String name = ta.getActionName();
		PoshPlan rootNode = ta.getRootNode();

		for (ActionPattern ap : rootNode.getActionPatterns()) {
			if (ap.getNodeName().equals(name)) {
				return ap;
			}
		}

		return null;
	}

	/**
	 * Add correct widget that is going to represent triggered action
	 * (competence, action pattern or action) to the place of the tree.
	 *
	 * This doesn't add one widget, but it determines what is dataNode
	 * representing (C, AP or action) and adds all widgets of that representaion
	 * to the tree. Action has only one widget,but other two can be intervened and
	 * can create a really big new subtree instead of just one widget.
	 *
	 * Add this new subtree to the last place of your children. *
	 *
	 * @param dataNode triggered widget
	 */
	protected void addTriggeredActionWidgets(TriggeredAction dataNode) {
		int pos = this.getChildNodes().size();
		addTriggeredActionWidgets(pos, dataNode);

	}

	/**
	 * Take a string of widgets from current widget to the root and if
	 * one of the widgets from the string has associated data node that is Triggered Action
	 * and has same name as dataNode return true
	 *
	 * @param dataNode tested TriggeredAction
	 * @return true if there is a cycle in the list of triggered actions
	 */
	protected boolean checkForTACircle(TriggeredAction dataNode) {
		PoshWidget p = this;
		while (p != null) {
			if (p.getDataNode() != null && p.getDataNode() instanceof TriggeredAction) {
				TriggeredAction pTA = (TriggeredAction) p.getDataNode();
				if (pTA.getActionName().equals(dataNode.getActionName())) {
					return true;
				}
			}
			p = p.getParent();
		}

		return false;

	}

	/**
	 * Add correct widget that is going to represent triggered action
	 * (competence, action pattern or action) to the place of the tree.
	 *
	 * This doesn't add one widget, but it determines what is dataNode
	 * representing (C, AP or action) and adds all widgets of that representaion
	 * to the tree. Action has only one widget,but other two can be intervened and
	 * can create a really big new subtree instead of just one widget.
	 *
	 * @param dataNode triggered widget
	 */
	protected void addTriggeredActionWidgets(int index, TriggeredAction dataNode) {
		ActionPattern apNode;
		Competence compNode;

		if ((apNode = isAP(dataNode)) != null) {
			// Add child widget that will represent AP (SimpleRoleAPW) 
			// to this drive.

			SimpleRoleActionPatternWidget actionRoleWidget = new SimpleRoleActionPatternWidget(getPoshScene(), dataNode, this, apNode);
			this.getChildNodes().add(index, actionRoleWidget);
			this.getPoshScene().addPoshWidget(actionRoleWidget, true);
			// this will create proper child widget nodes and all that other stuff.
			actionRoleWidget.regenerate();
		} else if ((compNode = isComp(dataNode)) != null) {

			SimpleRoleCompetenceWidget competenceWidget = new SimpleRoleCompetenceWidget(getPoshScene(), dataNode, this, compNode);

			this.getChildNodes().add(index, competenceWidget);
			this.getPoshScene().addPoshWidget(competenceWidget, true);
			// this will create proper child widget nodes and all that other stuff.
			competenceWidget.regenerate();

		} else {
			//		System.out.println(" Drive " + this.headline.getLabel() + "'s child '" + dataNode.getActionName() + "' is NOT AP or Competence");
			// pass an action
			SimpleRoleActionWidget actionRoleWidget = new SimpleRoleActionWidget(getPoshScene(), dataNode, this);
			this.getChildNodes().add(index, actionRoleWidget);
			this.getPoshScene().addPoshWidget(actionRoleWidget, true);
			// FIXME: Maybe property listener would suffice
			dataNode.addPoshTreeChangeListener(actionRoleWidget);
		}
	}

	/**
	 * Take this widget, remove it and on the original place where this widget
	 * was place proper representaion of trigggered action (by <code>addTriggeredActionWidgets</code>)
	 * 
	 * @param ta triggered action we are adding to place of this widget.
	 */
	protected void changeTriggeredActionWidgets(TriggeredAction ta) {
		SimpleBasicWidget parent = (SimpleBasicWidget) this.getParent();

		// find position in parent
		int pos = 0;
		for (PoshWidget child : parent.getChildNodes()) {
			if (child == this) {
				// fixme: this is a workaround for double calling of propertyChanged
				parent.addTriggeredActionWidgets(pos, ta);
				this.getDataNode().removePoshTreeChangeListener(this);
				this.deleteWidgetFromScene(getDataNode());

				getScene().validate();
				break;
			}
			pos++;
		}

	}

	/**
	 * Get indexof element in the list that has same reference as the passed object.
	 *
	 * Throw runtimeexception if object is not in the list.
	 * 
	 * @param list List in which we are looking.
	 * @param element object we are looking for in the list.
	 * @return index of object in the list
	 */
	final protected int getIndexOfElement(List list, Object element) {
		int position = 0;

		for (Object listElement : list) {
			if (listElement == element) {
				return position;
			}
			position++;
		}
		throw new RuntimeException("Object " + element + " not found in list.");
	}

	/**
	 * Get widget from the <tt>list</tt> that has <tt>dataNode</tt>as associated node.
	 *
	 * Throw runtime exception if no such widget found.
	 * 
	 * @param list
	 * @param dataNode
	 * @return widget that is in the list and that is associated with dataNode
	 */
	final protected PoshWidget getAssociatedWidget(List<PoshWidget> list, PoshElement dataNode) {
		for (PoshWidget w : list) {
			if (w.getDataNode() == dataNode) {
				return w;
			}
		}
		throw new RuntimeException("DataNode " + dataNode + " not found in list.");
	}

	/**
	 * Move element in getChildNodes() 
	 * @param from index in the list of children the child is moved from
	 * @param to index in the list of children the child is moved to
	 */
	final protected void moveChildWidgetNode(int from, int to) {
//		System.out.println("== Moving widget " + this.getName() + " from position " + from + " to " + to + " ==");
		PoshWidget movingWidget = getChildNodes().get(from);
//		System.out.println(" Moving widget " + movingWidget.toString());
		getChildNodes().add(to, movingWidget);

//		System.out.println(" Adding moving widget to position " + to);

		for (PoshWidget w : getChildNodes()) {
			System.out.println("  W " + w.toString());
		}

		if (from > to) {
			from++;
		}
//		System.out.println(" Removing moving widget from original position " + from);

		getChildNodes().remove(from);

/*		for (PoshWidget w : getChildNodes()) {
			System.out.println("  W " + w.toString());
		}
*/
		getPoshScene().consolidate();
	}
}
