package cz.cuni.pogamut.posh.palette;

import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.util.Lookup;

/**
 * Display one item in palette - just one action. 
 * Child of ActionChildren
 * 
 * @author Honza
 */
class ActionNode extends AbstractPoshPaletteNode {

    protected TriggeredAction action;

    ActionNode(TriggeredAction action) {
        this.action = action;
        this.setDisplayName(action.getDisplayName());
        //this.setHidden(true);
    }

    ActionNode(TriggeredAction action, Lookup lkp) {
        super(lkp);
        this.action = action;
        this.setDisplayName(action.getDisplayName());
        //this.setHidden(true);
    }


    @Override
    protected TriggeredAction getPoshDataNode() {
        return new TriggeredAction(action.getActionName());
    }
}

class ExternalActionNode extends ActionNode {

    ExternalActionNode(TriggeredAction action) {
        super(action);
        setDisplayName("*" + action.getActionName() + "*");
    }
}

class OldActionNode extends ActionNode {

    OldActionNode(TriggeredAction action) {
        super(action);
        setDisplayName("!" + action.getActionName() + "!");
    }

    @Override
    public Action[] getActions(boolean ctx) {
        return new Action[]{
                    new AbstractAction("Delete action") {

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ActionsChildren sc = (ActionsChildren) getParentNode().getChildren();
                            sc.removeOldAction(action);
                        }
                    }
                };
    }
}

