package cz.cuni.pogamut.posh.widget.accept;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/**
 * Add AP to Posh plan.
 * @author Honza
 */
public class AcceptAP2Plan extends AbstractAcceptAction<PoshPlan> {

    public AcceptAP2Plan(PoshPlan plan) {
        super(ActionPattern.dataFlavor, plan);
    }

    @Override
    protected void performAction(Transferable tr) throws UnsupportedFlavorException, IOException {
        try {
            ActionPattern ap = (ActionPattern) tr.getTransferData(dataFlavor);
            if (ap != null) {
                dataNode.addActionPattern(ap);
            }
        } catch (ParseException ex) {
            NotifyDescriptor.Message error = new NotifyDescriptor.Message(ex.getMessage(), NotifyDescriptor.ERROR_MESSAGE);
            DialogDisplayer.getDefault().notify(error);
        }
    }
}
