package cz.cuni.pogamut.posh.nblexer;

import cz.cuni.pogamut.posh.jcclexer.PoshLexerConstants;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

/**
 * LanguageHierarchy contains list of token types for our language(posh), and creates
 * a new instances of our Lexer.
 * LanguageHiearchy is identified by MIME.
 * @author Honza
 */
public class PoshLanguageHiearchy extends LanguageHierarchy<PoshTokenId> {
    private static List<PoshTokenId> tokens;
    private static Map<Integer, PoshTokenId> idToToken;

    private static void init() {
        tokens = Arrays.<PoshTokenId>asList(new PoshTokenId[] {
            new PoshTokenId("EOF", "whitespace", PoshLexerConstants.EOF),
            new PoshTokenId("WHITESPACE", "whitespace", PoshLexerConstants.WHITESPACE),
            new PoshTokenId("SINGLE_LINE_COMMENT", "comment", PoshLexerConstants.SINGLE_LINE_COMMENT),
            new PoshTokenId("LBRACE", "brace", PoshLexerConstants.LBRACE),
            new PoshTokenId("RBRACE", "brace", PoshLexerConstants.RBRACE),
            new PoshTokenId("DC", "keyword", PoshLexerConstants.DC),
            new PoshTokenId("AP", "keyword", PoshLexerConstants.AP),
            new PoshTokenId("COMPETENCE", "keyword", PoshLexerConstants.COMPETENCE),
            new PoshTokenId("ELEMENTS", "keyword", PoshLexerConstants.ELEMENTS),
            new PoshTokenId("GOAL", "keyword", PoshLexerConstants.GOAL),
            new PoshTokenId("HOURS", "keyword", PoshLexerConstants.HOURS),
            new PoshTokenId("MINUTES", "keyword", PoshLexerConstants.MINUTES),
            new PoshTokenId("SECONDS", "keyword", PoshLexerConstants.SECONDS),
            new PoshTokenId("HZ", "keyword", PoshLexerConstants.HZ),
            new PoshTokenId("PM", "keyword", PoshLexerConstants.PM),
            new PoshTokenId("NONE", "keyword", PoshLexerConstants.NONE),
            new PoshTokenId("TRIGGER", "keyword", PoshLexerConstants.TRIGGER),
            new PoshTokenId("NIL", "keyword", PoshLexerConstants.NIL),
            new PoshTokenId("DRIVES", "keyword", PoshLexerConstants.DRIVES),
            new PoshTokenId("DOCUMENTATION", "keyword", PoshLexerConstants.DOCUMENTATION),
            new PoshTokenId("VARS", "keyword", PoshLexerConstants.VARS),
            new PoshTokenId("COMMA", "separator", PoshLexerConstants.COMMA),
            new PoshTokenId("EQUAL_SIGN", "operator", PoshLexerConstants.EQUAL_SIGN),
            new PoshTokenId("PREDICATE", "operator", PoshLexerConstants.PREDICATE),
            new PoshTokenId("NUMFLOAT", "number", PoshLexerConstants.NUMFLOAT),
            new PoshTokenId("NUMINT", "number", PoshLexerConstants.NUMINT),
            new PoshTokenId("NAME", "identifier", PoshLexerConstants.NAME),
            new PoshTokenId("STRINGVALUE", "literal", PoshLexerConstants.STRINGVALUE),
            new PoshTokenId("COMMENT", "string", PoshLexerConstants.COMMENT),
            new PoshTokenId("VARIABLE", "identifier", PoshLexerConstants.VARIABLE),
            new PoshTokenId("ERROR", "error", PoshLexerConstants.ERROR_CHARS),
        });


        idToToken = new HashMap<Integer, PoshTokenId>();
        for (PoshTokenId token : tokens) {
            idToToken.put(token.ordinal(), token);
        }

    }

    static synchronized PoshTokenId getToken(int id) {
        if (idToToken == null)
            init();
        PoshTokenId token = idToToken.get(id);
        if (token == null) {
            System.out.println("+++Token id " + id);
        }
        return token;
    }

    @Override
    protected Collection<PoshTokenId> createTokenIds() {
        if (tokens == null)
            init();
        return tokens;
    }

    @Override
    protected synchronized Lexer<PoshTokenId> createLexer(LexerRestartInfo<PoshTokenId> info) {
        return new PoshLexar(info);
    }

    @Override
    protected String mimeType() {
        return "text/x-posh";
    }

}
