/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.vip.tournament;

import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004NativeBotConfig;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapperConf;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.VIPGameConfig;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.token.IToken;
import java.io.File;
import java.util.Map;

public class UT2004VIPConfig
extends UT2004MatchConfig {
    protected VIPGameConfig vipConfig = new VIPGameConfig();
    protected boolean humanLikeLog = false;

    public UT2004VIPConfig() {
        this.getGb2004Ini().setTDMFragLimit(999);
        this.getGb2004Ini().setTDMTimeLimit(999);
        this.getGb2004Ini().setTDMWeaponStay(false);
        this.getGb2004Ini().getSection("GameBots2004.ControlServer").set("UpdateTime", "0.200");
        this.getGb2004Ini().getSection("GameBots2004.ControlConnection").set("UpdateTime", "0.250");
        this.getUccConf().setGameType("BotTeamGame");
        this.setMatchId("VIP");
    }

    public VIPGameConfig getVIPConfig() {
        return this.vipConfig;
    }

    public void setHsConfig(VIPGameConfig hsConfig) {
        this.vipConfig = hsConfig;
    }

    public UT2004VIPConfig clearBots() {
        super.clearBots();
        return this;
    }

    public UT2004VIPConfig clearNativeBots() {
        super.clearNativeBots();
        return this;
    }

    public UT2004VIPConfig setOutputDirectory(File outputDirectory) {
        super.setOutputDirectory(outputDirectory);
        return this;
    }

    public UT2004VIPConfig setUccConf(UCCWrapperConf uccConf) {
        super.setUccConf(uccConf);
        return this;
    }

    public UT2004VIPConfig setBots(Map<IToken, UT2004BotConfig> bots) {
        super.setBots(bots);
        return this;
    }

    public UT2004VIPConfig setNativeBots(Map<IToken, UT2004NativeBotConfig> nativeBots) {
        super.setNativeBots(nativeBots);
        return this;
    }

    public UT2004VIPConfig addBot(UT2004BotConfig ... bots) {
        super.addBot(bots);
        return this;
    }

    public UT2004MatchConfig setBot(UT2004BotConfig ... bots) {
        super.setBot(bots);
        return this;
    }

    public UT2004VIPConfig addNativeBot(UT2004NativeBotConfig ... bots) {
        throw new RuntimeException("VIP! game cannot be played by native bots.");
    }

    public UT2004VIPConfig setNativeBot(UT2004NativeBotConfig ... bots) {
        throw new RuntimeException("VIP! game cannot be played by native bots.");
    }

    public UT2004VIPConfig setHumanLikeLogEnabled(boolean humanLikeLog) {
        super.setHumanLikeLogEnabled(humanLikeLog);
        return this;
    }

    protected void validateInner() {
        super.validateInner();
        if (this.vipConfig == null) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("hsConfig is null!");
            return;
        }
        if (this.vipConfig.isFixedVIP() && (this.vipConfig.getFixedVIPNamePrefix() == null || this.vipConfig.getFixedVIPNamePrefix().isEmpty())) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("Fixed VIP configured as TRUE, but no name prefix specified.");
        }
        if (this.vipConfig.getTargetMap() == null || this.vipConfig.getTargetMap().isEmpty()) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("No targetMap specified.");
        }
        if (this.vipConfig.getRoundCount() <= 0) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("RoundCount == " + this.vipConfig.getRoundCount() + " <= 0, invalid. There must be at least 1 round to be played.");
        }
        if (this.vipConfig.getCtsSpawnAreas() == null || this.vipConfig.getCtsSpawnAreas().length <= 0) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("No CtsSpawnArea specified.");
        }
        if (this.vipConfig.getTsSpawnAreas() == null || this.vipConfig.getTsSpawnAreas().length <= 0) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("No TsSpawnArea specified.");
        }
        if (this.vipConfig.getVipSafeAreas() == null || this.vipConfig.getVipSafeAreas().length <= 0) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("N VipSafeArea specified.");
        }
        if (this.vipConfig.getVipSafeAreaRadius() < 25) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("SafeAreaRadius == " + this.vipConfig.getVipSafeAreaRadius() + " < 25, invalid, UT2004 sensor snapshots are not that precise to be able to handle small areas.");
        }
    }
}

