/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.vip.server;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.LevelGeometryModule;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.custom.ICustomControlMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GameConfiguration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.KillBot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendControlMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerJoinsGame;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerLeft;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerMessage;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ObserverFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ObserverModule;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.vip.observer.CSObserver;
import cz.cuni.amis.pogamut.ut2004.vip.observer.CSObserverModule;
import cz.cuni.amis.pogamut.ut2004.vip.observer.CSObserverParams;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.CSBotTeam;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.CSMessages;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.CSRoundResult;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.VIPGameConfig;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.VIPGameState;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSAssignVIP;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSBotStateChanged;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSCounterTerroristsWin;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSMessage;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSRoundEnd;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSRoundStart;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSRoundState;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSSetVIPSafeArea;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSTeamScoreChanged;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSTerroristsWin;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSVIPKilled;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSVIPSafe;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.VIPGameEnd;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.VIPGameStart;
import cz.cuni.amis.pogamut.ut2004.vip.server.CSBotRecord;
import cz.cuni.amis.pogamut.ut2004.vip.server.CSTeamsRecord;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.maps.LazyMap;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;

public class UT2004VIPServer
extends UT2004Server
implements IUT2004Server {
    public static final UnrealId SERVER_UNREAL_ID = UnrealId.get((String)"VIPSERVER");
    public static final long ROUND_STATE_BROADCAST_PERIOD_SECS = 5L;
    private Random random = new Random(System.currentTimeMillis());
    private Object mutex = new Object();
    private NumberFormat nf;
    private IWorldEventListener<BeginMessage> myBeginMessageListener = new IWorldEventListener<BeginMessage>(){

        public void notify(BeginMessage event) {
            UT2004VIPServer.this.timeUpdate(event);
        }
    };
    private IWorldEventListener<EndMessage> myEndMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            UT2004VIPServer.this.batchEnd(event);
        }
    };
    private IWorldEventListener<PlayerJoinsGame> myPlayerJoinsGameMessageListener = new IWorldEventListener<PlayerJoinsGame>(){

        public void notify(PlayerJoinsGame event) {
            UT2004VIPServer.this.playerJoinsGame(event);
        }
    };
    private IWorldEventListener<PlayerLeft> myPlayerLeftMessageListener = new IWorldEventListener<PlayerLeft>(){

        public void notify(PlayerLeft event) {
            UT2004VIPServer.this.playerLeft(event);
        }
    };
    private IWorldObjectListener<PlayerMessage> myPlayerListener = new IWorldObjectListener<PlayerMessage>(){

        public void notify(IWorldObjectEvent<PlayerMessage> event) {
            UT2004VIPServer.this.playerUpdate((IWorldObjectEvent<PlayerMessage>)event);
        }
    };
    private LevelGeometryModule level;
    private CSMessages messages = new CSMessages();
    private Flag<Boolean> gameRunning = new Flag((Object)false);
    private Flag<Boolean> gameFailed = new Flag((Object)false);
    private Flag<VIPGameState> gameState = new Flag((Object)VIPGameState.NOT_RUNNING);
    private int subState = 0;
    private VIPGameConfig config;
    private boolean roundRunning = false;
    private double timeCurrent = -1.0;
    private double timeLast = -1.0;
    private double timeDelta = -1.0;
    private double utTimeCurrent = -1.0;
    private double utTimeLast = -1.0;
    private double utTimeDelta = -1.0;
    private long utSendNextRoundStateTimeLeft = 5L;
    private int roundLeft = -1;
    private int roundNumber = -1;
    private double roundTimeLeft = -1.0;
    private CSBotRecord<PlayerMessage> vip;
    private Location safeArea;
    private Map<UnrealId, CSBotRecord<PlayerMessage>> records = new LazyMap<UnrealId, CSBotRecord<PlayerMessage>>(){

        protected CSBotRecord<PlayerMessage> create(UnrealId key) {
            return new CSBotRecord<PlayerMessage>(key, UT2004VIPServer.this.config);
        }
    };
    private CSTeamsRecord teamsRecord;
    Object observersMutex = new Object();
    CSObserver vipObserver;
    Map<UnrealId, CSObserver> observers = new HashMap<UnrealId, CSObserver>();
    Map<UnrealId, CSObserverStarter> observerStarters = new HashMap<UnrealId, CSObserverStarter>();
    private Map<UnrealId, Long> lastPlayerUpdate = new LazyMap<UnrealId, Long>(){

        protected Long create(UnrealId key) {
            return System.currentTimeMillis();
        }
    };

    private NumberFormat getNumberFormat() {
        if (this.nf == null) {
            this.nf = NumberFormat.getNumberInstance();
            this.nf.setMaximumFractionDigits(2);
        }
        return this.nf;
    }

    @Inject
    public UT2004VIPServer(UT2004AgentParameters params, IAgentLogger agentLogger, IComponentBus bus, SocketConnection connection, UT2004WorldView worldView, IAct act) {
        super(params, agentLogger, bus, connection, worldView, act);
        this.level = new LevelGeometryModule(new IUT2004ServerProvider(){

            public void killServer() {
            }

            public UT2004Server getServer() {
                return UT2004VIPServer.this;
            }
        }, this.getWorldView(), this.getLogger());
        ((UT2004WorldView)this.getWorldView()).addEventListener(BeginMessage.class, this.myBeginMessageListener);
        ((UT2004WorldView)this.getWorldView()).addEventListener(EndMessage.class, this.myEndMessageListener);
        ((UT2004WorldView)this.getWorldView()).addEventListener(PlayerJoinsGame.class, this.myPlayerJoinsGameMessageListener);
        ((UT2004WorldView)this.getWorldView()).addEventListener(PlayerLeft.class, this.myPlayerLeftMessageListener);
        ((UT2004WorldView)this.getWorldView()).addObjectListener(Player.class, WorldObjectUpdatedEvent.class, this.myPlayerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        super.init();
        Object object = this.mutex;
        synchronized (object) {
            this.getAct().act((CommandMessage)new StartPlayers(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)));
            this.getAct().act((CommandMessage)new Configuration().setVisionTime(Double.valueOf(0.1)));
        }
    }

    protected void reset() {
        super.reset();
    }

    protected void failure(String reason) {
        this.gameFailed.setFlag((Object)true);
        this.gameRunning.setFlag((Object)false);
        throw new RuntimeException(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startGame(VIPGameConfig config) {
        NullCheck.check((Object)config, (String)"config");
        if (config.getTargetMap() == null) {
            this.failure("TargetMap is not specified within the configuration!");
            return;
        }
        if (!config.getTargetMap().equalsIgnoreCase(this.getMapName())) {
            this.failure("VIPGameConfig is configured for '" + config.getTargetMap() + "', but currently the UT2004 server is running map '" + this.getMapName() + "'.");
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (((Boolean)this.gameRunning.getFlag()).booleanValue()) {
                this.failure("Cannot start the game, game is already running!");
                return;
            }
            this.config = config;
            this.resetVIPGame();
            this.gameRunning.setFlag((Object)true);
            this.gameState.setFlag((Object)VIPGameState.GAME_STARTING);
            this.speak("VIP Game STARTing!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endGame() {
        Object object = this.mutex;
        synchronized (object) {
            if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
                this.failure("Cannot end game, game is not running!");
                return;
            }
            VIPGameEnd endMsg = new VIPGameEnd();
            this.send(endMsg);
            long finishTime = System.currentTimeMillis();
            for (CSBotRecord<PlayerMessage> record : this.records.values()) {
                if (!record.isInGame()) continue;
                record.setFinishTime(finishTime);
            }
            this.speak("Game ENDed!");
            this.setState(VIPGameState.NOT_RUNNING);
            this.gameRunning.setFlag((Object)false);
        }
    }

    public Flag<Boolean> isGameRunning() {
        return this.gameRunning;
    }

    public boolean isRoundRunning() {
        return this.roundRunning;
    }

    public Flag<VIPGameState> getGameState() {
        return this.gameState;
    }

    public Flag<Boolean> getGameFailed() {
        return this.gameFailed;
    }

    public Map<UnrealId, CSBotRecord<PlayerMessage>> getBotRecords() {
        return this.records;
    }

    public CSTeamsRecord getTeamsRecord() {
        return this.teamsRecord;
    }

    private void playerUpdate(IWorldObjectEvent<PlayerMessage> event) {
        this.playerUpdate((PlayerMessage)event.getObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playerUpdate(PlayerMessage player) {
        Map<UnrealId, Long> map = this.mutex;
        synchronized (map) {
            CSBotRecord<PlayerMessage> record = this.ensurePlayer(player.getId());
            record.setPlayer(player);
        }
        map = this.lastPlayerUpdate;
        synchronized (map) {
            long lastTime = this.lastPlayerUpdate.get(player.getId());
            long currTime = System.currentTimeMillis();
            this.lastPlayerUpdate.put(player.getId(), currTime);
            long l = currTime - lastTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playerJoinsGame(PlayerJoinsGame event) {
        Object object = this.mutex;
        synchronized (object) {
            this.ensurePlayer(event.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playerLeft(PlayerLeft event) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.records.containsKey(event.getId())) {
                return;
            }
            CSBotRecord<PlayerMessage> record = this.records.get(event.getId());
            record.setInGame(false);
            record.setFinishTime(System.currentTimeMillis());
            if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
                return;
            }
            if (this.vip == null) {
                return;
            }
            if (event.getId() == this.vip.getPlayer().getId()) {
                this.terroristsWin(CSRoundResult.VIP_LEFT);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeUpdate(BeginMessage event) {
        Object object = this.mutex;
        synchronized (object) {
            this.utTimeLast = this.utTimeCurrent;
            this.utTimeCurrent = event.getTime();
            this.utTimeDelta = this.utTimeLast > 0.0 ? this.utTimeCurrent - this.utTimeLast : -1.0;
            this.timeLast = this.timeCurrent;
            this.timeCurrent = (double)System.currentTimeMillis() / 1000.0;
            this.timeDelta = this.timeLast > 0.0 ? this.timeCurrent - this.timeLast : -1.0;
            if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
                return;
            }
            if (this.utTimeLast <= 0.0 || this.utTimeCurrent <= 0.0 || this.utTimeDelta <= 0.0) {
                return;
            }
            this.utSendNextRoundStateTimeLeft = (long)((double)this.utSendNextRoundStateTimeLeft - this.utTimeDelta);
            if (this.utSendNextRoundStateTimeLeft < 0L) {
                this.sendRoundStateUpdate();
                this.utSendNextRoundStateTimeLeft = 5L;
            }
        }
    }

    private void sendRoundStateUpdate() {
        CSRoundState msg = new CSRoundState();
        msg.setGameState(((VIPGameState)((Object)this.gameState.getFlag())).stateNumber);
        if (this.roundNumber >= 0) {
            msg.setRoundLeft(this.config.getRoundCount() - 1 - this.roundNumber);
        } else {
            msg.setRoundLeft(this.config.getRoundCount());
        }
        msg.setRoundTimeLeftUT(this.roundTimeLeft);
        msg.setVIPBotId(this.vip == null ? null : this.vip.getBotId());
        this.send(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchEnd(EndMessage event) {
        Object object = this.mutex;
        synchronized (object) {
            for (PlayerMessage player : ((UT2004WorldView)this.getWorldView()).getAll(PlayerMessage.class).values()) {
                this.playerUpdate(player);
            }
            if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
                return;
            }
            if (this.utTimeDelta <= 0.0) {
                return;
            }
            this.tick();
        }
    }

    private void setState(VIPGameState state) {
        if (state == this.gameState.getFlag()) {
            return;
        }
        this.gameState.setFlag((Object)state);
        this.subState = 0;
        if (state == VIPGameState.NOT_RUNNING) {
            return;
        }
        CSRoundState msg = new CSRoundState();
        msg.setGameState(state.stateNumber);
        msg.setRoundLeft(this.roundLeft);
        msg.setRoundNumber(this.roundNumber);
        msg.setRoundTimeLeftUT(this.roundTimeLeft);
        msg.setVIPBotId(this.vip == null ? null : this.vip.getBotId());
        this.send(msg);
    }

    private void tick() {
        assert (this.utTimeDelta > 0.0);
        this.getLogger().setLevel(Level.WARNING);
        if (this.roundRunning) {
            double origRoundTimeLeft = this.roundTimeLeft;
            this.roundTimeLeft -= this.utTimeDelta;
            if (origRoundTimeLeft > 120.0 && this.roundTimeLeft < 120.0) {
                this.speak("REMAINING ROUND TIME: 2 minutes");
            }
            if (origRoundTimeLeft > 60.0 && this.roundTimeLeft < 60.0) {
                this.speak("REMAINING ROUND TIME: 1 minute");
            }
            if (origRoundTimeLeft > 30.0 && this.roundTimeLeft < 30.0) {
                this.speak("REMAINING ROUND TIME: 30 seconds");
            }
            if (origRoundTimeLeft > 10.0 && this.roundTimeLeft < 10.0) {
                this.speak("REMAINING ROUND TIME: 10 seconds");
            }
            if (origRoundTimeLeft > 5.0 && this.roundTimeLeft < 5.0) {
                this.speak("REMAINING ROUND TIME: 5 seconds");
            }
            if (origRoundTimeLeft > 1.0 && this.roundTimeLeft < 1.0) {
                this.speak("REMAINING ROUND TIME: 1 second");
            }
            if (this.roundTimeLeft < 0.0) {
                this.roundTimeLeft = -1.0;
                this.roundRunning = false;
                this.speak("ROUND TIMEOUT!");
                this.terroristsWin(CSRoundResult.ROUND_TIMEOUT);
            }
        }
        this.log.info(((VIPGameState)((Object)this.gameState.getFlag())).toString());
        this.log.info("  +-- UT Time delta = " + this.utTimeDelta);
        this.log.info("  +--    Time delta = " + this.timeDelta);
        switch ((VIPGameState)((Object)this.gameState.getFlag())) {
            case NOT_RUNNING: {
                this.stateNotRunning();
                break;
            }
            case GAME_STARTING: {
                this.stateGameStarting();
                break;
            }
            case GAME_STARTED: {
                this.stateGameStarted();
                break;
            }
            case START_NEXT_ROUND: {
                this.stateStartNextRound();
                break;
            }
            case ROUND_STARTING: {
                this.stateRoundStarting();
                break;
            }
            case ROUND_RUNNING: {
                this.stateRoundRunning();
                break;
            }
            case ROUND_ENDED: {
                this.stateRoundEnded();
                break;
            }
            case ROUND_RESET: {
                this.stateRoundReset();
                break;
            }
            default: {
                this.failure("Unexpected VIPGameState: " + this.gameState.getFlag());
                return;
            }
        }
    }

    private void stateNotRunning() {
    }

    private void stateGameStarting() {
        VIPGameStart startMsg = new VIPGameStart(this.config);
        this.send(startMsg);
        this.roundLeft = this.config.getRoundCount();
        this.setState(VIPGameState.GAME_STARTED);
        for (CSBotRecord<PlayerMessage> record : this.getInGameBots()) {
            record.setConfig(this.config);
            if (!record.isBot()) continue;
            this.botStateChanged(record);
        }
    }

    private void stateGameStarted() {
        if (this.config.getRoundCount() <= 0) {
            this.endGame();
            return;
        }
        this.resetVIPRound();
        this.roundNumber = -1;
        this.roundLeft = this.config.getRoundCount();
        this.setState(VIPGameState.START_NEXT_ROUND);
    }

    private void stateStartNextRound() {
        if (this.roundLeft > 0) {
            --this.roundLeft;
            ++this.roundNumber;
            this.speak("STARTING ROUND " + (this.roundNumber + 1) + " / " + this.config.getRoundCount() + " !!!");
            this.setState(VIPGameState.ROUND_STARTING);
        } else {
            this.endGame();
        }
    }

    private void stateRoundStarting() {
        if (this.getInGameBots().size() < 2) {
            if (this.subState == 0) {
                this.speak("Not enough players in the game (" + this.getInGameBots().size() + "), waiting...");
                return;
            }
            this.speakError("Some player has left the game during round-starting, restarting...");
            this.setState(VIPGameState.ROUND_RESET);
            return;
        }
        switch (this.subState) {
            case 0: {
                if (this.getInGameBots().size() < 1) {
                    this.speak("Not enough BOTS in the game, waiting...");
                    return;
                }
                if (this.getInGameTeam(CSBotTeam.COUNTER_TERRORIST).size() < 1) {
                    this.speak("Not enough BOTS in the COUNTER TERRORISTS (~ blue) TEAM, waiting...");
                    return;
                }
                if (this.getInGameTeam(CSBotTeam.TERRORIST).size() < 1) {
                    this.speak("Not enough BOTS in the TERRORISTS (~ red) TEAM, waiting...");
                    return;
                }
                this.send(new CSRoundStart());
                ++this.subState;
                break;
            }
            case 1: {
                this.speak("Sending VIP Game Config info...");
                this.send(new VIPGameStart(this.config));
                ++this.subState;
                break;
            }
            case 2: 
            case 3: {
                ++this.subState;
                break;
            }
            case 4: {
                if (this.config.isFixedVIP() ? !this.assignFixedVIP() : !this.assignRandomVIP()) {
                    return;
                }
                for (CSBotRecord<PlayerMessage> record : this.getInGameBots()) {
                    if (record.getBotId() == this.vip.getBotId()) continue;
                    switch (record.getPlayer().getTeam()) {
                        case 0: {
                            record.setTerroristForThisRound();
                            break;
                        }
                        case 1: {
                            record.setCounterTerroristForThisRound();
                        }
                    }
                    this.botStateChanged(record);
                }
                ++this.subState;
                break;
            }
            case 5: {
                this.send((CommandMessage)new GameConfiguration().setRestart(Boolean.valueOf(true)));
                ++this.subState;
                break;
            }
            case 6: {
                this.speak("Configuring all bots to MANUAL SPAWN...");
                for (CSBotRecord<PlayerMessage> botRecord : this.getInGameBots()) {
                    this.configManualSpawn(botRecord);
                }
                ++this.subState;
                break;
            }
            case 7: {
                this.speak("Killing all bots...");
                for (CSBotRecord<PlayerMessage> botRecord : this.getInGameBots()) {
                    this.killBot(botRecord);
                }
                ++this.subState;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                ++this.subState;
                break;
            }
            case 11: {
                if (this.ensureAllObserved()) {
                    ++this.subState;
                    break;
                }
                this.speak("Waiting for bot observers to initialize...");
                break;
            }
            case 12: {
                if (this.ensureVIPObserver()) {
                    ++this.subState;
                    break;
                }
                this.speak("Waiting for vip-observer to initialize...");
                break;
            }
            case 13: {
                this.decideOnSafeArea();
                ++this.subState;
                break;
            }
            case 14: {
                this.spawnAll();
                ++this.subState;
                break;
            }
            case 15: 
            case 16: {
                ++this.subState;
                break;
            }
            case 17: {
                this.speak("ALL BOTS SPAWNED! ROUND " + (this.roundNumber + 1) + " BEGINS");
                this.roundTimeLeft = this.config.getRoundTimeUT();
                this.roundRunning = true;
                this.setState(VIPGameState.ROUND_RUNNING);
                ++this.subState;
            }
        }
    }

    private boolean assignFixedVIP() {
        List<CSBotRecord<PlayerMessage>> botRecords = this.getInGameTeam(CSBotTeam.COUNTER_TERRORIST);
        for (CSBotRecord<PlayerMessage> botRecord : botRecords) {
            if (!botRecord.getPlayer().getName().startsWith(this.config.getFixedVIPNamePrefix())) continue;
            this.assignVIP(botRecord);
            return true;
        }
        this.speak("Could not assign fixed VIP, cannot find player with name '" + this.config.getFixedVIPNamePrefix() + "' within counter-terrorist (blue) team, waiting ...");
        return false;
    }

    private boolean assignRandomVIP() {
        List<CSBotRecord<PlayerMessage>> botRecords = this.getInGameTeam(CSBotTeam.COUNTER_TERRORIST);
        if (botRecords.size() == 0) {
            this.speak("Could not assign random VIP, no players in counter-terrorist (blue) team, waiting ...");
            return false;
        }
        CSBotRecord<PlayerMessage> randomBot = botRecords.get(this.random.nextInt(botRecords.size()));
        this.assignVIP(randomBot);
        return true;
    }

    private void assignVIP(CSBotRecord<PlayerMessage> botRecord) {
        this.vip = botRecord;
        this.vip.setVIPForThisRound();
        CSAssignVIP msg = new CSAssignVIP();
        msg.setBotId(this.vip.getBotId());
        this.send(msg);
        this.botStateChanged(this.vip);
        this.speak("VIP assigned to: " + botRecord.getBotName());
    }

    private boolean ensureVIPObserver() {
        assert (this.vip != null);
        this.vipObserver = this.ensureSingleObserver(this.vip);
        return this.vipObserver != null;
    }

    private boolean ensureAllObserved() {
        boolean result = true;
        for (CSBotRecord<PlayerMessage> record : this.getInGameBots()) {
            if (this.ensureSingleObserver(record) != null) continue;
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CSObserver ensureSingleObserver(CSBotRecord<PlayerMessage> bot) {
        Object object = this.observersMutex;
        synchronized (object) {
            if (this.observers.containsKey(bot.getBotId())) {
                CSObserver observer = this.observers.get(bot.getBotId());
                if (observer.isObserving() && observer.inState(new Class[]{IAgentStateRunning.class})) {
                    return observer;
                }
                this.killObserver(bot);
                return null;
            }
            if (this.observerStarters.containsKey(bot.getBotId())) {
                return null;
            }
            this.startObserver(bot);
            return null;
        }
    }

    private void decideOnSafeArea() {
        this.speak("Sending safe area location to counter-terrorist (blue) team...");
        this.safeArea = this.config.getVipSafeAreas()[this.random.nextInt(this.config.getVipSafeAreas().length)];
        CSSetVIPSafeArea msg = new CSSetVIPSafeArea();
        msg.setSafeArea(this.safeArea);
        this.sendTeam(msg, CSBotTeam.COUNTER_TERRORIST);
    }

    private void spawnAll() {
        this.speak("Spawning all...");
        this.spawnCounterTerrorists();
        this.spawnTerrorists();
    }

    private void spawnCounterTerrorists() {
        List<CSBotRecord<PlayerMessage>> bots = this.getInGameTeam(CSBotTeam.COUNTER_TERRORIST);
        if (bots.size() == 0) {
            this.failure("There are ZERO players to spawn within Counter-Terrorists team! Restarting...");
            return;
        }
        Location spawnLocation = this.config.getCtsSpawnAreas()[this.random.nextInt(this.config.getCtsSpawnAreas().length)];
        this.spawnBotsAround(bots, spawnLocation);
    }

    private void spawnTerrorists() {
        List<CSBotRecord<PlayerMessage>> bots = this.getInGameTeam(CSBotTeam.TERRORIST);
        if (bots.size() == 0) {
            this.failure("There are ZERO players to spawn within Terrorists team! Restarting...");
            return;
        }
        Location spawnLocation = this.config.getTsSpawnAreas()[this.random.nextInt(this.config.getTsSpawnAreas().length)];
        this.spawnBotsAround(bots, spawnLocation);
    }

    private void spawnBotsAround(List<CSBotRecord<PlayerMessage>> bots, Location spawnLocation) {
        double botsSize = (double)bots.size() * 25.0 * 5.0;
        double spawnRadius = botsSize / Math.PI / 2.0;
        double angleDelta = Math.PI * 2 / (double)bots.size();
        double currentAngle = 0.0;
        for (CSBotRecord<PlayerMessage> botRecord : bots) {
            Location spawnAngle = new Location(1.0, 0.0, 0.0).rotateXY(currentAngle);
            spawnAngle = spawnAngle.scale(spawnRadius);
            Location start = spawnLocation.add(spawnAngle);
            this.spawn(botRecord, start);
            currentAngle += angleDelta;
        }
    }

    private void stateRoundRunning() {
        if (this.subState < 5) {
            ++this.subState;
            return;
        }
        this.roundRunning();
    }

    private void roundRunning() {
        if (this.checkVIPDead()) {
            return;
        }
        if (this.checkVIPInSafeArea()) {
            return;
        }
        if (this.checkTerroristsDead()) {
            return;
        }
    }

    private boolean checkVIPDead() {
        if (this.vip == null) {
            this.vipDead(CSRoundResult.VIP_LEFT);
            return true;
        }
        if (this.vipObserver == null) {
            this.ensureVIPObserver();
            return false;
        }
        if (!this.vipObserver.isObserving()) {
            this.killObserver(this.vip);
            return false;
        }
        if (!this.vipObserver.isBotAlive()) {
            this.vipDead(CSRoundResult.VIP_HAS_BEEN_KILLED);
            return true;
        }
        return false;
    }

    private void vipDead(CSRoundResult result) {
        CSVIPKilled msg = new CSVIPKilled();
        msg.setVipId(this.vip.getBotId());
        this.send(msg);
        this.terroristsWin(result);
    }

    private boolean checkVIPInSafeArea() {
        if (this.safeArea.getDistance(this.vip.getPlayer().getLocation()) > (double)this.config.getVipSafeAreaRadius()) {
            return false;
        }
        this.vipSafe(this.vip, this.safeArea.getDistance(this.vip.getPlayer().getLocation()));
        return true;
    }

    private void vipSafe(CSBotRecord<PlayerMessage> vip, double safeAreaDistance) {
        this.speak("VIP " + vip.getBotName() + " reached safe area! Distance from safe area = " + this.getNumberFormat().format(safeAreaDistance) + " < " + this.config.getVipSafeAreaRadius() + " = safe area radius.");
        CSVIPSafe msg = new CSVIPSafe();
        msg.setVipId(vip.getBotId());
        this.send(msg);
        vip.vipSafe(vip.getBotId());
        this.botStateChanged(vip);
        this.counterTerroristsWin(CSRoundResult.VIP_ESCAPED);
    }

    private boolean checkTerroristsDead() {
        for (CSBotRecord<PlayerMessage> record : this.getInGameTeam(CSBotTeam.TERRORIST)) {
            CSObserver observer = this.ensureSingleObserver(record);
            if (observer == null) {
                return false;
            }
            if (!observer.isBotAlive()) continue;
            return false;
        }
        this.counterTerroristsWin(CSRoundResult.TERRORISTS_DEAD);
        return true;
    }

    private void counterTerroristsWin(CSRoundResult result) {
        if (!this.roundRunning) {
            return;
        }
        this.speak("Counter-terrorist (blue) team WINS the round: " + result.message);
        this.teamsRecord.counterTerroristsWin();
        for (CSBotRecord<PlayerMessage> record : this.getInGameBots()) {
            record.counterTerroristsWin();
        }
        CSCounterTerroristsWin roundResult = new CSCounterTerroristsWin();
        roundResult.setRoundResult(result);
        this.send(roundResult);
        CSTeamScoreChanged teamScoreChanged = new CSTeamScoreChanged();
        teamScoreChanged.setUt2004Team(CSBotTeam.COUNTER_TERRORIST.ut2004Team);
        teamScoreChanged.setScore(this.teamsRecord.getScore(CSBotTeam.COUNTER_TERRORIST));
        teamScoreChanged.setRoundResult(result);
        this.send(teamScoreChanged);
        teamScoreChanged.setUt2004Team(CSBotTeam.TERRORIST.ut2004Team);
        teamScoreChanged.setScore(this.teamsRecord.getScore(CSBotTeam.TERRORIST));
        teamScoreChanged.setRoundResult(result);
        this.send(teamScoreChanged);
        this.roundRunning = false;
        this.setState(VIPGameState.ROUND_ENDED);
    }

    private void terroristsWin(CSRoundResult result) {
        if (!this.roundRunning) {
            return;
        }
        this.speak("Terrorists (red) team WINS the round: " + result.message);
        this.teamsRecord.terroristsWin();
        for (CSBotRecord<PlayerMessage> record : this.getInGameBots()) {
            record.terroristsWin();
        }
        CSTerroristsWin roundResult = new CSTerroristsWin();
        roundResult.setRoundResult(result);
        this.send(roundResult);
        CSTeamScoreChanged teamScoreChanged = new CSTeamScoreChanged();
        teamScoreChanged.setUt2004Team(CSBotTeam.COUNTER_TERRORIST.ut2004Team);
        teamScoreChanged.setScore(this.teamsRecord.getScore(CSBotTeam.COUNTER_TERRORIST));
        teamScoreChanged.setRoundResult(result);
        this.send(teamScoreChanged);
        teamScoreChanged.setUt2004Team(CSBotTeam.TERRORIST.ut2004Team);
        teamScoreChanged.setScore(this.teamsRecord.getScore(CSBotTeam.TERRORIST));
        teamScoreChanged.setRoundResult(result);
        this.send(teamScoreChanged);
        this.roundRunning = false;
        this.setState(VIPGameState.ROUND_ENDED);
    }

    private void stateRoundEnded() {
        this.roundRunning = false;
        this.send(new CSRoundEnd());
        this.setState(VIPGameState.ROUND_RESET);
    }

    private void stateRoundReset() {
        switch (this.subState) {
            case 0: {
                this.killAllAliveBots();
                this.speak("Round ENDed!");
                ++this.subState;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                ++this.subState;
                break;
            }
            case 5: {
                this.setState(VIPGameState.START_NEXT_ROUND);
            }
        }
    }

    private void killAllAliveBots() {
        this.speak("Killing all remaining bots...");
        List<CSBotRecord<PlayerMessage>> aliveBots = this.getInGameAliveBots();
        for (CSBotRecord<PlayerMessage> aliveBot : aliveBots) {
            this.killBot(aliveBot);
        }
    }

    private void spawn(CSBotRecord<PlayerMessage> botRecord, Location spawningPoint) {
        botRecord.setSpawned(true);
        Respawn respawn = new Respawn();
        respawn.setId(botRecord.getBotId());
        respawn.setStartLocation(spawningPoint);
        this.send((CommandMessage)respawn);
    }

    private void botStateChanged(CSBotRecord<PlayerMessage> botRecord) {
        CSBotStateChanged msg = new CSBotStateChanged();
        msg.setBotId(botRecord.getBotId());
        msg.setNewState(botRecord.getBotState());
        this.send(msg);
    }

    private void configManualSpawn(CSBotRecord<PlayerMessage> botRecord) {
        Configuration conf = new Configuration();
        conf.setId(botRecord.getBotId());
        conf.setManualSpawn(Boolean.valueOf(true));
        this.send((CommandMessage)conf);
    }

    private void spawnBot(CSBotRecord<PlayerMessage> botRecord) {
    }

    private void killBot(CSBotRecord<PlayerMessage> botRecord) {
        botRecord.setSpawned(false);
        KillBot cmd = new KillBot();
        cmd.setId(botRecord.getBotId());
        this.send((CommandMessage)cmd);
    }

    private CSBotRecord<PlayerMessage> ensurePlayer(UnrealId botId) {
        if (botId == null) {
            return null;
        }
        CSBotRecord<PlayerMessage> record = this.records.get(botId);
        if (record.isInGame()) {
            return record;
        }
        record.reset();
        record.setInGame(true);
        if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
            return record;
        }
        this.botStateChanged(record);
        return record;
    }

    private List<CSBotRecord<PlayerMessage>> getInGameBots() {
        ArrayList<CSBotRecord<PlayerMessage>> result = new ArrayList<CSBotRecord<PlayerMessage>>();
        for (CSBotRecord<PlayerMessage> record : this.records.values()) {
            if (!record.isInGame() || !record.isBot()) continue;
            result.add(record);
        }
        return result;
    }

    private List<CSBotRecord<PlayerMessage>> getInGameAliveBots() {
        ArrayList<CSBotRecord<PlayerMessage>> result = new ArrayList<CSBotRecord<PlayerMessage>>();
        for (CSBotRecord<PlayerMessage> record : this.records.values()) {
            if (!record.isInGame() || !record.isBot() || !record.isSpawned()) continue;
            result.add(record);
        }
        return result;
    }

    private List<CSBotRecord<PlayerMessage>> getInGameTeam(CSBotTeam team) {
        ArrayList<CSBotRecord<PlayerMessage>> result = new ArrayList<CSBotRecord<PlayerMessage>>();
        for (CSBotRecord<PlayerMessage> record : this.records.values()) {
            if (!record.isInGame() || !record.isBot() || record.getPlayer().getTeam() != team.ut2004Team) continue;
            result.add(record);
        }
        return result;
    }

    private List<CSBotRecord<PlayerMessage>> getInGameTeamAlive(CSBotTeam team) {
        ArrayList<CSBotRecord<PlayerMessage>> result = new ArrayList<CSBotRecord<PlayerMessage>>();
        for (CSBotRecord<PlayerMessage> record : this.records.values()) {
            if (!record.isInGame() || !record.isBot() || record.getPlayer().getTeam() != team.ut2004Team || !record.isSpawned()) continue;
            result.add(record);
        }
        return result;
    }

    private void scoreChanged(CSBotTeam team, CSRoundResult roundResult) {
        CSTeamScoreChanged msg = new CSTeamScoreChanged();
        msg.setUt2004Team(team.ut2004Team);
        msg.setScore(this.teamsRecord.getScore(team));
        msg.setRoundResult(roundResult);
        this.send(msg);
    }

    private void send(CSMessage message) {
        if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
            return;
        }
        this.log.info("Sending to ALL: " + (Object)((Object)message));
        SendControlMessage command = this.messages.write((ICustomControlMessage)message);
        command.setSendAll(Boolean.valueOf(true));
        this.getAct().act((CommandMessage)command);
    }

    private void sendTeam(CSMessage message, CSBotTeam team) {
        if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
            return;
        }
        this.log.info("Sending to " + (Object)((Object)team) + ": " + (Object)((Object)message));
        SendControlMessage command = this.messages.write((ICustomControlMessage)message);
        command.setSendAll(Boolean.valueOf(false));
        for (CSBotRecord<PlayerMessage> record : this.getInGameTeam(team)) {
            command.setBotId(record.getBotId());
            this.send((CommandMessage)command);
        }
    }

    private void sendTeamAlive(CSMessage message, CSBotTeam team) {
        if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
            return;
        }
        this.log.info("Sending to " + (Object)((Object)team) + ": " + (Object)((Object)message));
        SendControlMessage command = this.messages.write((ICustomControlMessage)message);
        command.setSendAll(Boolean.valueOf(false));
        for (CSBotRecord<PlayerMessage> record : this.getInGameTeamAlive(team)) {
            command.setBotId(record.getBotId());
            this.send((CommandMessage)command);
        }
    }

    private void send(CommandMessage command) {
        if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
            return;
        }
        this.getAct().act(command);
    }

    private void speak(String message) {
        if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
            return;
        }
        this.log.warning(message);
        this.getAct().act((CommandMessage)new SendMessage().setGlobal(Boolean.valueOf(true)).setText("[GAME] " + message));
    }

    private void speakError(String message) {
        if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
            this.log.severe(message);
        }
        this.getAct().act((CommandMessage)new SendMessage().setGlobal(Boolean.valueOf(true)).setText("[GAME] [ERROR] " + message));
    }

    private void resetVIPRound() {
        this.roundRunning = false;
        this.vip = null;
    }

    private void resetVIPGame() {
        this.gameRunning.setFlag((Object)false);
        this.roundLeft = -1;
        this.roundNumber = -1;
        this.vip = null;
        this.utSendNextRoundStateTimeLeft = 5L;
        Iterator<CSBotRecord<PlayerMessage>> recordIter = this.records.values().iterator();
        while (recordIter.hasNext()) {
            CSBotRecord<PlayerMessage> record = recordIter.next();
            if (!record.isInGame()) {
                recordIter.remove();
                continue;
            }
            record.reset();
            record.setInGame(true);
        }
        if (this.teamsRecord == null) {
            this.teamsRecord = new CSTeamsRecord(this.config);
        }
    }

    protected void stopAgent() {
        super.stopAgent();
        this.cleanUp();
    }

    protected void killAgent() {
        super.killAgent();
        try {
            this.cleanUp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        Object object = this.observersMutex;
        synchronized (object) {
            for (CSObserver observer : this.observers.values()) {
                try {
                    new CSObserverKiller(observer);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void observerFailedToStart(CSBotRecord botToObserve, Exception e) {
        Object object = this.observersMutex;
        synchronized (object) {
            this.observerStarters.remove(botToObserve.getBotId());
        }
        this.speakError("Failed to start observer for the bot: " + botToObserve.getBotId());
        this.log.severe(ExceptionToString.process((String)("Failed to start observer for the bot: " + botToObserve.getBotId()), (Throwable)e));
        this.kill();
    }

    public CSObserver getObserver(CSBotRecord<PlayerMessage> bot) {
        return this.observers.get(bot.getBotId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startObserver(CSBotRecord<PlayerMessage> bot) {
        Object object = this.observersMutex;
        synchronized (object) {
            CSObserverStarter starter = this.observerStarters.get(bot.getBotId());
            if (starter != null) {
                return;
            }
            starter = new CSObserverStarter(bot, this.config.getObserverPort());
            this.observerStarters.put(bot.getBotId(), starter);
            starter.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killObserver(CSBotRecord<PlayerMessage> bot) {
        Object object = this.observersMutex;
        synchronized (object) {
            CSObserverStarter starter;
            CSObserver observer = this.observers.remove(bot.getBotId());
            if (observer != null) {
                new CSObserverKiller(observer).start();
            }
            if ((starter = this.observerStarters.get(bot.getBotId())) != null) {
                starter.observerValid = false;
            }
        }
    }

    private class CSObserverKiller
    extends Thread {
        private CSObserver observer;

        public CSObserverKiller(CSObserver observer) {
            this.observer = observer;
        }

        @Override
        public void run() {
            if (this.observer == null) {
                return;
            }
            try {
                this.observer.kill();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class CSObserverStarter
    extends Thread {
        private CSBotRecord botToObserve;
        private int observerPort;
        public boolean observerValid = true;

        public CSObserverStarter(CSBotRecord botToObserve, int observerPort) {
            this.botToObserve = botToObserve;
            this.observerPort = observerPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CSObserverParams params = new CSObserverParams();
                params.setAgentId((IAgentId)new AgentId("Observer-" + this.botToObserve.getBotId().getStringId()));
                URI worldAddress = UT2004VIPServer.this.getWorldAddress();
                params.setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(worldAddress.getHost(), this.observerPort));
                params.setBotIDToObserve(this.botToObserve.getBotId().getStringId());
                CSObserverModule module = new CSObserverModule();
                UT2004ObserverFactory observerFactory = new UT2004ObserverFactory((UT2004ObserverModule)module);
                CSObserver observer = (CSObserver)observerFactory.newAgent((IAgentParameters)params);
                try {
                    observer.getLogger().setLevel(Level.WARNING);
                    observer.start();
                }
                catch (Exception e) {
                    UT2004VIPServer.this.observerFailedToStart(this.botToObserve, e);
                    Object object = UT2004VIPServer.this.observersMutex;
                    synchronized (object) {
                        UT2004VIPServer.this.observerStarters.remove(this.botToObserve.getBotId());
                    }
                    return;
                }
                Object object = UT2004VIPServer.this.observersMutex;
                synchronized (object) {
                    if (this.observerValid && UT2004VIPServer.this.inState(new Class[]{IAgentStateRunning.class})) {
                        UT2004VIPServer.this.observers.put(this.botToObserve.getBotId(), observer);
                    } else {
                        new CSObserverKiller(observer);
                    }
                }
            }
            catch (Exception exception) {
                Object object = UT2004VIPServer.this.observersMutex;
                synchronized (object) {
                    UT2004VIPServer.this.observerStarters.remove(this.botToObserve.getBotId());
                }
            }
            finally {
                Object object = UT2004VIPServer.this.observersMutex;
                synchronized (object) {
                    UT2004VIPServer.this.observerStarters.remove(this.botToObserve.getBotId());
                }
            }
        }
    }
}

