/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.vip.protocol;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.VIPGameStart;
import java.util.Formatter;

public class VIPGameConfig {
    private int observerPort = 3002;
    private String targetMap;
    private Location[] ctsSpawnAreas;
    private Location[] tsSpawnAreas;
    private Location[] vipSafeAreas;
    private int vipSafeAreaRadius;
    private int roundCount;
    private double roundTimeUT;
    private boolean fixedVIP;
    private String fixedVIPNamePrefix;
    private int vipKilledTsScore = 100;
    private int vipKilledCTsScore = 0;
    private int vipSafeTsScore = 0;
    private int vipSafeCTsScore = 100;

    public VIPGameConfig() {
    }

    public VIPGameConfig(VIPGameStart msg) {
        this.roundCount = msg.getRoundCount();
        this.roundTimeUT = msg.getRoundTimeUT();
        this.vipSafeAreaRadius = msg.getVipSafeAreaRadius();
        this.fixedVIP = msg.getFixedVIP();
        this.fixedVIPNamePrefix = msg.getFixedVIPNamePrefix();
        this.readStringData(msg.getStringData());
    }

    public int getObserverPort() {
        return this.observerPort;
    }

    public void setObserverPort(int observerPort) {
        this.observerPort = observerPort;
    }

    public String getTargetMap() {
        return this.targetMap;
    }

    public void setTargetMap(String targetMap) {
        this.targetMap = targetMap;
    }

    public Location[] getCtsSpawnAreas() {
        return this.ctsSpawnAreas;
    }

    public void setCtsSpawnAreas(Location[] ctsSpawnAreas) {
        this.ctsSpawnAreas = ctsSpawnAreas;
    }

    public Location[] getTsSpawnAreas() {
        return this.tsSpawnAreas;
    }

    public void setTsSpawnAreas(Location[] tsSpawnAreas) {
        this.tsSpawnAreas = tsSpawnAreas;
    }

    public Location[] getVipSafeAreas() {
        return this.vipSafeAreas;
    }

    public void setVipSafeAreas(Location[] vipSafeAreas) {
        this.vipSafeAreas = vipSafeAreas;
    }

    public int getVipSafeAreaRadius() {
        return this.vipSafeAreaRadius;
    }

    public void setVipSafeAreaRadius(int vipSafeAreaRadius) {
        this.vipSafeAreaRadius = vipSafeAreaRadius;
    }

    public int getRoundCount() {
        return this.roundCount;
    }

    public void setRoundCount(int roundCount) {
        this.roundCount = roundCount;
    }

    public double getRoundTimeUT() {
        return this.roundTimeUT;
    }

    public void setRoundTimeUT(double roundTimeUT) {
        this.roundTimeUT = roundTimeUT;
    }

    public boolean isFixedVIP() {
        return this.fixedVIP;
    }

    public void setFixedVIP(boolean fixedVIP) {
        this.fixedVIP = fixedVIP;
    }

    public String getFixedVIPNamePrefix() {
        return this.fixedVIPNamePrefix;
    }

    public void setFixedVIPNamePrefix(String fixedVIPNamePrefix) {
        this.fixedVIPNamePrefix = fixedVIPNamePrefix;
    }

    public int getVipKilledTsScore() {
        return this.vipKilledTsScore;
    }

    public void setVipKilledTsScore(int vipKilledTsScore) {
        this.vipKilledTsScore = vipKilledTsScore;
    }

    public int getVipKilledCTsScore() {
        return this.vipKilledCTsScore;
    }

    public void setVipKilledCTsScore(int vipKilledCTsScore) {
        this.vipKilledCTsScore = vipKilledCTsScore;
    }

    public int getVipSafeTsScore() {
        return this.vipSafeTsScore;
    }

    public void setVipSafeTsScore(int vipSafeTsScore) {
        this.vipSafeTsScore = vipSafeTsScore;
    }

    public int getVipSafeCTsScore() {
        return this.vipSafeCTsScore;
    }

    public void setVipSafeCTsScore(int vipSafeCTsScore) {
        this.vipSafeCTsScore = vipSafeCTsScore;
    }

    public String writeStringData() {
        String data = this.vipKilledTsScore + ";" + this.vipKilledCTsScore + ";" + this.vipSafeTsScore + ";" + this.vipSafeCTsScore + ";" + this.targetMap;
        String areas = "";
        for (Location area : this.ctsSpawnAreas) {
            if (areas.length() != 0) {
                areas = areas + "#";
            }
            areas = areas + area.toString().replaceAll(";", "|");
        }
        data = data + ";" + areas;
        areas = "";
        for (Location area : this.tsSpawnAreas) {
            if (areas.length() != 0) {
                areas = areas + "#";
            }
            areas = areas + area.toString().replaceAll(";", "|");
        }
        data = data + ";" + areas;
        areas = "";
        for (Location area : this.vipSafeAreas) {
            if (areas.length() != 0) {
                areas = areas + "#";
            }
            areas = areas + area.toString().replaceAll(";", "|");
        }
        data = data + ";" + areas;
        return data;
    }

    public void readStringData(String stringData) {
        int i;
        String[] data = stringData.split(";");
        if (data.length != 8) {
            throw new RuntimeException("Invalid string data, does not contain 8 field separated by ';', string: '" + stringData + "'.");
        }
        this.vipKilledTsScore = Integer.parseInt(data[0]);
        this.vipKilledCTsScore = Integer.parseInt(data[1]);
        this.vipSafeTsScore = Integer.parseInt(data[2]);
        this.vipSafeCTsScore = Integer.parseInt(data[3]);
        this.targetMap = data[4];
        String[] areas = data[5].split("#");
        this.ctsSpawnAreas = new Location[areas.length];
        for (i = 0; i < areas.length; ++i) {
            areas[i] = areas[i].replaceAll("\\|", ";");
            this.ctsSpawnAreas[i] = new Location(areas[i]);
        }
        areas = data[6].split("#");
        this.tsSpawnAreas = new Location[areas.length];
        for (i = 0; i < areas.length; ++i) {
            areas[i] = areas[i].replaceAll("\\|", ";");
            this.tsSpawnAreas[i] = new Location(areas[i]);
        }
        areas = data[7].split("#");
        this.vipSafeAreas = new Location[areas.length];
        for (i = 0; i < areas.length; ++i) {
            areas[i] = areas[i].replaceAll("\\|", ";");
            this.vipSafeAreas[i] = new Location(areas[i]);
        }
    }

    public String getCSVHeader() {
        return "Map;FixedSeeker;FixedSeekerNamePrefix;RoundCount;RoundTimeSecs;CTsSpawnAreas;TsSpawnAreas;VipSafeAreas;VipSafeAreaRadius;VipKilledTsScore;VipKilledCTsScore;VipSafeTsScore;VipSafeCTsScore";
    }

    public void formatCSVLine(Formatter writer) {
        writer.format("%s;", this.targetMap);
        writer.format("%s;", String.valueOf(this.fixedVIP));
        writer.format("%s;", String.valueOf(this.fixedVIPNamePrefix));
        writer.format("%d;", this.roundCount);
        writer.format("%.3f;", this.roundTimeUT);
        String areas = "";
        for (Location area : this.ctsSpawnAreas) {
            if (areas.length() != 0) {
                areas = areas + ",";
            }
            areas = areas + area.toString().replaceAll(";", "|");
        }
        writer.format("%s;", areas);
        areas = "";
        for (Location area : this.tsSpawnAreas) {
            if (areas.length() != 0) {
                areas = areas + ",";
            }
            areas = areas + area.toString().replaceAll(";", "|");
        }
        writer.format("%s;", areas);
        areas = "";
        for (Location area : this.vipSafeAreas) {
            if (areas.length() != 0) {
                areas = areas + ",";
            }
            areas = areas + area.toString().replaceAll(";", "|");
        }
        writer.format("%s;", areas);
        writer.format("%d;", this.vipSafeAreaRadius);
        writer.format("%d;", this.vipKilledTsScore);
        writer.format("%d;", this.vipKilledCTsScore);
        writer.format("%d;", this.vipSafeTsScore);
        writer.format("%d;", this.vipSafeCTsScore);
    }
}

