/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.deathmatch;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchRepeater;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.config.HunterBot;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004NativeBotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.utils.UT2004TournamentProperty;
import java.io.File;
import java.util.logging.Level;
import org.junit.AfterClass;
import org.junit.Test;

public class UT2004TournamentTest16_UT2004DeathMatchRepeater_HunterVsNative {
    @AfterClass
    public static void tearDown() {
        Pogamut.getPlatform().close();
    }

    private UT2004DeathMatchConfig configure1VsNative() {
        UT2004DeathMatchConfig matchConfig = new UT2004DeathMatchConfig();
        matchConfig.setMatchId("HunterBot-vs-NativeBot");
        matchConfig.setOutputDirectory(new File("results" + File.separator + "matches"));
        matchConfig.setFragLimit(20);
        matchConfig.setTimeLimit(20);
        matchConfig.getUccConf().setStartOnUnusedPort(true);
        matchConfig.getUccConf().setUnrealHome(Pogamut.getPlatform().getProperty(UT2004TournamentProperty.UT2004_DIR.getKey()));
        matchConfig.getUccConf().setGameType("BotDeathMatch");
        matchConfig.getUccConf().setMapName("DM-1on1-Albatross");
        matchConfig.addBot(new UT2004BotConfig[]{HunterBot.createConfig()});
        UT2004NativeBotConfig nativeBotConfig = new UT2004NativeBotConfig();
        nativeBotConfig.setBotId("NativeBot");
        nativeBotConfig.setSkillLevel(5);
        nativeBotConfig.setTeamNumber(255);
        matchConfig.addNativeBot(new UT2004NativeBotConfig[]{nativeBotConfig});
        return matchConfig;
    }

    private UT2004DeathMatchConfig createMatch() {
        return this.configure1VsNative();
    }

    @Test
    public void test() {
        UT2004DeathMatchConfig match = this.createMatch();
        UT2004DeathMatchRepeater repeater = new UT2004DeathMatchRepeater(match, 20, new LogCategory("DMRepeater"));
        repeater.getLog().addConsoleHandler();
        repeater.getLog().setLevel(Level.FINE);
        repeater.run();
        System.out.println("---/// TEST OK ///---");
    }
}

