/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.match;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogFormatter;
import cz.cuni.amis.pogamut.base.utils.logging.LogHandler;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.analyzer.IAnalyzerObserverListener;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004AnalyzerObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004Analyzer;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerModule;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerObserverModule;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerParameters;
import cz.cuni.amis.pogamut.ut2004.analyzer.stats.UT2004AnalyzerObsStatsModule;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddBot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ChangeTeam;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GameConfiguration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Kick;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Record;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameRestarted;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004AnalyzerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.tournament.botexecution.UT2004BotExecution;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004NativeBotConfig;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.FilePath;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.token.IToken;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public abstract class UT2004Match<CONFIG extends UT2004MatchConfig, RESULT extends UT2004MatchResult>
implements Callable<RESULT>,
Runnable {
    private static final int MAX_TEAMS = 8;
    protected CONFIG config;
    protected LogCategory log;
    protected RESULT result;
    protected Throwable exception;
    protected boolean teamMatch;
    protected LogHandler fileHandler;

    public UT2004Match(boolean teamMatch, CONFIG config, LogCategory log) {
        NullCheck.check(config, (String)"config");
        this.config = config;
        NullCheck.check((Object)((UT2004MatchConfig)config).getMatchId(), (String)"config.getMatchId()");
        this.log = log;
        teamMatch = false;
    }

    public boolean isTeamMatch() {
        return this.teamMatch;
    }

    public RESULT getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public void run() {
        try {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Executing match: " + this.getMatchId().getToken());
            }
            this.result = null;
            this.exception = null;
            this.result = this.execute();
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("---/// MATCH OK ///---");
            }
        }
        catch (Exception e) {
            if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(ExceptionToString.process((String)("Failed to execute the match: " + this.getMatchId().getToken() + "."), (Throwable)e));
            }
            this.exception = e;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new PogamutException("Failed to execute the match: " + this.getMatchId().getToken(), (Throwable)e, (Object)this);
        }
    }

    @Override
    public RESULT call() {
        this.run();
        return this.getResult();
    }

    protected abstract RESULT execute();

    public static String getCurrentDate() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        return dateFormat.format(date);
    }

    public CONFIG getConfig() {
        return this.config;
    }

    public IToken getMatchId() {
        return ((UT2004MatchConfig)this.config).getMatchId();
    }

    public LogCategory getLog() {
        return this.log;
    }

    public String toString() {
        if (this == null) {
            return "UT2004Match";
        }
        return String.valueOf(this.getClass().getSimpleName()) + "[id=" + ((UT2004MatchConfig)this.config).getMatchId().getToken() + ", custom bots=" + ((UT2004MatchConfig)this.config).getBots().size() + ", native bots =" + ((UT2004MatchConfig)this.config).getNativeBots().size() + "]";
    }

    public File getOutputPath() {
        return this.getOutputPath("");
    }

    public File getOutputPath(String relativePath) {
        if (relativePath == null || relativePath.length() == 0) {
            return new File(((UT2004MatchConfig)this.config).getOutputDirectory().getAbsoluteFile() + File.separator + ((UT2004MatchConfig)this.config).getMatchId().getToken());
        }
        return new File(((UT2004MatchConfig)this.config).getOutputDirectory().getAbsoluteFile() + File.separator + ((UT2004MatchConfig)this.config).getMatchId().getToken() + File.separator + relativePath);
    }

    protected void setupLogger() {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Adding output of logs into " + this.getOutputPath("match-" + ((UT2004MatchConfig)this.config).getMatchId().getToken() + ".log"));
        }
        if (this.log != null) {
            this.fileHandler = new LogHandler((ILogPublisher)new LogPublisher.FilePublisher(this.getOutputPath("match-" + ((UT2004MatchConfig)this.config).getMatchId().getToken() + ".log"), (Formatter)new LogFormatter((IAgentId)new AgentId(((UT2004MatchConfig)this.config).getMatchId().getToken()), true)));
            this.log.addHandler((Handler)this.fileHandler);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(this + " file output setup");
        }
    }

    public void validate() {
        try {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Validating match configuration...");
            }
            ((UT2004MatchConfig)this.config).validate();
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Match configuration validated - OK.");
            }
        }
        catch (PogamutException e) {
            if (this.log != null) {
                this.log.severe(e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.severe(e.getMessage());
            }
            throw new PogamutException("Validation failed.", (Throwable)e, (Logger)this.log, (Object)this);
        }
    }

    public void cleanUp() {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Cleaning up! Deleting: " + this.getOutputPath().getAbsolutePath());
        }
        FileUtils.deleteQuietly((File)this.getOutputPath());
    }

    protected File getUccHome() {
        return new File(String.valueOf(((UT2004MatchConfig)this.config).getUccConf().getUnrealHome()) + File.separator + "System");
    }

    protected File getGB2004IniFile() {
        return new File(String.valueOf(((UT2004MatchConfig)this.config).getUccConf().getUnrealHome()) + File.separator + "System" + File.separator + "GameBots2004.ini");
    }

    protected void createGB2004Ini() {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Outputting GameBots2004.ini into " + this.getGB2004IniFile().getAbsolutePath() + " ...");
        }
        File gb2004File = this.getGB2004IniFile();
        File gb2004FileBackup = new File(String.valueOf(gb2004File.getParent()) + File.separator + "GameBots2004.ini.backup");
        if (gb2004File.isFile() && gb2004File.exists()) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Backing up GameBots2004.ini from " + gb2004File.getAbsolutePath() + " into + " + gb2004FileBackup.getAbsolutePath() + " ...");
            }
            boolean backup = true;
            try {
                FileUtils.copyFile((File)gb2004File, (File)gb2004FileBackup);
            }
            catch (IOException e) {
                backup = false;
            }
            if (backup && this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Backed up GameBots2004.ini from " + gb2004File.getAbsolutePath() + " into + " + gb2004FileBackup.getAbsolutePath() + " ...");
            } else if (!backup && this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Failed to back up GameBots2004.ini from " + gb2004File.getAbsolutePath() + " into + " + gb2004FileBackup.getAbsolutePath() + " !!!");
            }
        }
        ((UT2004MatchConfig)this.config).getGb2004Ini().output(gb2004File);
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": GameBots2004.ini output into " + this.getGB2004IniFile().getAbsolutePath() + ".");
        }
    }

    protected UCCWrapper startUCC() {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Starting UCC with " + ((UT2004MatchConfig)this.config).getUccConf() + " ...");
        }
        UCCWrapper result = new UCCWrapper(((UT2004MatchConfig)this.config).getUccConf());
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": UCC started with " + ((UT2004MatchConfig)this.config).getUccConf() + ".");
            this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": GB2004 host                = " + result.getHost());
            this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": GB2004 bot port            = " + result.getBotPort());
            this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": GB2004 control server port = " + result.getControlPort());
            this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": GB2004 observer port       = " + result.getObserverPort());
        }
        return result;
    }

    protected UT2004Server startControlServer(UCCWrapper ucc) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Starting UT2004Server...");
        }
        NullCheck.check((Object)ucc, (String)"ucc");
        UT2004ServerModule module = new UT2004ServerModule();
        UT2004ServerFactory factory = new UT2004ServerFactory(module);
        UT2004Server server = (UT2004Server)factory.newAgent((IAgentParameters)new UT2004AgentParameters().setAgentId((IAgentId)new AgentId(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + "-UT2004Server")).setWorldAddress((IWorldConnectionAddress)ucc.getServerAddress()));
        server.getLogger().setLevel(Level.WARNING);
        server.getLogger().addDefaultConsoleHandler();
        server.start();
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": UT2004Server started.");
        }
        return server;
    }

    protected void changeBotTeam(UT2004Server server, UnrealId botId, int desiredTeam) {
        NullCheck.check((Object)server, (String)"server");
        NullCheck.check((Object)botId, (String)"botId");
        final int targetTeam = desiredTeam;
        if (targetTeam < 0 || targetTeam >= 8) {
            return;
        }
        Player player = (Player)((UT2004WorldView)server.getWorldView()).get((WorldObjectId)botId);
        if (player == null) {
            throw new PogamutException("Bot with unrealId '" + botId + "' does not exists in 'server' worldview! **PUZZLED**", (Logger)this.log, (Object)this);
        }
        if (player.getTeam() == targetTeam) {
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Switching Bot[unrealId=" + botId.getStringId() + "] to team " + desiredTeam + "...");
        }
        final CountDownLatch teamChangedLatch = new CountDownLatch(1);
        IWorldObjectListener<Player> playerListener = new IWorldObjectListener<Player>(){
            Location previous;

            public void notify(IWorldObjectEvent<Player> event) {
                if (((Player)event.getObject()).getTeam() == targetTeam) {
                    teamChangedLatch.countDown();
                }
            }
        };
        ((UT2004WorldView)server.getWorldView()).addObjectListener((WorldObjectId)botId, (IWorldObjectEventListener)playerListener);
        try {
            server.getAct().act((CommandMessage)new ChangeTeam(botId, Integer.valueOf(targetTeam)));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException("Interrupted while awaiting team-change.", (Logger)this.log, (Object)e);
            }
            server.getAct().act((CommandMessage)new Respawn().setId(botId));
            long teamChangeTimeoutSecs = 60L;
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Waitng for Bot[unrealId=" + botId.getStringId() + "] to be switched to team " + desiredTeam + " for " + teamChangeTimeoutSecs + "secs...");
            }
            try {
                teamChangedLatch.await(teamChangeTimeoutSecs, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException("Interrupted while awaiting team-change.", (Logger)this.log, (Object)e);
            }
            player = (Player)((UT2004WorldView)server.getWorldView()).get((WorldObjectId)botId);
            if (player == null) {
                throw new PogamutException("Bot with unrealId '" + botId + "' does not exists in 'server' worldview! **PUZZLED**", (Logger)this.log, (Object)this);
            }
            if (player.getTeam() != targetTeam) {
                throw new PogamutException("Failed to change the bot with botId '" + botId + "' corresponding unrealId '" + botId + "' into correct team within " + teamChangeTimeoutSecs + "secs! Required team is " + targetTeam + ", current team is " + player.getTeam() + ".", (Logger)this.log, (Object)this);
            }
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Bot[unrealId=" + botId.getStringId() + "] switched to team " + desiredTeam + ".");
            }
        }
        finally {
            ((UT2004WorldView)server.getWorldView()).removeObjectListener((WorldObjectId)botId, (IWorldObjectEventListener)playerListener);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Bots startBots(UCCWrapper ucc, UT2004Server server) {
        block44: {
            block43: {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine(String.valueOf(this.config.getMatchId().getToken()) + ": Starting custom & native bots...");
                }
                NullCheck.check((Object)ucc, (String)"ucc");
                NullCheck.check((Object)server, (String)"server");
                bots = new Bots();
                server.getAct().act((CommandMessage)new StartPlayers());
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new PogamutInterruptedException("Interrupted while awaiting start of players' exporting on the server.", (Logger)this.log, (Object)e);
                }
                if (server.getPlayers().size() > 0) {
                    throw new PogamutException("There are already some bots/players/native bots connected to the game, even though we have not started to connect any of them yet. INVALID STATE!", (Logger)this.log, (Object)this);
                }
                connecting = new AdaptableProvider(null);
                latch = new AdaptableProvider(null);
                playerListener /* !! */  = new CollectionEventListener<Player>(){

                    public void postAddEvent(Collection<Player> alreadyAdded, Collection<Player> whereWereAdded) {
                    }

                    public void postRemoveEvent(Collection<Player> alreadyAdded, Collection<Player> whereWereRemoved) {
                        if (alreadyAdded.size() == 0) {
                            return;
                        }
                    }

                    public void preAddEvent(Collection<Player> toBeAdded, Collection<Player> whereToAdd) {
                        if (toBeAdded.size() == 0) {
                            return;
                        }
                        if (toBeAdded.size() > 1) {
                            throw new PogamutException("(CustomBot connecting) More than one player connected at a single time? We're not doing this, something has failed, or someone has hacked into the game.", (Logger)UT2004Match.this.log, (Object)this);
                        }
                        Player player = toBeAdded.iterator().next();
                        if (UT2004Match.this.log != null && UT2004Match.this.log.isLoggable(Level.FINE)) {
                            UT2004Match.this.log.fine(String.valueOf(((UT2004MatchConfig)UT2004Match.this.config).getMatchId().getToken()) + ": New bot connected to GB2004. Bot[unrealId=" + player.getId().getStringId() + ", name=" + player.getName() + "], binding its unrealId to botId " + ((IToken)connecting.get()).getToken() + ".");
                        }
                        bots.botId2UnrealId.put((IToken)connecting.get(), player.getId());
                        bots.unrealId2BotId.put(player.getId(), (IToken)connecting.get());
                        ((CountDownLatch)latch.get()).countDown();
                    }

                    public void preRemoveEvent(Collection<Player> toBeRemoved, Collection<Player> whereToRemove) {
                        if (toBeRemoved.size() == 0) {
                            return;
                        }
                        if (UT2004Match.this.log != null && UT2004Match.this.log.isLoggable(Level.WARNING)) {
                            StringBuffer sb = new StringBuffer();
                            sb.append(String.valueOf(((UT2004MatchConfig)UT2004Match.this.config).getMatchId().getToken()) + ": Bot(s) removed from GB2004!!!");
                            boolean first = true;
                            for (Player plr : toBeRemoved) {
                                if (first) {
                                    first = false;
                                } else {
                                    sb.append(", ");
                                }
                                sb.append("Bot[unrealId=" + plr.getId().getStringId() + ", name=" + plr.getName() + "]");
                            }
                            UT2004Match.this.log.warning(sb.toString());
                        }
                        throw new PogamutException("(CustomBot connecting) There can't be any 'removes' at this stage.", (Logger)UT2004Match.this.log, (Object)this);
                    }
                };
                server.getPlayers().addCollectionListener((CollectionEventListener)playerListener /* !! */ );
                exception = false;
                try {
                    try {
                        var9_9 = this.config.getBots().values().iterator();
                        while (true) {
                            if (!var9_9.hasNext()) {
                                if (bots.botId2UnrealId.size() == this.config.getBots().size()) break;
                                throw new PogamutException("(CustomBot connecting) Not all mappings BotId<->UnrealId has been created. **PUZZLING**", (Logger)this.log, (Object)this);
                            }
                            var8_10 = var9_9.next();
                            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                                this.log.fine(String.valueOf(this.config.getMatchId().getToken()) + ": Starting custom Bot[botId=" + var8_10.getBotId().getToken() + "]...");
                            }
                            if (server.notInState(new Class[]{IAgentStateUp.class})) {
                                throw new PogamutException("(CustomBot connecting) Server is DEAD! Some previous exception will have the explanation...", (Logger)this.log, (Object)this);
                            }
                            latch.set((Object)new CountDownLatch(1));
                            connecting.set((Object)var8_10.getBotId());
                            execution = new UT2004BotExecution(var8_10, (Logger)this.log);
                            botObs = new FlagListener<Boolean>(){

                                public void flagChanged(Boolean changedValue) {
                                    if (!changedValue.booleanValue()) {
                                        ((CountDownLatch)latch.get()).countDown();
                                    }
                                }
                            };
                            execution.getRunning().addListener((FlagListener)botObs);
                            try {
                                bots.bots.put(var8_10.getBotId(), execution);
                                execution.start(ucc.getHost(), ucc.getBotPort());
                                ((CountDownLatch)latch.get()).await(120000L, TimeUnit.MILLISECONDS);
                            }
                            finally {
                                execution.getRunning().removeListener((FlagListener)botObs);
                            }
                            if (!execution.isRunning()) {
                                throw new PogamutException("(CustomBot connecting) Bot[botId=" + var8_10.getBotId().getToken() + "] startup failed!", (Logger)this.log, (Object)this);
                            }
                            if (((CountDownLatch)latch.get()).getCount() > 0L) {
                                throw new PogamutException("(CustomBot connecting) Bot[botId=" + var8_10.getBotId().getToken() + "], startup failed! It does not showed up on server for 2 minutes... either failed to start, or " + server + " failed to got its presence from GB2004.", (Logger)this.log, (Object)this);
                            }
                            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                                this.log.info(String.valueOf(this.config.getMatchId().getToken()) + ": Started custom Bot[botId=" + var8_10.getBotId().getToken() + ", unrealId=" + bots.getUnrealId(var8_10.getBotId()).getStringId() + "].");
                            }
                            if (var8_10.getTeamNumber() < 0 || var8_10.getTeamNumber() >= 8) continue;
                            this.changeBotTeam(server, bots.getUnrealId(var8_10.getBotId()), var8_10.getTeamNumber());
                        }
                        if (bots.unrealId2BotId.size() != this.config.getBots().size()) {
                            throw new PogamutException("(CustomBot connecting) Not all mappings UnrealId<->BotId has been created. **PUZZLING**", (Logger)this.log, (Object)this);
                        }
                    }
                    catch (Exception var8_11) {
                        exception = true;
                        if (var8_11 instanceof PogamutException) {
                            throw (PogamutException)var8_11;
                        }
                        throw new PogamutException("(CustomBot connecting) Can't start all custom bots! Exception happened while starting " + ((IToken)connecting.get()).getToken() + ".", (Throwable)var8_11, (Logger)this.log, (Object)this);
                    }
                }
                finally {
                    if (!exception) break block43;
                    ** for (execution : bots.bots.values())
                }
lbl-1000:
                // 1 sources

                {
                    execution.stop();
                    continue;
                }
lbl70:
                // 1 sources

                bots.bots.clear();
            }
            server.getPlayers().removeCollectionListener((CollectionEventListener)playerListener /* !! */ );
            connecting = new AdaptableProvider(null);
            latch = new AdaptableProvider(null);
            playerListener /* !! */  = new CollectionEventListener<Player>(){

                public void postAddEvent(Collection<Player> alreadyAdded, Collection<Player> whereWereAdded) {
                }

                public void postRemoveEvent(Collection<Player> alreadyAdded, Collection<Player> whereWereRemoved) {
                    if (alreadyAdded.size() == 0) {
                        return;
                    }
                }

                public void preAddEvent(Collection<Player> toBeAdded, Collection<Player> whereToAdd) {
                    if (toBeAdded.size() == 0) {
                        return;
                    }
                    if (toBeAdded.size() > 1) {
                        throw new PogamutException("(NativeBot connecting) More than one player connected at a single time? We're not doing this, something has failed, or someone has hacked into the game.", (Logger)UT2004Match.this.log, (Object)this);
                    }
                    Player player = toBeAdded.iterator().next();
                    if (UT2004Match.this.log != null && UT2004Match.this.log.isLoggable(Level.FINE)) {
                        UT2004Match.this.log.fine(String.valueOf(((UT2004MatchConfig)UT2004Match.this.config).getMatchId().getToken()) + ": New bot connected to GB2004. Bot[unrealId=" + player.getId().getStringId() + ", name=" + player.getName() + "], binding its unrealId to botId " + ((IToken)connecting.get()).getToken() + "...");
                    }
                    bots.nativeBotId2UnrealId.put((IToken)connecting.get(), player.getId());
                    bots.nativeUnrealId2BotId.put(player.getId(), (IToken)connecting.get());
                    ((CountDownLatch)latch.get()).countDown();
                }

                public void preRemoveEvent(Collection<Player> toBeRemoved, Collection<Player> whereToRemove) {
                    if (toBeRemoved.size() == 0) {
                        return;
                    }
                    if (UT2004Match.this.log != null && UT2004Match.this.log.isLoggable(Level.WARNING)) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(String.valueOf(((UT2004MatchConfig)UT2004Match.this.config).getMatchId().getToken()) + ": Bot(s) removed from GB2004!!!");
                        boolean first = true;
                        for (Player plr : toBeRemoved) {
                            if (first) {
                                first = false;
                            } else {
                                sb.append(", ");
                            }
                            sb.append("Bot[unrealId=" + plr.getId().getStringId() + ", name=" + plr.getName() + "]");
                        }
                        UT2004Match.this.log.warning(sb.toString());
                    }
                    throw new PogamutException("(NativeBot connecting) There can't be any 'removes' at this stage.", (Logger)UT2004Match.this.log, (Object)this);
                }
            };
            server.getPlayers().addCollectionListener((CollectionEventListener)playerListener /* !! */ );
            exception = false;
            try {
                try {
                    var9_9 = this.config.getNativeBots().values().iterator();
                    while (true) {
                        if (!var9_9.hasNext()) {
                            if (bots.nativeBotId2UnrealId.size() == this.config.getNativeBots().size()) break;
                            throw new PogamutException("(NativeBot connecting) Not all mappings BotId<->UnrealId has been created. **PUZZLING**", (Logger)this.log, (Object)this);
                        }
                        var8_13 = (UT2004NativeBotConfig)var9_9.next();
                        if (this.log != null && this.log.isLoggable(Level.FINE)) {
                            this.log.fine(String.valueOf(this.config.getMatchId().getToken()) + ": Starting native Bot[botId=" + var8_13.getBotId().getToken() + "]...");
                        }
                        if (server.notInState(new Class[]{IAgentStateUp.class})) {
                            throw new PogamutException("(NativeBot connecting) Server is DEAD! Some previous exception will have the explanation...", (Logger)this.log, (Object)this);
                        }
                        latch.set((Object)new CountDownLatch(1));
                        connecting.set((Object)var8_13.getBotId());
                        addBotCommand = new AddBot().setType(var8_13.getBotId().getToken()).setSkill(Integer.valueOf(var8_13.getSkillLevel()));
                        teamNumber = var8_13.getTeamNumber();
                        addBotCommand.setTeam(teamNumber);
                        server.getAct().act((CommandMessage)addBotCommand);
                        ((CountDownLatch)latch.get()).await(120000L, TimeUnit.MILLISECONDS);
                        if (((CountDownLatch)latch.get()).getCount() > 0L) {
                            throw new PogamutException("(NativeBot connecting) We're tried to start up native bot " + var8_13.getBotId().getToken() + ", but it does not showed up on server for 2 minutes... either failed to start, or " + server + " failed to got it from GB2004.", (Logger)this.log, (Object)this);
                        }
                        if (this.log != null && this.log.isLoggable(Level.INFO)) {
                            this.log.info(String.valueOf(this.config.getMatchId().getToken()) + ": Started native Bot[botId=" + var8_13.getBotId().getToken() + ", unrealId=" + bots.getUnrealId(var8_13.getBotId()).getStringId() + "].");
                        }
                        if (var8_13.getTeamNumber() < 0 || var8_13.getTeamNumber() >= 8) continue;
                        this.changeBotTeam(server, bots.getUnrealId(var8_13.getBotId()), var8_13.getTeamNumber());
                    }
                    if (bots.nativeUnrealId2BotId.size() != this.config.getNativeBots().size()) {
                        throw new PogamutException("(NativeBot connecting) Not all mappings UnrealId<->BotId has been created. **PUZZLING**", (Logger)this.log, (Object)this);
                    }
                }
                catch (Exception var8_14) {
                    exception = true;
                    if (var8_14 instanceof PogamutException) {
                        throw (PogamutException)var8_14;
                    }
                    throw new PogamutException("(NativeBot connecting) Can't start all native bots! Exception happened while starting " + ((IToken)connecting.get()).getToken() + ".", (Throwable)var8_14, (Logger)this.log, (Object)this);
                }
            }
            finally {
                if (!exception) break block44;
                ** for (execution : bots.bots.values())
            }
lbl-1000:
            // 1 sources

            {
                execution.stop();
                continue;
            }
lbl121:
            // 3 sources

            for (UnrealId id : bots.nativeUnrealId2BotId.keySet()) {
                try {
                    server.getAct().act((CommandMessage)new Kick(id));
                }
                catch (Exception var15_25) {
                    // empty catch block
                }
            }
        }
        server.getPlayers().removeCollectionListener((CollectionEventListener)playerListener /* !! */ );
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(this.config.getMatchId().getToken()) + ": All custom & native bots are up and running in correct teams..");
        }
        return bots;
    }

    protected UT2004Analyzer startAnalyzer(UCCWrapper ucc, Bots bots, File outputDirectory) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Starting UT2004Analyzer...");
        }
        NullCheck.check((Object)ucc, (String)"ucc");
        NullCheck.check((Object)bots, (String)"bots");
        NullCheck.check((Object)outputDirectory, (String)"outputDirectory");
        UT2004AnalyzerModule module = new UT2004AnalyzerModule();
        UT2004AnalyzerFactory factory = new UT2004AnalyzerFactory(module);
        HashMap<UnrealId, String> fileNames = new HashMap<UnrealId, String>();
        for (Map.Entry<UnrealId, IToken> entry : bots.unrealId2BotId.entrySet()) {
            fileNames.put(entry.getKey(), entry.getValue().getToken());
        }
        UT2004Analyzer analyzer = (UT2004Analyzer)factory.newAgent((IAgentParameters)new UT2004AnalyzerParameters().setAgentId((IAgentId)new AgentId(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + "-UT2004Analyzer")).setWorldAddress((IWorldConnectionAddress)ucc.getServerAddress()).setObserverModule((UT2004AnalyzerObserverModule)new UT2004AnalyzerObsStatsModule()).setObserverAddress(ucc.getObserverAddress()).setWaitForMatchRestart(true).setOutputPath(this.getOutputPath("bots").getAbsolutePath()).setFileNames(fileNames));
        analyzer.getLogger().setLevel(Level.WARNING);
        analyzer.getLogger().addDefaultConsoleHandler();
        final CountDownLatch observersLatch = new CountDownLatch(bots.unrealId2BotId.size());
        final Bots myBots = bots;
        IAnalyzerObserverListener observerListener = new IAnalyzerObserverListener(){

            public void observerAdded(UnrealId botId, IUT2004AnalyzerObserver observer) {
                if (!myBots.unrealId2BotId.containsKey(botId)) {
                    throw new PogamutException("Observer has been created for the bot with unknown id " + botId.getStringId() + ", this bot should not be part of the tournament.", (Logger)UT2004Match.this.log, (Object)this);
                }
                myBots.botObservers.put(myBots.unrealId2BotId.get(botId), observer);
                observersLatch.countDown();
            }

            public void observerRemoved(UnrealId botId, IUT2004AnalyzerObserver observer) {
                throw new PogamutException("Observer can't be removed at this stage (analyzer initialization), this indicates ERROR in the match!", (Logger)UT2004Match.this.log, (Object)this);
            }
        };
        analyzer.addListener(observerListener);
        analyzer.start();
        try {
            observersLatch.await(300000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            analyzer.removeListener(observerListener);
            analyzer.kill();
            throw new PogamutInterruptedException("Interrupted while awaiting for observers to be setup for bots.", (Logger)this.log, (Object)this);
        }
        analyzer.removeListener(observerListener);
        if (observersLatch.getCount() > 0L) {
            analyzer.kill();
            throw new PogamutException("Timeout (5min) - not all observers has been attached within 5 minutes.", (Logger)this.log, (Object)this);
        }
        if (analyzer.notInState(new Class[]{IAgentStateUp.class})) {
            analyzer.kill();
            throw new PogamutException("After all observers have been started, analyzer was found DEAD... :-(", (Logger)this.log, (Object)this);
        }
        if (bots.botObservers.size() != ((UT2004MatchConfig)this.config).getBots().size()) {
            analyzer.kill();
            throw new PogamutException("Not all observers have been attached to running custom bots :-(", (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": UT2004Analyzer started.");
        }
        return analyzer;
    }

    protected void matchIsAboutToBegin(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, Bots bots) {
    }

    protected void restartMatch(UT2004Server server, Bots bots) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Restarting match...");
        }
        NullCheck.check((Object)server, (String)"server");
        final BusAwareCountDownLatch latch = new BusAwareCountDownLatch(1, server.getEventBus(), new IComponent[]{server.getWorldView()});
        IWorldEventListener<GameRestarted> listener = new IWorldEventListener<GameRestarted>(){

            public void notify(GameRestarted event) {
                if (event.isFinished()) {
                    latch.countDown();
                }
            }
        };
        if (bots.botObservers.size() > 0 && this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Waiting for 5 seconds, to give GB2004 time to initialize observers...");
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException("Interrupted while giving GB2004 time to hook up listeners...", (Logger)this.log, (Object)this);
        }
        ((UT2004WorldView)server.getWorldView()).addEventListener(GameRestarted.class, (IWorldEventListener)listener);
        server.getAct().act((CommandMessage)new GameConfiguration().setRestart(Boolean.valueOf(true)));
        latch.await(300000L, TimeUnit.MILLISECONDS);
        if (latch.getCount() > 0L) {
            throw new PogamutException("Restart was not successful, event GameRestarted[finished==true] was not received.", (Logger)this.log, (Object)this);
        }
        bots.matchStart = System.currentTimeMillis();
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Match restarted.");
        }
    }

    protected void recordReplay(UT2004Server server, String fileName) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Recording replay " + fileName);
        }
        server.getAct().act((CommandMessage)new Record(fileName));
    }

    protected abstract UT2004MatchResult waitMatchFinish(UCCWrapper var1, UT2004Server var2, UT2004Analyzer var3, Bots var4, long var5);

    public void restoreGB2004IniBackup() {
        File gb2004File = this.getGB2004IniFile();
        File gb2004FileBackup = new File(String.valueOf(gb2004File.getParent()) + File.separator + "GameBots2004.ini.backup");
        if (gb2004FileBackup.isFile() && gb2004FileBackup.exists()) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Restoring " + gb2004File.getAbsolutePath() + " into + " + gb2004FileBackup.getAbsolutePath() + " ...");
            }
            boolean restore = true;
            try {
                FileUtils.copyFile((File)gb2004FileBackup, (File)gb2004File);
            }
            catch (IOException e) {
                restore = false;
            }
            if (restore && this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": GameBots2004.ini restored from " + gb2004FileBackup.getAbsolutePath() + ".");
            } else if (!restore && this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Failed to restore up GameBots2004.ini from " + gb2004FileBackup.getAbsolutePath() + " into + " + gb2004File.getAbsolutePath() + " !!!");
            }
        }
    }

    protected void copyReplay(UCCWrapper ucc, String fileName, File outputDirectory) {
        boolean ex;
        File destination;
        block4: {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Copying replay file into " + outputDirectory.getAbsolutePath());
            }
            File replayFile = new File(String.valueOf(ucc.getConfiguration().getUnrealHome()) + File.separator + "Demos" + File.separator + fileName + ".demo4");
            destination = new File(outputDirectory.getAbsoluteFile() + File.separator + "match-" + ((UT2004MatchConfig)this.config).getMatchId().getToken() + "-replay.demo4");
            FilePath.makeDirsToFile((File)destination);
            ex = false;
            try {
                FileUtils.copyFile((File)replayFile, (File)destination);
            }
            catch (IOException e) {
                ex = true;
                if (this.log == null) break block4;
                this.log.warning(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Failed to copy replay file from: " + replayFile.getAbsolutePath() + " into " + destination.getAbsolutePath() + ": " + e.getMessage());
            }
        }
        if (!ex && this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Replay copied into " + destination.getAbsolutePath());
        }
    }

    protected abstract void outputResults(UCCWrapper var1, UT2004Server var2, UT2004Analyzer var3, Bots var4, UT2004MatchResult var5, File var6);

    protected void shutdownAll(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, Bots bots) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Shutting down everything...");
        }
        if (ucc != null) {
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Killing UCC...");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ucc.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (server != null) {
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Killing UT2004Server...");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                server.kill();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bots != null) {
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Killing Custom bots...");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bots.bots != null) {
                for (UT2004BotExecution exec : bots.bots.values()) {
                    try {
                        exec.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Killing Custom bot observers...");
                }
            }
            catch (Exception exec) {
                // empty catch block
            }
            if (bots.botObservers != null) {
                for (IUT2004AnalyzerObserver obs : bots.botObservers.values()) {
                    try {
                        obs.kill();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (analyzer != null) {
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Killing UT2004Analyzer...");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                analyzer.kill();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": UCC, Bots, UT2004Server, UT2004Analyzer + observers were shut down.");
        }
    }

    protected void closeLogger() {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Closing file output...");
        }
        if (this.fileHandler != null) {
            if (this.log != null) {
                this.log.removeHandler((Handler)this.fileHandler);
            }
            this.fileHandler.close();
            this.fileHandler = null;
        }
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(String.valueOf(((UT2004MatchConfig)this.config).getMatchId().getToken()) + ": Logging to file stopped.");
        }
    }

    public static class Bots {
        public Map<IToken, UnrealId> botId2UnrealId = new HashMap<IToken, UnrealId>();
        public Map<UnrealId, IToken> unrealId2BotId = new HashMap<UnrealId, IToken>();
        public Map<IToken, UnrealId> nativeBotId2UnrealId = new HashMap<IToken, UnrealId>();
        public Map<UnrealId, IToken> nativeUnrealId2BotId = new HashMap<UnrealId, IToken>();
        public Map<IToken, UT2004BotExecution> bots = new HashMap<IToken, UT2004BotExecution>();
        public Map<IToken, IUT2004AnalyzerObserver> botObservers = new HashMap<IToken, IUT2004AnalyzerObserver>();
        public long matchStart = 0L;
        public long matchEnd = 0L;

        public UnrealId getUnrealId(IToken botId) {
            UnrealId result = this.botId2UnrealId.get(botId);
            if (result != null) {
                return result;
            }
            return this.nativeBotId2UnrealId.get(botId);
        }

        public IToken getBotId(UnrealId unrealId) {
            IToken result = this.unrealId2BotId.get(unrealId);
            if (result != null) {
                return result;
            }
            return this.nativeUnrealId2BotId.get(unrealId);
        }

        public boolean isNativeBot(IToken botId) {
            return this.nativeBotId2UnrealId.containsKey(botId);
        }

        public boolean isNativeBot(UnrealId unrealId) {
            return this.nativeUnrealId2BotId.containsKey(unrealId);
        }
    }
}

