/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.summary;

import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.summary.TDMMatchesResult;
import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.summary.TDMMatchesTableTeamResult;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.maps.HashMapMap;
import cz.cuni.amis.utils.maps.LazyMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class TDMMatchesTableResults {
    public Map<String, TDMMatchesTableTeamResult> teams = new LazyMap<String, TDMMatchesTableTeamResult>(){

        protected TDMMatchesTableTeamResult create(String key) {
            return new TDMMatchesTableTeamResult(key);
        }
    };
    public HashMapMap<String, String, TDMMatchesResult> results = new HashMapMap();

    protected void info(String msg) {
        System.out.println("[INFO] " + msg);
    }

    protected void warn(String msg) {
        System.out.println("[WARN] " + msg);
    }

    protected void error(String msg) {
        System.out.println("[ERROR] " + msg);
    }

    public TDMMatchesResult getMatchResult(String plr1, String plr2) {
        if (plr1.compareToIgnoreCase(plr2) > 0) {
            String temp = plr2;
            plr2 = plr1;
            plr1 = temp;
        }
        return (TDMMatchesResult)this.results.get((Object)plr1, (Object)plr2);
    }

    public TDMMatchesResult addResult(String team1, String team2, int score1, int score2, int frags1, int frags2, int deaths1, int deaths2, int exceptions1, int exceptions2) {
        if (team1.compareToIgnoreCase(team2) == 0) {
            throw new RuntimeException("Could not add result for " + team1 + " vs. " + team2 + " as their names are the same!");
        }
        if (team1.compareToIgnoreCase(team2) > 0) {
            String temp = team2;
            team2 = team1;
            team1 = temp;
            int tempI = score2;
            score2 = score1;
            score1 = tempI;
            tempI = frags2;
            frags2 = frags1;
            frags1 = tempI;
            tempI = deaths2;
            deaths2 = deaths1;
            deaths1 = tempI;
            tempI = exceptions2;
            exceptions2 = exceptions1;
            exceptions1 = tempI;
        }
        TDMMatchesTableTeamResult team1Result = this.teams.get(team1);
        TDMMatchesTableTeamResult team2Result = this.teams.get(team2);
        TDMMatchesResult result = new TDMMatchesResult(team1, team2, score1, score2, frags1, frags2, deaths1, deaths2, exceptions1, exceptions2);
        TDMMatchesResult old = (TDMMatchesResult)this.results.put((Object)team1, (Object)team2, (Object)result);
        if (old != null) {
            throw new RuntimeException("There are more than one result for " + team1 + " vs. " + team2 + "! First result [" + old.score1 + ":" + old.score2 + "], second result [" + score1 + ":" + score2 + "].");
        }
        team1Result.result(result);
        team2Result.result(result);
        return result;
    }

    public List<TDMMatchesTableTeamResult> resolve() {
        int end;
        this.info("RESOLVING TABLE");
        List results = MyCollections.asList(this.teams.values());
        Collections.sort(results, new Comparator<TDMMatchesTableTeamResult>(){

            @Override
            public int compare(TDMMatchesTableTeamResult o1, TDMMatchesTableTeamResult o2) {
                if (o1.wins == o2.wins) {
                    TDMMatchesResult result = TDMMatchesTableResults.this.getMatchResult(o1.team, o2.team);
                    return result.getScore(o2.team) - result.getScore(o1.team);
                }
                return o2.wins - o1.wins;
            }
        });
        int i = 0;
        while (i < results.size()) {
            int start = i;
            end = results.size() - 1;
            int j = i + 1;
            while (j < results.size()) {
                if (((TDMMatchesTableTeamResult)results.get((int)i)).wins != ((TDMMatchesTableTeamResult)results.get((int)j)).wins) {
                    end = j - 1;
                    break;
                }
                ++j;
            }
            i = end + 1;
            if (start == end) {
                ((TDMMatchesTableTeamResult)results.get((int)start)).position = start + 1;
                continue;
            }
            if (start + 1 == end) {
                TDMMatchesTableTeamResult result1 = (TDMMatchesTableTeamResult)results.get(start);
                TDMMatchesTableTeamResult result2 = (TDMMatchesTableTeamResult)results.get(start + 1);
                String player1 = ((TDMMatchesTableTeamResult)results.get((int)start)).team;
                String player2 = ((TDMMatchesTableTeamResult)results.get((int)(start + 1))).team;
                TDMMatchesResult match = this.getMatchResult(player1, player2);
                if (match != null) {
                    if (match.isWin(player1)) {
                        result1.position = start + 1;
                        result2.position = start + 2;
                        continue;
                    }
                    if (match.isWin(player2)) {
                        result1.position = start + 2;
                        result2.position = start + 1;
                        continue;
                    }
                }
                result1.position = end + 1;
                result2.position = end + 1;
            }
            j = start;
            while (j <= end) {
                ((TDMMatchesTableTeamResult)results.get((int)j)).position = end + 1;
                ++j;
            }
        }
        int start = 0;
        while (start < results.size()) {
            int position = ((TDMMatchesTableTeamResult)results.get((int)start)).position;
            end = start + 1;
            while (end < results.size() && position == ((TDMMatchesTableTeamResult)results.get((int)end)).position) {
                ++end;
            }
            if (start == --end) {
                ++start;
                continue;
            }
            boolean dominating = false;
            int candidate = start;
            while (candidate <= end) {
                boolean candidateDominating = true;
                TDMMatchesTableTeamResult result = (TDMMatchesTableTeamResult)results.get(candidate);
                String candidatePlr = result.team;
                int other = start;
                while (other <= end) {
                    String otherPlr;
                    TDMMatchesResult match;
                    if (candidate != other && !(match = this.getMatchResult(candidatePlr, otherPlr = ((TDMMatchesTableTeamResult)results.get((int)other)).team)).isWin(candidatePlr)) {
                        candidateDominating = false;
                        break;
                    }
                    ++other;
                }
                if (candidateDominating) {
                    if (candidate != start) {
                        TDMMatchesTableTeamResult candidateResult = (TDMMatchesTableTeamResult)results.get(candidate);
                        TDMMatchesTableTeamResult startResult = (TDMMatchesTableTeamResult)results.get(start);
                        results.set(start, candidateResult);
                        results.set(candidate, startResult);
                    }
                    ((TDMMatchesTableTeamResult)results.get((int)start)).position -= end - start;
                    dominating = true;
                    break;
                }
                ++candidate;
            }
            if (dominating) {
                ++start;
                continue;
            }
            start = end + 1;
        }
        return results;
    }
}

