/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.one;

import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.one.TDMOneMatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.one.TDMOneMatchTableTeamResult;
import cz.cuni.amis.pogamut.ut2004.tournament.utils.CSV;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.maps.HashMapMap;
import cz.cuni.amis.utils.maps.LazyMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class TDMOneMatchTableResults {
    public String mapName;
    public int mapNumber;
    public Map<String, TDMOneMatchTableTeamResult> teams = new LazyMap<String, TDMOneMatchTableTeamResult>(){

        protected TDMOneMatchTableTeamResult create(String key) {
            return new TDMOneMatchTableTeamResult(key);
        }
    };
    public HashMapMap<String, String, TDMOneMatchResult> results = new HashMapMap();

    public TDMOneMatchTableResults(String mapName, int mapNumber) {
        this.mapName = mapName;
        this.mapNumber = mapNumber;
    }

    protected void info(String msg) {
        System.out.println("[INFO] " + msg);
    }

    protected void warn(String msg) {
        System.out.println("[WARN] " + msg);
    }

    protected void error(String msg) {
        System.out.println("[ERROR] " + msg);
    }

    public TDMOneMatchResult getMatchResult(String plr1, String plr2) {
        if (plr1.compareToIgnoreCase(plr2) > 0) {
            String temp = plr2;
            plr2 = plr1;
            plr1 = temp;
        }
        return (TDMOneMatchResult)this.results.get((Object)plr1, (Object)plr2);
    }

    public TDMOneMatchResult addResult(String team1, String team2, int score1, int score2, boolean[] botLogicEx, String[] botEx) {
        if (team1.compareToIgnoreCase(team2) == 0) {
            throw new RuntimeException("Could not add result for " + team1 + " vs. " + team2 + " as their names are the same!");
        }
        if (team1.compareToIgnoreCase(team2) > 0) {
            String temp = team2;
            team2 = team1;
            team1 = temp;
            int tempI = score2;
            score2 = score1;
            score1 = tempI;
            boolean tempB = botLogicEx[1];
            botLogicEx[1] = botLogicEx[0];
            botLogicEx[0] = tempB;
            String tempS = botEx[1];
            botEx[1] = botEx[0];
            botEx[0] = tempS;
        }
        TDMOneMatchTableTeamResult team1Result = this.teams.get(team1);
        TDMOneMatchTableTeamResult team2Result = this.teams.get(team2);
        TDMOneMatchResult result = new TDMOneMatchResult(team1, team2, score1, score2, botLogicEx[0], botLogicEx[1], botEx[0], botEx[1]);
        TDMOneMatchResult old = (TDMOneMatchResult)this.results.put((Object)team1, (Object)team2, (Object)result);
        if (old != null) {
            throw new RuntimeException("There are more than one result for " + team1 + " vs. " + team2 + "! First result [" + old.score1 + ":" + old.score2 + "], second result [" + score1 + ":" + score2 + "].");
        }
        team1Result.result(result);
        team2Result.result(result);
        return result;
    }

    public List<TDMOneMatchTableTeamResult> resolve() {
        int end;
        this.info("RESOLVING TABLE");
        List results = MyCollections.asList(this.teams.values());
        Collections.sort(results, new Comparator<TDMOneMatchTableTeamResult>(){

            @Override
            public int compare(TDMOneMatchTableTeamResult o1, TDMOneMatchTableTeamResult o2) {
                if (o1.wins == o2.wins) {
                    TDMOneMatchResult result = TDMOneMatchTableResults.this.getMatchResult(o1.team, o2.team);
                    if (result == null) {
                        return 0;
                    }
                    return result.getScore(o2.team) - result.getScore(o1.team);
                }
                return o2.wins - o1.wins;
            }
        });
        int i = 0;
        while (i < results.size()) {
            int start = i;
            end = results.size() - 1;
            int j = i + 1;
            while (j < results.size()) {
                if (((TDMOneMatchTableTeamResult)results.get((int)i)).wins != ((TDMOneMatchTableTeamResult)results.get((int)j)).wins) {
                    end = j - 1;
                    break;
                }
                ++j;
            }
            i = end + 1;
            if (start == end) {
                ((TDMOneMatchTableTeamResult)results.get((int)start)).position = start + 1;
                continue;
            }
            if (start + 1 == end) {
                TDMOneMatchTableTeamResult result1 = (TDMOneMatchTableTeamResult)results.get(start);
                TDMOneMatchTableTeamResult result2 = (TDMOneMatchTableTeamResult)results.get(start + 1);
                String player1 = ((TDMOneMatchTableTeamResult)results.get((int)start)).team;
                String player2 = ((TDMOneMatchTableTeamResult)results.get((int)(start + 1))).team;
                TDMOneMatchResult match = this.getMatchResult(player1, player2);
                if (match != null) {
                    if (match.isWin(player1)) {
                        result1.position = start + 1;
                        result2.position = start + 2;
                        continue;
                    }
                    if (match.isWin(player2)) {
                        result1.position = start + 2;
                        result2.position = start + 1;
                        continue;
                    }
                }
                result1.position = end + 1;
                result2.position = end + 1;
            }
            j = start;
            while (j <= end) {
                ((TDMOneMatchTableTeamResult)results.get((int)j)).position = end + 1;
                ++j;
            }
        }
        int start = 0;
        while (start < results.size()) {
            int position = ((TDMOneMatchTableTeamResult)results.get((int)start)).position;
            end = start + 1;
            while (end < results.size() && position == ((TDMOneMatchTableTeamResult)results.get((int)end)).position) {
                ++end;
            }
            if (start == --end) {
                ++start;
                continue;
            }
            boolean dominating = false;
            int candidate = start;
            while (candidate <= end) {
                boolean candidateDominating = true;
                TDMOneMatchTableTeamResult result = (TDMOneMatchTableTeamResult)results.get(candidate);
                String candidatePlr = result.team;
                int other = start;
                while (other <= end) {
                    String otherPlr;
                    TDMOneMatchResult match;
                    if (candidate != other && !(match = this.getMatchResult(candidatePlr, otherPlr = ((TDMOneMatchTableTeamResult)results.get((int)other)).team)).isWin(candidatePlr)) {
                        candidateDominating = false;
                        break;
                    }
                    ++other;
                }
                if (candidateDominating) {
                    if (candidate != start) {
                        TDMOneMatchTableTeamResult candidateResult = (TDMOneMatchTableTeamResult)results.get(candidate);
                        TDMOneMatchTableTeamResult startResult = (TDMOneMatchTableTeamResult)results.get(start);
                        results.set(start, candidateResult);
                        results.set(candidate, startResult);
                    }
                    ((TDMOneMatchTableTeamResult)results.get((int)start)).position -= end - start;
                    dominating = true;
                    break;
                }
                ++candidate;
            }
            if (dominating) {
                ++start;
                continue;
            }
            start = end + 1;
        }
        return results;
    }

    public void probeResults(File dir) {
        this.probeResults(dir);
    }

    public void probeResults(File dir, boolean recursive) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists()) {
                if (file.isDirectory() && recursive) {
                    this.probeResults(file, recursive);
                }
                if (file.exists() && file.isFile()) {
                    try {
                        this.probeResultFile(file);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to process file: " + file.getAbsolutePath(), e);
                    }
                }
            }
            ++n2;
        }
    }

    private void probeResultFile(File resultFile) throws FileNotFoundException, IOException {
        String team2;
        String team1;
        if (!(resultFile.exists() && resultFile.isFile() && resultFile.getAbsolutePath().toLowerCase().endsWith("-result.csv"))) {
            return;
        }
        this.info("Found result file: " + resultFile.getAbsolutePath());
        File teamScoresFile = new File(resultFile.getAbsolutePath().replace("-result.csv", "-team-scores.csv"));
        if (!teamScoresFile.exists()) {
            this.error("Cannot locate team-scores file at: " + teamScoresFile);
            return;
        }
        this.info("Found team-scores file: " + teamScoresFile.getAbsolutePath());
        File logFile = new File(resultFile.getAbsolutePath().replace("-result.csv", ".log"));
        if (logFile.exists()) {
            this.info("Found non-zipped log file, zipping: " + logFile.getAbsolutePath());
            this.zipLogFile(logFile);
        }
        if (!(logFile = new File(resultFile.getAbsolutePath().replace("-result.csv", ".log.zip"))).exists()) {
            this.error("Cannot locate zipped-log file at: " + logFile);
            return;
        }
        this.info("Found zipped-log file: " + logFile.getAbsolutePath());
        CSV resultCSV = new CSV(resultFile, ";", true);
        if (resultCSV.rows.size() != 1) {
            this.warn("-- Result file contains invalid number of data rows (" + resultCSV.rows.size() + "), ignoring.");
            return;
        }
        if (!resultCSV.keys.contains("Winner")) {
            this.warn("-- Result file does not contain column 'Winner'. Ignoring.");
            return;
        }
        String winner = resultCSV.rows.get(0).getString("Winner");
        if (winner.toLowerCase().contains("failure")) {
            this.error("-- Result file is indicating that the match has FAILED!");
            return;
        }
        CSV teamScoresCSV = new CSV(teamScoresFile, ";", true);
        if (teamScoresCSV.rows.size() != 2) {
            this.warn("-- Team scores contains invalid number of data rows (" + teamScoresCSV.rows.size() + "), ignoring.");
            return;
        }
        File botScoresFile = new File(resultFile.getAbsolutePath().replace("-result.csv", "-bot-scores.csv"));
        if (!botScoresFile.exists()) {
            this.error("Cannot locate bot-scores file at: " + botScoresFile.getAbsolutePath());
            return;
        }
        this.info("Found bot-scores file: " + botScoresFile.getAbsolutePath());
        CSV botScoresCSV = null;
        try {
            botScoresCSV = new CSV(botScoresFile, ";", true);
            if (!botScoresCSV.keys.contains("team")) {
                this.warn("-- Bot-scores file does not contain column 'team'. Ignoring.");
                botScoresCSV = null;
            }
            if (!botScoresCSV.keys.contains("botId")) {
                this.warn("-- Bot-scores file does not contain column 'botId'. Ignoring.");
                botScoresCSV = null;
            }
            if (!botScoresCSV.keys.contains("score")) {
                this.warn("-- Bot-scores file does not contain column 'score'. Ignoring.");
                botScoresCSV = null;
            }
        }
        catch (Exception e) {
            this.warn("  -- cannot load CSV? Ignoring.");
            botScoresCSV = null;
        }
        if ((team1 = teamScoresCSV.rows.get(0).getString("teamId")).compareTo(team2 = teamScoresCSV.rows.get(1).getString("teamId")) > 0) {
            String temp = team2;
            team2 = team1;
            team1 = temp;
        }
        this.extractResults(team1, team2, resultFile, resultCSV, teamScoresFile, teamScoresCSV, botScoresFile, botScoresCSV, logFile);
    }

    private void zipLogFile(File logFile) {
        try {
            int length;
            File targetFile = new File(String.valueOf(logFile.getAbsolutePath()) + ".zip");
            FileOutputStream fos = new FileOutputStream(targetFile);
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            FileInputStream fis = new FileInputStream(logFile);
            ZipEntry zipEntry = new ZipEntry(logFile.getName());
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOut.write(bytes, 0, length);
            }
            zipOut.close();
            fis.close();
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to zip log file.", e);
        }
        logFile.delete();
    }

    private void extractResults(String team1, String team2, File resultFile, CSV resultCSV, File teamScoresFile, CSV teamScoresCSV, File botScoresFile, CSV botScoresCSV, File logFileZip) {
        String team;
        CSV.CSVRow row;
        int i;
        int score1 = 0;
        int score2 = 0;
        if (teamScoresCSV != null) {
            i = 0;
            while (i < teamScoresCSV.rows.size()) {
                row = teamScoresCSV.rows.get(i);
                team = row.getString("team");
                int score = row.getInt("score");
                if (team.equals(team1)) {
                    score1 += score;
                }
                if (team.equals(team2)) {
                    score2 += score;
                }
                ++i;
            }
        } else if (botScoresCSV != null) {
            i = 0;
            while (i < botScoresCSV.rows.size()) {
                row = botScoresCSV.rows.get(i);
                team = row.getString("team");
                String botId = row.getString("botId");
                int score = row.getInt("score");
                if (team.equals(team1)) {
                    score1 += score;
                }
                if (team.equals(team2)) {
                    score2 += score;
                }
                ++i;
            }
        } else {
            throw new RuntimeException("No bot-scores and no team-scores CSVs! Cannot determine scores.");
        }
        Pattern team1Pattern = Pattern.compile(String.valueOf(team1) + "-[0-9]+-StdOut");
        Pattern team2Pattern = Pattern.compile(String.valueOf(team2) + "-[0-9]+-StdOut");
        boolean[] teamLogicEx = new boolean[2];
        String[] teamEx = new String[]{"", ""};
        boolean[] fatalErrorEvent = new boolean[2];
        this.info("-- reading zipped log file...");
        BufferedReader reader = null;
        ZipInputStream zippedIS = null;
        try {
            try {
                zippedIS = new ZipInputStream(new FileInputStream(logFileZip));
                ZipEntry zipEntry = zippedIS.getNextEntry();
                reader = new BufferedReader(new InputStreamReader(zippedIS));
                while (reader.ready()) {
                    String line = reader.readLine();
                    String team3 = null;
                    int teamIndex = -1;
                    int otherIndex = -1;
                    if (team1Pattern.matcher(line).find()) {
                        teamIndex = 0;
                        otherIndex = 1;
                        team3 = team1;
                    } else {
                        if (!team2Pattern.matcher(line).find()) continue;
                        teamIndex = 1;
                        otherIndex = 0;
                        team3 = team2;
                    }
                    if (line.endsWith("Logic iteration exception.")) {
                        teamLogicEx[teamIndex] = true;
                    }
                    if (line.endsWith(" FatalErrorEvent[")) {
                        fatalErrorEvent[teamIndex] = true;
                    }
                    if (!fatalErrorEvent[teamIndex]) continue;
                    int n = teamIndex;
                    teamEx[n] = String.valueOf(teamEx[n]) + Const.NEW_LINE + line;
                    if (!line.endsWith(" " + team3 + "-StdOut ]")) continue;
                    fatalErrorEvent[teamIndex] = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error("Failed to probe log file at: " + logFileZip.getAbsolutePath());
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (zippedIS != null) {
                    try {
                        zippedIS.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (zippedIS != null) {
                try {
                    zippedIS.close();
                }
                catch (Exception exception) {}
            }
        }
        TDMOneMatchResult result = this.addResult(team1, team2, score1, score2, teamLogicEx, teamEx);
        this.info("-- " + result.toString());
    }
}

