/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report;

import cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report.DMMatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report.DMTablePlayerResult;
import cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report.DMTableResults;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.format.Orientation;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.WritableWorkbookImpl;

public class ExcelReport {
    private File resultDir;
    private File outputFile;
    private FileOutputStream outputStream;
    private WritableWorkbookImpl work;

    public ExcelReport(File resultDir, File outputFile) {
        this.resultDir = resultDir;
        this.outputFile = outputFile;
    }

    public void info(String msg) {
        System.out.println("[INFO] " + msg);
    }

    public void warn(String msg) {
        System.out.println("[WARN] " + msg);
    }

    public void error(String msg) {
        System.out.println("[ERROR] " + msg);
    }

    public synchronized void generate() {
        DMTableResults results = this.gatherResults(this.resultDir);
        List<DMTablePlayerResult> players = results.resolve();
        this.outputExcel(this.outputFile, players, results);
    }

    private DMTableResults gatherResults(File resultDir) {
        this.info("GATHERING RESULTS");
        DMTableResults results = new DMTableResults();
        results.probeResults(resultDir, true);
        return results;
    }

    private void outputExcel(File outputFile, List<DMTablePlayerResult> players, DMTableResults table) {
        this.info("OUTPUTTING RESULTS");
        for (DMTablePlayerResult player : players) {
            this.info("-- " + player.position + ". " + player.player + " (W" + player.wins + ":D" + player.draws + ":L" + player.loses + ") (F" + player.frags + ":D" + player.deaths + ")");
        }
        ArrayList<DMTablePlayerResult> playersAlpha = new ArrayList<DMTablePlayerResult>(players);
        Collections.sort(playersAlpha, new Comparator<DMTablePlayerResult>(){

            @Override
            public int compare(DMTablePlayerResult o1, DMTablePlayerResult o2) {
                return o1.player.compareTo(o2.player);
            }
        });
        this.info("CREATING EXCEL FILE");
        try {
            this.outputStream = new FileOutputStream(outputFile);
            WorkbookSettings settings = new WorkbookSettings();
            this.work = new WritableWorkbookImpl((OutputStream)this.outputStream, false, settings);
            WritableSheet sheet = this.work.createSheet("TABLE", 0);
            sheet.addCell((WritableCell)this.newStringCell("A", 0, "DeathMatch Tournament"));
            sheet.addCell((WritableCell)this.newStringCell("A", 1, "Table"));
            sheet.addCell((WritableCell)this.newStringCell("A", 2, ""));
            sheet.addCell(this.center((WritableCell)this.newStringCell("A", 3, "No.")));
            sheet.addCell(this.center((WritableCell)this.newStringCell("B", 3, "Participant")));
            sheet.addCell(this.center((WritableCell)this.newStringCell("C", 3, "Frags")));
            sheet.addCell(this.center((WritableCell)this.newStringCell("D", 3, ":")));
            sheet.addCell(this.center((WritableCell)this.newStringCell("E", 3, "Deaths")));
            sheet.addCell(this.center((WritableCell)this.newStringCell("F", 3, "W")));
            sheet.addCell(this.center((WritableCell)this.newStringCell("G", 3, "D")));
            sheet.addCell(this.center((WritableCell)this.newStringCell("H", 3, "L")));
            int col = 0;
            int row = 3;
            for (DMTablePlayerResult player : players) {
                sheet.addCell(this.center((WritableCell)this.newIntCell("A", ++row, player.position)));
                sheet.addCell((WritableCell)this.newStringCell("B", row, player.player));
                sheet.addCell(this.center((WritableCell)this.newIntCell("C", row, player.frags)));
                sheet.addCell(this.center((WritableCell)this.newStringCell("D", row, ":")));
                sheet.addCell(this.center((WritableCell)this.newIntCell("E", row, player.deaths)));
                sheet.addCell(this.center((WritableCell)this.newIntCell("F", row, player.wins)));
                sheet.addCell(this.center((WritableCell)this.newIntCell("G", row, player.draws)));
                sheet.addCell(this.center((WritableCell)this.newIntCell("H", row, player.loses)));
            }
            int startCol = 9;
            int startRow = 3;
            col = startCol + 1;
            row = startRow;
            sheet.addCell((WritableCell)this.newStringCell(col++, row, "TABLE"));
            for (DMTablePlayerResult player : playersAlpha) {
                sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
                sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, player.player))));
                sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
            }
            sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Frags"))));
            sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, ""))));
            sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Deaths"))));
            sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Wins"))));
            sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Draws"))));
            sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Loses"))));
            for (DMTablePlayerResult player1 : playersAlpha) {
                col = startCol + 1;
                sheet.addCell((WritableCell)this.newStringCell(col++, ++row, player1.player));
                for (DMTablePlayerResult player2 : playersAlpha) {
                    if (player1 == player2) {
                        sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
                        sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "X")));
                        sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
                        continue;
                    }
                    DMMatchResult match = table.getMatchResult(player1.player, player2.player);
                    if (match == null) {
                        sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "x")));
                        sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, ":")));
                        sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "x")));
                        continue;
                    }
                    sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, match.getScore(player1.player))));
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, ":")));
                    sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, match.getScore(player2.player))));
                }
                sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.frags)));
                sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, ":")));
                sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.deaths)));
                sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.wins)));
                sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.draws)));
                sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.loses)));
            }
            this.work.write();
            this.work.close();
        }
        catch (Exception e) {
            outputFile.delete();
            throw new RuntimeException("Failed to generate the result.", e);
        }
    }

    private Label newStringCell(String column, int row, String content) {
        int col = this.getColumnNumber(column);
        return this.newStringCell(col, row, content);
    }

    private Label newStringCell(int col, int row, String content) {
        return new Label(col, row, content);
    }

    private Number newIntCell(String column, int row, int num) throws WriteException {
        int col = this.getColumnNumber(column);
        return this.newIntCell(col, row, num);
    }

    private Number newIntCell(int col, int row, int num) throws WriteException {
        WritableCellFormat integerFormat = new WritableCellFormat(NumberFormats.INTEGER);
        integerFormat.setShrinkToFit(true);
        return new Number(col, row, (double)num, (CellFormat)integerFormat);
    }

    private WritableCell textVertical(WritableCell cell) throws WriteException {
        WritableCellFormat format = new WritableCellFormat(cell.getCellFormat());
        format.setOrientation(Orientation.PLUS_90);
        cell.setCellFormat((CellFormat)format);
        return cell;
    }

    private WritableCell center(WritableCell cell) throws WriteException {
        WritableCellFormat format = new WritableCellFormat(cell.getCellFormat());
        format.setAlignment(Alignment.CENTRE);
        cell.setCellFormat((CellFormat)format);
        return cell;
    }

    private int getColumnNumber(String column) {
        if ((column = column.toUpperCase()).length() == 1) {
            char c = column.charAt(0);
            int num = c - 65;
            return num;
        }
        throw new RuntimeException("Invalid column " + column);
    }
}

