/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.ut2004testfw;

import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatch;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatch1v1;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.MatchConfig;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.PerformanceReport;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.measure.IMeasure;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.utils.CsvReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MatchesExecutor {
    private ArrayList<MatchConfig> matchSets;
    private ArrayList<IMeasure> measures;
    private String utPath;
    private String botPath;
    private String botName;
    private String outputDirectory;
    private int testId;

    public MatchesExecutor(ArrayList<MatchConfig> matchSets, ArrayList<IMeasure> measures, String utPath, String botPath, String botName, String outputDirectory) {
        this.botName = botName;
        this.botPath = botPath;
        this.matchSets = matchSets;
        this.measures = measures;
        this.outputDirectory = outputDirectory;
        this.utPath = utPath;
        this.testId = this.generateTestId();
    }

    public UT2004DeathMatch createMatch(MatchConfig config) {
        UT2004DeathMatch1v1 dm = new UT2004DeathMatch1v1(this.utPath, config.getMap(), this.botName, this.botPath, "Oponent", config.getOponentPath());
        dm.setFragLimit(config.getFragLimit());
        dm.setTimeLimitInMinutes(config.getFragLimit());
        return dm.createMatch();
    }

    private void analyzeMatch(int run, UT2004DeathMatch match, MatchConfig config, String outputPath) {
        for (IMeasure measure : this.measures) {
            System.out.println(measure.getName());
            measure.init();
            File[] candidates = match.getOutputPath("bots").listFiles();
            ArrayList<File> reports = new ArrayList<File>();
            for (File can : candidates) {
                if (!can.getName().matches(this.botName + "_[0-9]{3}\\.csv")) continue;
                reports.add(can);
            }
            Collections.sort(reports, new Comparator<File>(){

                @Override
                public int compare(File t, File t1) {
                    return (int)(t1.lastModified() - t.lastModified());
                }
            });
            File report = (File)reports.get(0);
            Logger.getLogger(PerformanceReport.class.getName()).log(Level.INFO, "Reading report " + report.getName());
            try {
                CsvReader.CsvRow row;
                CsvReader reader = new CsvReader(report.getAbsolutePath(), ";");
                while ((row = reader.readRow()) != null) {
                    measure.next(row);
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(PerformanceReport.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(PerformanceReport.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(outputPath, true));
                out.write(this.testId + ";" + measure.getName() + ";" + config.getId() + ";" + run + ";" + measure.getMeasure() + "\n");
                out.close();
            }
            catch (IOException ex) {
                Logger.getLogger(PerformanceReport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void executeMatches() {
        System.out.println("Testing bot: " + this.botName + "(" + this.botPath + ")");
        for (MatchConfig config : this.matchSets) {
            for (int i = 0; i < config.getRuns(); ++i) {
                try {
                    File[] output;
                    UT2004DeathMatch match = this.createMatch(config);
                    match.getLog().setLevel(Level.SEVERE);
                    match.getLog().addConsoleHandler();
                    match.cleanUp();
                    match.run();
                    this.analyzeMatch(i, match, config, this.outputDirectory + File.separator + "results");
                    for (File res : output = match.getOutputPath("bots").listFiles()) {
                        res.delete();
                    }
                    continue;
                }
                catch (Exception e) {
                    --i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateTestId() {
        File idFile = new File(this.outputDirectory + File.separator + "id");
        int id = -1;
        if (!idFile.exists()) {
            id = 1;
        } else {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(idFile));
                id = Integer.parseInt(reader.readLine()) + 1;
            }
            catch (FileNotFoundException ex) {
                id = 1;
                Logger.getLogger(MatchesExecutor.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                id = 1;
                Logger.getLogger(MatchesExecutor.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(idFile, false));
            out.write(id + "\n");
        }
        catch (IOException ex) {
            Logger.getLogger(MatchesExecutor.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        File resultFile = new File(this.outputDirectory + File.separator + "results");
        if (!resultFile.exists()) {
            out = null;
            try {
                out = new BufferedWriter(new FileWriter(resultFile, false));
                out.write("testId;measureName;matchId;runId;measureResult\n");
            }
            catch (IOException ex) {
                Logger.getLogger(MatchesExecutor.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return id;
    }
}

