/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.teamcomm.bot.UT2004TCClient;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client.messages.TCRequestCreateChannel;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client.messages.TCRequestDestroyChannel;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client.messages.TCRequestGetStatus;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client.messages.TCRequestJoinChannel;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client.messages.TCRequestLeaveChannel;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client.messages.TCRequestRegister;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCInfoData;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCInfoMessage;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCMessage;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCRecipient;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCRequestMessage;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.model.TCChannel;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.model.TCTeam;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoBotJoined;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoBotLeft;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoRequestFailed;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoRequestFailedException;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoStatus;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelBotJoined;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelBotLeft;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelCreated;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelDestroyed;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.future.FutureWithListeners;
import cz.cuni.amis.utils.maps.HashMapMap;
import cz.cuni.amis.utils.token.IToken;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class TCMinaClient
implements IoHandler {
    private static final int RETRY_REGISTER_PERIOD_SECS = 3;
    private Object mutex = new Object();
    private UT2004TCClient owner;
    private IWorldView teamWorldView;
    private UnrealId botId;
    private int botTeam;
    private InetSocketAddress address;
    private Logger log;
    private Flag<Boolean> connected = new Flag((Object)false);
    private Flag<Boolean> connecting = new Flag((Object)false);
    private IoFutureListener<ConnectFuture> connectionListener = new IoFutureListener<ConnectFuture>(){

        public void operationComplete(ConnectFuture event) {
            TCMinaClient.this.connected(event);
        }
    };
    private Timer timer;
    private NioSocketConnector ioConnector;
    private ConnectFuture connectFuture;
    private IoSession session;
    private Set<UnrealId> allBots = new HashSet<UnrealId>();
    private TCTeam team;
    private int registerTries = 0;
    private HashMapMap<IToken, Long, RequestFuture<?>> requestFutures = new HashMapMap();

    public TCMinaClient(UT2004TCClient owner, InetSocketAddress connectToAddress, IWorldView teamWorldView, Logger log) {
        this.owner = owner;
        this.teamWorldView = teamWorldView;
        this.botId = owner.getBotId();
        this.botTeam = owner.getBotTeam();
        this.address = connectToAddress;
        NullCheck.check((Object)this.address, (String)"connectToAddress");
        this.log = log;
        NullCheck.check((Object)this.log, (String)"log");
    }

    public String getHost() {
        return this.address.getHostName();
    }

    public int getPort() {
        return this.address.getPort();
    }

    public IWorldView getWorldView() {
        return this.teamWorldView;
    }

    public ImmutableFlag<Boolean> getConnected() {
        return this.connected.getImmutable();
    }

    public ImmutableFlag<Boolean> getConnecting() {
        return this.connecting.getImmutable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.mutex;
        synchronized (object) {
            if (((Boolean)this.connected.getFlag()).booleanValue()) {
                return;
            }
            if (((Boolean)this.connecting.getFlag()).booleanValue()) {
                return;
            }
            this.log.warning("Connecting to TC at " + this.getHost() + ":" + this.getPort() + " ...");
            this.connecting.setFlag((Object)true);
        }
        try {
            this.ioConnector = new NioSocketConnector();
            this.ioConnector.setHandler((IoHandler)this);
            this.ioConnector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
            this.connectFuture = this.ioConnector.connect((SocketAddress)this.address);
            this.connectFuture.addListener(this.connectionListener);
        }
        catch (Exception e1) {
            try {
                this.connecting.setFlag((Object)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isConnected(UnrealId botId) {
        if (botId == null) {
            return false;
        }
        if (!((Boolean)this.getConnected().getFlag()).booleanValue()) {
            return false;
        }
        return this.allBots.contains(botId);
    }

    public boolean isConnected(Player bot) {
        if (bot == null) {
            return false;
        }
        if (!((Boolean)this.getConnected().getFlag()).booleanValue()) {
            return false;
        }
        return this.allBots.contains(bot.getId());
    }

    public boolean isConnectedToMyTeam(UnrealId botId) {
        if (botId == null) {
            return false;
        }
        if (!((Boolean)this.getConnected().getFlag()).booleanValue()) {
            return false;
        }
        return this.team.getConnectedBots().contains(botId);
    }

    public boolean isConnectedToMyTeam(Player bot) {
        if (bot == null) {
            return false;
        }
        if (!((Boolean)this.getConnected().getFlag()).booleanValue()) {
            return false;
        }
        return this.team.getConnectedBots().contains(bot.getId());
    }

    public boolean isConnectedToChannel(UnrealId botId, int channelId) {
        if (botId == null) {
            return false;
        }
        if (!((Boolean)this.getConnected().getFlag()).booleanValue()) {
            return false;
        }
        TCChannel channel = this.team.getChannels().get(channelId);
        if (channel == null) {
            return false;
        }
        return channel.getConnectedBots().contains(botId);
    }

    public boolean isConnectedToChannel(Player bot, int channelId) {
        if (bot == null) {
            return false;
        }
        if (!((Boolean)this.getConnected().getFlag()).booleanValue()) {
            return false;
        }
        TCChannel channel = this.team.getChannels().get(channelId);
        if (channel == null) {
            return false;
        }
        return channel.getConnectedBots().contains(bot.getId());
    }

    public boolean isChannelExist(int channelId) {
        if (!((Boolean)this.getConnected().getFlag()).booleanValue()) {
            return false;
        }
        TCChannel channel = this.team.getChannels().get(channelId);
        return channel != null;
    }

    public Set<UnrealId> getConnectedAllBots() {
        if (!((Boolean)this.getConnected().getFlag()).booleanValue()) {
            return new HashSet<UnrealId>();
        }
        return Collections.unmodifiableSet(this.allBots);
    }

    public Set<UnrealId> getConnectedTeamBots() {
        if (!((Boolean)this.getConnected().getFlag()).booleanValue()) {
            return new HashSet<UnrealId>();
        }
        return Collections.unmodifiableSet(this.team.getConnectedBots());
    }

    public Set<UnrealId> getConnectedChannelBots(int channelId) {
        if (!((Boolean)this.getConnected().getFlag()).booleanValue()) {
            return new HashSet<UnrealId>();
        }
        TCChannel channel = this.team.getChannels().get(channelId);
        if (channel == null) {
            return new HashSet<UnrealId>();
        }
        return Collections.unmodifiableSet(channel.getConnectedBots());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCTeam getTeam() {
        Object object = this.mutex;
        synchronized (object) {
            block6: {
                block5: {
                    if (((Boolean)this.getConnected().getFlag()).booleanValue()) break block5;
                    return null;
                }
                if (this.team != null) break block6;
                return null;
            }
            return this.team.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCChannel getChannel(int channelId) {
        Object object = this.mutex;
        synchronized (object) {
            TCChannel channel;
            block8: {
                block7: {
                    block6: {
                        if (((Boolean)this.getConnected().getFlag()).booleanValue()) break block6;
                        return null;
                    }
                    if (this.team != null) break block7;
                    return null;
                }
                channel = this.team.getChannels().get(channelId);
                if (channel != null) break block8;
                return null;
            }
            return channel.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestFuture<TCInfoTeamChannelCreated> requestCreateChannel() {
        TCRequestCreateChannel data = new TCRequestCreateChannel(this.owner.getSimTime());
        TCRequestMessage message = new TCRequestMessage(this.botId, data);
        RequestFuture<TCInfoTeamChannelCreated> future = new RequestFuture<TCInfoTeamChannelCreated>(message);
        Object object = this.mutex;
        synchronized (object) {
            block4: {
                if (((Boolean)this.getConnected().getFlag()).booleanValue()) break block4;
                return null;
            }
            this.requestFutures.put((Object)data.getMessageType(), (Object)data.getRequestId(), future);
            this.session.write((Object)message);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestFuture<TCInfoTeamChannelDestroyed> requestDestroyChannel(int channelId) {
        TCRequestDestroyChannel data = new TCRequestDestroyChannel(this.owner.getSimTime());
        data.setChannelId(channelId);
        TCRequestMessage message = new TCRequestMessage(this.botId, data);
        RequestFuture<TCInfoTeamChannelDestroyed> future = new RequestFuture<TCInfoTeamChannelDestroyed>(message);
        Object object = this.mutex;
        synchronized (object) {
            block8: {
                TCChannel channel;
                block7: {
                    block6: {
                        if (((Boolean)this.getConnected().getFlag()).booleanValue()) break block6;
                        return null;
                    }
                    channel = this.team.getChannels().get(channelId);
                    if (channel != null) break block7;
                    return null;
                }
                if (channel.getCreator().equals((Object)this.botId)) break block8;
                return null;
            }
            this.requestFutures.put((Object)data.getMessageType(), (Object)data.getRequestId(), future);
            this.session.write((Object)message);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestFuture<TCInfoStatus> requestGetStatus() {
        TCRequestGetStatus data = new TCRequestGetStatus(this.owner.getSimTime());
        TCRequestMessage message = new TCRequestMessage(this.botId, data);
        RequestFuture<TCInfoStatus> future = new RequestFuture<TCInfoStatus>(message);
        Object object = this.mutex;
        synchronized (object) {
            block4: {
                if (((Boolean)this.getConnected().getFlag()).booleanValue()) break block4;
                return null;
            }
            this.requestFutures.put((Object)data.getMessageType(), (Object)data.getRequestId(), future);
            this.session.write((Object)message);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestFuture<TCInfoTeamChannelBotJoined> requestJoinChannel(int channelId) {
        TCRequestJoinChannel data = new TCRequestJoinChannel(this.owner.getSimTime());
        data.setChannelId(channelId);
        TCRequestMessage message = new TCRequestMessage(this.botId, data);
        RequestFuture<TCInfoTeamChannelBotJoined> future = new RequestFuture<TCInfoTeamChannelBotJoined>(message);
        Object object = this.mutex;
        synchronized (object) {
            block6: {
                block5: {
                    if (((Boolean)this.getConnected().getFlag()).booleanValue()) break block5;
                    return null;
                }
                TCChannel channel = this.team.getChannels().get(channelId);
                if (channel != null) break block6;
                return null;
            }
            this.requestFutures.put((Object)data.getMessageType(), (Object)data.getRequestId(), future);
            this.session.write((Object)message);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestFuture<TCInfoTeamChannelBotLeft> requestLeaveChannel(int channelId) {
        TCRequestLeaveChannel data = new TCRequestLeaveChannel(this.owner.getSimTime());
        data.setChannelId(channelId);
        TCRequestMessage message = new TCRequestMessage(this.botId, data);
        RequestFuture<TCInfoTeamChannelBotLeft> future = new RequestFuture<TCInfoTeamChannelBotLeft>(message);
        Object object = this.mutex;
        synchronized (object) {
            block6: {
                block5: {
                    if (((Boolean)this.getConnected().getFlag()).booleanValue()) break block5;
                    return null;
                }
                TCChannel channel = this.team.getChannels().get(channelId);
                if (channel != null) break block6;
                return null;
            }
            this.requestFutures.put((Object)data.getMessageType(), (Object)data.getRequestId(), future);
            this.session.write((Object)message);
        }
        return future;
    }

    public boolean sendToAllOthers(IToken messageType, Serializable data) {
        return this.sendToAll(messageType, data, false);
    }

    public boolean sendToAll(IToken messageType, Serializable data) {
        return this.sendToAll(messageType, data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendToAll(IToken messageType, Serializable data, boolean includeMe) {
        if (messageType == null) {
            return false;
        }
        TCMessage message = new TCMessage(this.botId, TCRecipient.GLOBAL, !includeMe, messageType, data, this.owner.getSimTime());
        Object object = this.mutex;
        synchronized (object) {
            block8: {
                if (((Boolean)this.connected.getFlag()).booleanValue() && this.session != null) break block8;
                return false;
            }
            try {
                this.session.write((Object)message);
            }
            catch (Exception e) {
                this.log.warning(ExceptionToString.process((String)("Failed to sendToAll: " + data), (Throwable)e));
                return false;
            }
            return true;
        }
    }

    public boolean sendToTeamOthers(IToken messageType, Serializable data) {
        return this.sendToTeam(messageType, data, false);
    }

    public boolean sendToTeam(IToken messageType, Serializable data) {
        return this.sendToTeam(messageType, data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendToTeam(IToken messageType, Serializable data, boolean includeMe) {
        if (messageType == null) {
            return false;
        }
        TCMessage message = new TCMessage(this.botId, TCRecipient.TEAM, !includeMe, messageType, data, this.owner.getSimTime());
        Object object = this.mutex;
        synchronized (object) {
            block8: {
                if (((Boolean)this.connected.getFlag()).booleanValue() && this.session != null) break block8;
                return false;
            }
            try {
                this.session.write((Object)message);
            }
            catch (Exception e) {
                this.log.warning(ExceptionToString.process((String)("Failed to sendToTeam: " + data), (Throwable)e));
                return false;
            }
            return true;
        }
    }

    public boolean sendToChannelOthers(int channelId, IToken messageType, Serializable data) {
        return this.sendToChannel(channelId, messageType, data, false);
    }

    public boolean sendToChannel(int channelId, IToken messageType, Serializable data) {
        return this.sendToChannel(channelId, messageType, data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendToChannel(int channelId, IToken messageType, Serializable data, boolean includeMe) {
        if (messageType == null) {
            return false;
        }
        TCMessage message = new TCMessage(this.botId, TCRecipient.CHANNEL, includeMe, messageType, data, this.owner.getSimTime());
        message.setChannelId(channelId);
        Object object = this.mutex;
        synchronized (object) {
            block8: {
                if (((Boolean)this.connected.getFlag()).booleanValue() && this.session != null) break block8;
                return false;
            }
            try {
                this.session.write((Object)message);
            }
            catch (Exception e) {
                this.log.warning(ExceptionToString.process((String)("Failed to sendToChannel(" + channelId + "): " + data), (Throwable)e));
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendPrivate(UnrealId targetBotId, IToken messageType, Serializable data) {
        if (messageType == null) {
            return false;
        }
        TCMessage message = new TCMessage(this.botId, TCRecipient.PRIVATE, false, messageType, data, this.owner.getSimTime());
        message.setTargetId(targetBotId);
        Object object = this.mutex;
        synchronized (object) {
            block8: {
                if (((Boolean)this.connected.getFlag()).booleanValue() && this.session != null) break block8;
                return false;
            }
            try {
                this.session.write((Object)message);
            }
            catch (Exception e) {
                this.log.warning(ExceptionToString.process((String)("Failed to sendPrivate(" + targetBotId.getStringId() + "): " + data), (Throwable)e));
                return false;
            }
            return true;
        }
    }

    protected void connected(ConnectFuture event) {
        this.log.info("Connected to TC at " + this.getHost() + ":" + this.getPort());
        this.session = event.getSession();
        this.connectFuture.removeListener(this.connectionListener);
        this.connectFuture = null;
        this.log.info("Sending REGISTER request, expecting TCInfoStatus reply...");
        this.registerTries = 1;
        this.sendRegisterRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRegisterRequest() {
        TCRequestRegister request = new TCRequestRegister(this.owner.getSimTime());
        TCRequestMessage message = new TCRequestMessage(this.botId, request);
        Object object = this.mutex;
        synchronized (object) {
            this.session.write((Object)message);
        }
    }

    public void exceptionCaught(IoSession session, Throwable exception) throws Exception {
        this.log.warning(ExceptionToString.process((String)"TCMinaClient Exception", (Throwable)exception));
        this.stop();
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (message == null) {
            this.log.warning("Invalid message: " + String.valueOf(message));
            return;
        }
        if (!(message instanceof TCMessage)) {
            this.log.warning("Invalid message: " + String.valueOf(message));
            return;
        }
        TCMessage tcMessage = (TCMessage)message;
        if (tcMessage.getSource() == null) {
            this.log.warning("TCMessage.getSource() is NULL, cannot process: " + String.valueOf(message));
            return;
        }
        if (tcMessage.getMessageType() == null) {
            this.log.warning("TCMessage.getMessageType() is NULL, cannot process: " + String.valueOf(message));
            return;
        }
        if (tcMessage.getTarget() == null) {
            this.log.warning("TCMessage.getTarget() is NULL, cannot process the message: " + String.valueOf(message));
            return;
        }
        switch (tcMessage.getTarget()) {
            case GLOBAL: 
            case TEAM: 
            case CHANNEL: 
            case PRIVATE: {
                Serializable data;
                try {
                    data = tcMessage.getMessage();
                }
                catch (Exception e) {
                    this.log.warning(ExceptionToString.process((String)("Invalid request data, failed to deserialize TCMessage.getMessage(): " + String.valueOf(tcMessage)), (Throwable)e));
                    return;
                }
                this.botMessage(tcMessage, data);
                return;
            }
            case TC_INFO: {
                if (!(tcMessage instanceof TCInfoMessage)) {
                    this.log.warning("TCMessage recipient is " + (Object)((Object)tcMessage.getTarget()) + ", but the message is not TCInfoMessage: " + String.valueOf(tcMessage));
                    return;
                }
                TCInfoData infoData = null;
                try {
                    infoData = (TCInfoData)tcMessage.getMessage();
                }
                catch (Exception e) {
                    this.log.warning("Invalid request data, failed to deserialize TCMessage.getMessage() as TCInfoMessageData: " + String.valueOf(tcMessage));
                    return;
                }
                this.infoMessage((TCInfoMessage)tcMessage, infoData);
                return;
            }
            case TC_REQUEST: {
                this.log.warning("Received TC_REQUEST message, cannot process: " + String.valueOf(message));
                return;
            }
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoSession session) throws Exception {
        Object object = this.mutex;
        synchronized (object) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            session = null;
            this.log.warning("TC Server connection closed.");
            this.connected.setFlag((Object)false);
            this.connecting.setFlag((Object)false);
        }
    }

    public void sessionCreated(IoSession session) throws Exception {
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
    }

    private void botMessage(TCMessage message, Serializable data) {
        this.notify(message, data);
    }

    private void infoMessage(TCInfoMessage message, TCInfoData data) {
        if (data.getMessageType() == TCInfoStatus.MESSAGE_TYPE) {
            this.status(message, (TCInfoStatus)data);
        } else if (data.getMessageType() == TCInfoBotJoined.MESSAGE_TYPE) {
            this.botJoined(message, (TCInfoBotJoined)data);
        } else if (data.getMessageType() == TCInfoBotLeft.MESSAGE_TYPE) {
            this.botLeft(message, (TCInfoBotLeft)data);
        } else if (data.getMessageType() == TCInfoRequestFailed.MESSAGE_TYPE) {
            this.requestFailed(message, (TCInfoRequestFailed)data);
        } else if (data.getMessageType() == TCInfoRequestFailed.MESSAGE_TYPE) {
            this.status(message, (TCInfoStatus)data);
        } else if (data.getMessageType() == TCInfoTeamChannelBotJoined.MESSAGE_TYPE) {
            this.channelBotJoined(message, (TCInfoTeamChannelBotJoined)data);
        } else if (data.getMessageType() == TCInfoTeamChannelBotLeft.MESSAGE_TYPE) {
            this.channelBotLeft(message, (TCInfoTeamChannelBotLeft)data);
        } else if (data.getMessageType() == TCInfoTeamChannelCreated.MESSAGE_TYPE) {
            this.channelCreated(message, (TCInfoTeamChannelCreated)data);
        } else if (data.getMessageType() == TCInfoTeamChannelDestroyed.MESSAGE_TYPE) {
            this.channelDestroyed(message, (TCInfoTeamChannelDestroyed)data);
        } else {
            this.log.warning("Unhandled INFO message type: " + data.getMessageType().getToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void botJoined(TCInfoMessage message, TCInfoBotJoined data) {
        if (data.getBotId() == null) {
            this.log.warning("TCInfoBotJoined.getBotId() is NULL!");
            return;
        }
        this.log.info("Bot " + data.getBotId().getStringId() + " has joined TC.");
        Object object = this.mutex;
        synchronized (object) {
            this.allBots.add(data.getBotId());
            if (this.team == null) {
                return;
            }
            if (data.getTeam() != this.team.getTeam()) {
                return;
            }
            this.team.getConnectedBots().add(data.getBotId());
        }
        this.notify(message, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void botLeft(TCInfoMessage message, TCInfoBotLeft data) {
        if (data.getBotId() == null) {
            this.log.warning("TCInfoBotLeft.getBotId() is NULL!");
            return;
        }
        this.log.warning("Bot " + data.getBotId().getStringId() + " has left TC.");
        Object object = this.mutex;
        synchronized (object) {
            this.allBots.add(data.getBotId());
            if (this.team == null) {
                return;
            }
            if (data.getTeam() != this.team.getTeam()) {
                return;
            }
            this.team.getConnectedBots().remove(data.getBotId());
            for (TCChannel channel : this.team.getChannels().values()) {
                channel.getConnectedBots().remove(data.getBotId());
            }
        }
        this.notify(message, data);
    }

    private void requestFailed(TCInfoMessage message, TCInfoRequestFailed data) {
        if (((Boolean)this.connecting.getFlag()).booleanValue()) {
            this.log.warning("Failed to register, will retry in 3 seconds...");
            if (this.timer == null) {
                this.timer = new Timer();
            }
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    TCMinaClient tCMinaClient = TCMinaClient.this;
                    tCMinaClient.registerTries = tCMinaClient.registerTries + 1;
                    TCMinaClient.this.log.warning("Trying to register again (" + TCMinaClient.this.registerTries + ")...");
                    TCMinaClient.this.sendRegisterRequest();
                }
            }, 3000L);
            return;
        }
        this.failRequestFuture(null, data);
        this.notify(message, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void status(TCInfoMessage message, TCInfoStatus data) {
        this.log.info("Received TCInfoStatus message...");
        Object object = this.mutex;
        synchronized (object) {
            this.allBots = new HashSet<UnrealId>(data.getAllBots());
            this.team = data.getTeam();
            if (((Boolean)this.connecting.getFlag()).booleanValue()) {
                this.log.info("Connected to TC Server at " + this.address.getHostName() + ":" + this.address.getPort());
                this.timer = null;
                this.connected.setFlag((Object)true);
                this.connecting.setFlag((Object)false);
            } else {
                this.requestFinishedUnsync(TCRequestGetStatus.MESSAGE_TYPE, data.getRequestId(), data);
            }
        }
        this.notify(message, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelBotJoined(TCInfoMessage message, TCInfoTeamChannelBotJoined data) {
        if (data.getBotId() == null) {
            this.log.warning("TCInfoTeamChannelBotJoined.getBotId() is NULL!");
        }
        Object object = this.mutex;
        synchronized (object) {
            TCChannel channel = this.team.getChannels().get(data.getChannelId());
            if (channel == null) {
                this.log.warning("Bot " + data.getBotId().getStringId() + " has joined unknown channel " + data.getChannelId() + "! Requesting STATUS...");
                this.requestGetStatus();
                return;
            }
            channel.getConnectedBots().add(data.getBotId());
            this.requestFinishedUnsync(TCRequestJoinChannel.MESSAGE_TYPE, data.getRequestId(), data);
        }
        this.notify(message, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelBotLeft(TCInfoMessage message, TCInfoTeamChannelBotLeft data) {
        if (data.getBotId() == null) {
            this.log.warning("TCInfoTeamChannelBotLeft.getBotId() is NULL!");
        }
        Object object = this.mutex;
        synchronized (object) {
            TCChannel channel = this.team.getChannels().get(data.getChannelId());
            if (channel == null) {
                this.log.warning("Bot " + data.getBotId().getStringId() + " has left unknown channel " + data.getChannelId() + "! Requesting STATUS...");
                this.requestGetStatus();
                return;
            }
            channel.getConnectedBots().remove(data.getBotId());
            this.requestFinishedUnsync(TCRequestLeaveChannel.MESSAGE_TYPE, data.getRequestId(), data);
        }
        this.notify(message, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelCreated(TCInfoMessage message, TCInfoTeamChannelCreated data) {
        if (this.team == null) {
            return;
        }
        if (data.getChannel() == null) {
            this.log.warning("TCInfoTeamChannelCreated.getChannel() is NULL!");
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.team.getChannels().put(data.getChannel().getChannelId(), data.getChannel().clone());
            this.requestFinishedUnsync(TCRequestCreateChannel.MESSAGE_TYPE, data.getRequestId(), data);
        }
        this.notify(message, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelDestroyed(TCInfoMessage message, TCInfoTeamChannelDestroyed data) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.team == null) {
                return;
            }
            this.team.getChannels().remove(data.getChannelId());
            this.requestFinishedUnsync(TCRequestDestroyChannel.MESSAGE_TYPE, data.getRequestId(), data);
        }
        this.notify(message, data);
    }

    private void requestFinishedUnsync(IToken requestMessageType, long requestId, Object result) {
        Map futures = this.requestFutures.get((Object)requestMessageType);
        if (futures == null) {
            return;
        }
        RequestFuture requestFuture = (RequestFuture)((Object)futures.remove(requestId));
        if (requestFuture == null) {
            return;
        }
        requestFuture.setResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failRequestFuture(IToken requestMessageType, TCInfoRequestFailed data) {
        Object object = this.mutex;
        synchronized (object) {
            if (requestMessageType == null) {
                for (IToken messageType : this.requestFutures.keySet()) {
                    Map futures = this.requestFutures.get((Object)messageType);
                    RequestFuture requestFuture = (RequestFuture)((Object)futures.remove(data.getRequestId()));
                    if (requestFuture == null) continue;
                    requestFuture.computationException((Exception)((Object)new TCInfoRequestFailedException(requestFuture.message, data, this.log, this)));
                }
            } else {
                Map futures = this.requestFutures.get((Object)requestMessageType);
                if (futures == null) {
                    return;
                }
                RequestFuture requestFuture = (RequestFuture)((Object)futures.remove(data.getRequestId()));
                if (requestFuture == null) {
                    return;
                }
                requestFuture.computationException((Exception)((Object)new TCInfoRequestFailedException(requestFuture.message, data, this.log, this)));
            }
        }
    }

    private void notify(TCMessage message, Serializable data) {
        if (data instanceof IWorldChangeEvent && data instanceof IWorldEvent) {
            this.teamWorldView.notify((IWorldChangeEvent)data);
        }
        if (message instanceof IWorldChangeEvent && message instanceof IWorldEvent) {
            this.teamWorldView.notify((IWorldChangeEvent)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mutex;
        synchronized (object) {
            this.log.info("Stopping TCMinaClient!");
            this.allBots.clear();
            this.team = null;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            try {
                if (this.session != null) {
                    this.session.close(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.session = null;
            try {
                this.connected.setFlag((Object)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.connecting.setFlag((Object)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (IToken messageType : this.requestFutures.keySet()) {
                Map futures = this.requestFutures.get((Object)messageType);
                for (RequestFuture future : futures.values()) {
                    future.cancel(true);
                }
            }
            this.requestFutures.clear();
            this.log.info("TCMinaClient stopped!");
        }
    }

    public static class RequestFuture<T>
    extends FutureWithListeners<T> {
        private TCRequestMessage message;

        public RequestFuture(TCRequestMessage message) {
            this.message = message;
        }
    }
}

