/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerMessage;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client.messages.TCRequestCreateChannel;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client.messages.TCRequestDestroyChannel;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client.messages.TCRequestGetStatus;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client.messages.TCRequestJoinChannel;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client.messages.TCRequestLeaveChannel;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client.messages.TCRequestRegister;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCInfoData;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCInfoMessage;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCMessage;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCRecipient;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCRequestData;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCRequestMessage;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.model.TCChannel;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.model.TCTeam;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoBotJoined;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoBotLeft;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoRequestFailed;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoRequestFailureType;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoStatus;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelBotJoined;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelBotLeft;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelCreated;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelDestroyed;
import cz.cuni.amis.pogamut.ut2004.teamcomm.server.UT2004TCServer;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.maps.LazyMap;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class TCMinaServer
implements IoHandler {
    private UT2004TCServer owner;
    private InetSocketAddress address;
    private Logger log;
    private Object mutex = new Object();
    private Flag<Boolean> running = new Flag((Object)false);
    private IoAcceptor ioAcceptor;
    private Map<Integer, TCTeam> teams = new LazyMap<Integer, TCTeam>(){

        protected TCTeam create(Integer key) {
            return new TCTeam(key);
        }
    };
    private Map<UnrealId, PlayerMessage> registeredBots = new HashMap<UnrealId, PlayerMessage>();
    private Map<UnrealId, IoSession> botSessions = new HashMap<UnrealId, IoSession>();

    public TCMinaServer(UT2004TCServer owner, InetSocketAddress bindAddress, Logger log) {
        this.owner = owner;
        this.address = bindAddress;
        NullCheck.check((Object)this.address, (String)"bindAddress");
        this.log = log;
        NullCheck.check((Object)this.log, (String)"log");
    }

    public void botLeft(UnrealId botId) {
        if (this.registeredBots.containsKey(botId)) {
            this.unregisterBot(botId);
        }
    }

    public ImmutableFlag<Boolean> getRunning() {
        return this.running.getImmutable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws PogamutException {
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.log.warning("Starting TCMinaServer!");
                this.log.warning("Opening TC Socket: " + this.address.getHostName() + ":" + this.address.getPort());
                this.ioAcceptor = new NioSocketAcceptor();
                this.ioAcceptor.setHandler((IoHandler)this);
                this.ioAcceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
                try {
                    this.ioAcceptor.bind((SocketAddress)this.address);
                }
                catch (IOException e) {
                    this.stop();
                    throw new PogamutException("Failed to open server socket for TCMinaServer at " + this.address, (Throwable)e, (Object)this.log);
                }
                this.log.warning("TCMinaServer running!");
                this.running.setFlag((Object)true);
            }
        }
        catch (Exception e) {
            this.log.severe(ExceptionToString.process((String)"Failed to start TCMinaServer!", (Throwable)e));
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mutex;
        synchronized (object) {
            this.log.warning("Stopping TCMinaServer!");
            if (this.ioAcceptor != null) {
                this.log.warning("Closing TCMinaServer Socket!");
                try {
                    this.ioAcceptor.unbind();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.ioAcceptor.dispose();
                }
                catch (Exception e) {
                    this.ioAcceptor = null;
                }
            }
            this.botSessions.clear();
            this.registeredBots.clear();
            this.teams.clear();
            try {
                this.running.setFlag((Object)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.warning("TCMinaServer stopped!");
        }
    }

    public void exceptionCaught(IoSession session, Throwable exception) throws Exception {
        this.sessionError(session, ExceptionToString.process((String)"TCMinaServer uncaught exception!", (Throwable)exception));
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (message == null) {
            this.sessionError(session, "NULL message received.");
            return;
        }
        if (!(message instanceof TCMessage)) {
            this.sessionError(session, "Received message that was not TCMessage.");
            return;
        }
        TCMessage tcMessage = (TCMessage)message;
        UnrealId source = tcMessage.getSource();
        if (source == null) {
            this.sessionError(session, "TCMessage.getSource() is NULL.");
            return;
        }
        if (!this.ensureSession(source, session)) {
            this.sessionError(session, "Failed to bind the session with the source.");
            return;
        }
        if (tcMessage.getMessageType() == null) {
            this.invalidRequest(session, TCInfoRequestFailureType.INVALID_MESSAGE_TYPE, "TCMessage.getMessageType() is NULL, cannot process: " + String.valueOf(message), -1L, source);
            return;
        }
        if (tcMessage.getTarget() == null) {
            this.invalidRequest(session, TCInfoRequestFailureType.INVALID_RECIPIENT, "TCMessage.getTarget() is is NULL, cannot process the message: " + String.valueOf(message), -1L, source);
            return;
        }
        PlayerMessage player = this.owner.getPlayer(source);
        if (this.registeredBots.containsKey(source)) {
            if (player == null) {
                this.log.warning(source.getStringId() + ": Cannot process the message as the bot has already left the UT2004 server!");
                this.unregisterBot(source);
                return;
            }
        } else {
            if (player == null) {
                this.invalidRequest(session, TCInfoRequestFailureType.UNKNOWN_BOT_UNREALID, "TCServer does not have info that this bot is connected to UT2004. If you are, please try again later (in about 5 secs).", -1L, source);
                return;
            }
            if (tcMessage.getTarget() == TCRecipient.TC_REQUEST && tcMessage.getMessageType() == TCRequestRegister.MESSAGE_TYPE && tcMessage instanceof TCRequestMessage) {
                TCRequestRegister data;
                try {
                    data = (TCRequestRegister)tcMessage.getMessage();
                }
                catch (Exception e) {
                    this.invalidRequest(session, TCInfoRequestFailureType.FAILED_TO_DESERIALIZE_REQUEST_DATA, "Invalid request data, failed to deserialize TCMessage.getMessage() as TCRequestData.", -1L, source);
                    return;
                }
                if (!this.registerBot(session, source, player, (TCRequestMessage)tcMessage, data)) {
                    this.invalidRequest(session, TCInfoRequestFailureType.FAILED_TO_REGISTER_THE_BOT, "TCServer could not register the bot bot with UnrealId '" + source.getStringId() + "'.", -1L, source);
                    return;
                }
                return;
            }
        }
        switch (tcMessage.getTarget()) {
            case CHANNEL: {
                this.channelMessage(tcMessage, session, source, player);
                return;
            }
            case GLOBAL: {
                this.globalMessage(tcMessage, session, source, player);
                return;
            }
            case PRIVATE: {
                this.privateMessage(tcMessage, session, source, player);
                return;
            }
            case TEAM: {
                this.teamMessage(tcMessage, session, source, player);
                return;
            }
            case TC_INFO: {
                this.invalidRequest(session, TCInfoRequestFailureType.INVALID_RECIPIENT, "TCServer does not process TC_INFO messages, they are not meant to be sent to TCServer EVER!", -1L, source);
                return;
            }
            case TC_REQUEST: {
                TCRequestData requestData = null;
                try {
                    if (!(tcMessage instanceof TCRequestMessage)) {
                        this.invalidRequest(session, TCInfoRequestFailureType.FAILED_TO_DESERIALIZE_REQUEST_DATA, "TCMessage recipient is TC_REQUEST, but the message is not TCRequestMessage.", -1L, source);
                        return;
                    }
                    requestData = (TCRequestData)tcMessage.getMessage();
                }
                catch (Exception e) {
                    this.invalidRequest(session, TCInfoRequestFailureType.FAILED_TO_DESERIALIZE_REQUEST_DATA, "Invalid request data, failed to deserialize TCMessage.getMessage() as TCRequestData.", -1L, source);
                    return;
                }
                this.requestMessage((TCRequestMessage)tcMessage, requestData, session, source, player);
                return;
            }
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
    }

    public void sessionClosed(IoSession session) throws Exception {
    }

    public void sessionCreated(IoSession session) throws Exception {
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
    }

    private void globalMessage(TCMessage message, IoSession session, UnrealId source, PlayerMessage player) {
        this.sendGlobalExcept(message, source);
    }

    private void teamMessage(TCMessage message, IoSession session, UnrealId source, PlayerMessage player) {
        this.sendTeamExcept(message, player.getTeam(), source);
    }

    private void channelMessage(TCMessage message, IoSession session, UnrealId source, PlayerMessage player) {
        this.sendChannelExcept(message, player.getTeam(), message.getChannelId(), source);
    }

    private void privateMessage(TCMessage message, IoSession session, UnrealId source, PlayerMessage player) {
        this.sendPrivate(message, message.getTargetId());
    }

    private void requestMessage(TCRequestMessage message, TCRequestData data, IoSession session, UnrealId source, PlayerMessage player) {
        if (data == null) {
            this.invalidRequest(session, TCInfoRequestFailureType.FAILED_TO_DESERIALIZE_REQUEST_DATA, "Request data are NULL", -1L, source);
            return;
        }
        if (data instanceof TCRequestCreateChannel) {
            this.requestCreateChannel(message, (TCRequestCreateChannel)data, session, source, player);
        } else if (data instanceof TCRequestDestroyChannel) {
            this.requestDestroyChannel(message, (TCRequestDestroyChannel)data, session, source, player);
        } else if (data instanceof TCRequestGetStatus) {
            this.requestGetStatus(message, (TCRequestGetStatus)data, session, source, player);
        } else if (data instanceof TCRequestJoinChannel) {
            this.requestJoinChannel(message, (TCRequestJoinChannel)data, session, source, player);
        } else if (data instanceof TCRequestLeaveChannel) {
            this.requestLeaveChannel(message, (TCRequestLeaveChannel)data, session, source, player);
        } else {
            if (data instanceof TCRequestRegister) {
                throw new RuntimeException("Should not reach here!");
            }
            this.invalidRequest(session, TCInfoRequestFailureType.FAILED_TO_PROCESS_REQUEST, "Unknown request.", data.getRequestId(), source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestCreateChannel(TCRequestMessage message, TCRequestCreateChannel data, IoSession session, UnrealId source, PlayerMessage player) {
        Object object = this.mutex;
        synchronized (object) {
            TCTeam team;
            if (!((Boolean)this.running.getFlag()).booleanValue()) {
                return;
            }
            TCTeam tCTeam = team = this.teams.get(player.getTeam());
            synchronized (tCTeam) {
                Map<Integer, TCChannel> channels;
                Map<Integer, TCChannel> map = channels = team.getChannels();
                synchronized (map) {
                    int newChannelId = team.getNextChannelId();
                    TCChannel newChannel = new TCChannel();
                    newChannel.setChannelId(newChannelId);
                    newChannel.setCreator(source);
                    newChannel.getConnectedBots().add(source);
                    channels.put(newChannelId, newChannel);
                    TCInfoTeamChannelCreated infoDataTeam = new TCInfoTeamChannelCreated(-1L, this.owner.getSimTime());
                    infoDataTeam.setChannel(newChannel.clone());
                    TCInfoMessage infoMessageTeam = new TCInfoMessage(infoDataTeam);
                    this.sendTeamExcept(infoMessageTeam, player.getTeam(), source);
                    TCInfoTeamChannelCreated infoDataRequestee = new TCInfoTeamChannelCreated(data.getRequestId(), this.owner.getSimTime());
                    infoDataRequestee.setChannel(newChannel.clone());
                    TCInfoMessage infoMessageRequestee = new TCInfoMessage(infoDataRequestee);
                    this.sendPrivate(infoMessageRequestee, source);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestDestroyChannel(TCRequestMessage message, TCRequestDestroyChannel data, IoSession session, UnrealId source, PlayerMessage player) {
        Object object = this.mutex;
        synchronized (object) {
            TCTeam team;
            if (!((Boolean)this.running.getFlag()).booleanValue()) {
                return;
            }
            TCTeam tCTeam = team = this.teams.get(player.getTeam());
            synchronized (tCTeam) {
                Map<Integer, TCChannel> channels;
                Map<Integer, TCChannel> map = channels = team.getChannels();
                synchronized (map) {
                    TCChannel channel = channels.get(data.getChannelId());
                    if (channel == null) {
                        this.invalidRequest(session, TCInfoRequestFailureType.CHANNEL_DOES_NOT_EXIST, "Cannot destroy team " + player.getTeam() + " channel " + data.getChannelId() + " as it does not exist.", data.getRequestId(), source);
                        return;
                    }
                    if (channel.getCreator() != source) {
                        this.invalidRequest(session, TCInfoRequestFailureType.CHANNEL_NOT_OWNED_BY_YOU, "Cannot destroy team " + player.getTeam() + " channel " + data.getChannelId() + " as it is not OWNED by you!", data.getRequestId(), source);
                        return;
                    }
                    channels.remove(data.getChannelId());
                    TCInfoTeamChannelDestroyed infoDataTeam = new TCInfoTeamChannelDestroyed(-1L, this.owner.getSimTime());
                    infoDataTeam.setChannelId(data.getChannelId());
                    infoDataTeam.setDestroyer(source);
                    TCInfoMessage infoMessageTeam = new TCInfoMessage(infoDataTeam);
                    this.sendTeamExcept(infoMessageTeam, player.getTeam(), source);
                    TCInfoTeamChannelDestroyed infoDataRequestee = new TCInfoTeamChannelDestroyed(data.getRequestId(), this.owner.getSimTime());
                    infoDataRequestee.setChannelId(data.getChannelId());
                    infoDataRequestee.setDestroyer(source);
                    TCInfoMessage infoMessageRequestee = new TCInfoMessage(infoDataRequestee);
                    this.sendPrivate(infoMessageRequestee, source);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestGetStatus(TCRequestMessage message, TCRequestGetStatus data, IoSession session, UnrealId source, PlayerMessage player) {
        TCTeam team;
        TCInfoStatus infoData = new TCInfoStatus(data.getRequestId(), this.owner.getSimTime());
        Map<UnrealId, PlayerMessage> map = this.registeredBots;
        synchronized (map) {
            infoData.setAllBots(new ArrayList<UnrealId>(this.registeredBots.keySet()));
        }
        TCTeam tCTeam = team = this.teams.get(player.getTeam());
        synchronized (tCTeam) {
            infoData.setTeam(team.clone());
        }
        TCInfoMessage infoMessage = new TCInfoMessage(infoData);
        this.sendPrivate(infoMessage, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestJoinChannel(TCRequestMessage message, TCRequestJoinChannel data, IoSession session, UnrealId source, PlayerMessage player) {
        Object object = this.mutex;
        synchronized (object) {
            if (!((Boolean)this.running.getFlag()).booleanValue()) {
                return;
            }
            TCTeam team = this.teams.get(player.getTeam());
            TCChannel channel = team.getChannels().get(data.getChannelId());
            if (channel == null) {
                this.invalidRequest(session, TCInfoRequestFailureType.CHANNEL_DOES_NOT_EXIST, "You cannot join team " + player.getTeam() + " channel " + data.getChannelId() + " as it does not exist.", data.getRequestId(), source);
                return;
            }
            if (channel.getConnectedBots().contains(source)) {
                this.invalidRequest(session, TCInfoRequestFailureType.CHANNEL_DOES_NOT_EXIST, "You are already coonnected to team " + player.getTeam() + " channel " + data.getChannelId() + ".", data.getRequestId(), source);
                return;
            }
            TCChannel tCChannel = channel;
            synchronized (tCChannel) {
                channel.getConnectedBots().add(source);
                TCInfoTeamChannelBotJoined infoDataTeam = new TCInfoTeamChannelBotJoined(-1L, this.owner.getSimTime());
                infoDataTeam.setChannelId(data.getChannelId());
                infoDataTeam.setBotId(source);
                TCInfoMessage infoMessageTeam = new TCInfoMessage(infoDataTeam);
                this.sendTeamExcept(infoMessageTeam, player.getTeam(), source);
                TCInfoTeamChannelBotJoined infoDataRequestee = new TCInfoTeamChannelBotJoined(data.getRequestId(), this.owner.getSimTime());
                infoDataRequestee.setChannelId(data.getChannelId());
                infoDataRequestee.setBotId(source);
                TCInfoMessage infoMessageRequestee = new TCInfoMessage(infoDataRequestee);
                this.sendPrivate(infoMessageRequestee, source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestLeaveChannel(TCRequestMessage message, TCRequestLeaveChannel data, IoSession session, UnrealId source, PlayerMessage player) {
        Object object = this.mutex;
        synchronized (object) {
            if (!((Boolean)this.running.getFlag()).booleanValue()) {
                return;
            }
            TCTeam team = this.teams.get(player.getTeam());
            TCChannel channel = team.getChannels().get(data.getChannelId());
            if (channel == null) {
                this.invalidRequest(session, TCInfoRequestFailureType.CHANNEL_DOES_NOT_EXIST, "You cannot leave team " + player.getTeam() + " channel " + data.getChannelId() + " as it does not exist.", data.getRequestId(), source);
                return;
            }
            if (!channel.getConnectedBots().contains(source)) {
                this.invalidRequest(session, TCInfoRequestFailureType.NOT_CONNECTED_TO_CHANNEL, "You are not coonnected to team " + player.getTeam() + " channel " + data.getChannelId() + ".", data.getRequestId(), source);
                return;
            }
            TCChannel tCChannel = channel;
            synchronized (tCChannel) {
                channel.getConnectedBots().remove(source);
                TCInfoTeamChannelBotLeft infoDataTeam = new TCInfoTeamChannelBotLeft(-1L, this.owner.getSimTime());
                infoDataTeam.setChannelId(data.getChannelId());
                infoDataTeam.setBotId(source);
                TCInfoMessage infoMessageTeam = new TCInfoMessage(infoDataTeam);
                this.sendTeamExcept(infoMessageTeam, player.getTeam(), source);
                TCInfoTeamChannelBotLeft infoDataRequestee = new TCInfoTeamChannelBotLeft(data.getRequestId(), this.owner.getSimTime());
                infoDataRequestee.setChannelId(data.getChannelId());
                infoDataRequestee.setBotId(source);
                TCInfoMessage infoMessageRequestee = new TCInfoMessage(infoDataRequestee);
                this.sendPrivate(infoMessageRequestee, source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendGlobalExcept(TCMessage message, UnrealId except) {
        Map<UnrealId, IoSession> map = this.botSessions;
        synchronized (map) {
            for (Map.Entry<UnrealId, IoSession> botSessionEntry : this.botSessions.entrySet()) {
                if (botSessionEntry.getKey() == except) continue;
                IoSession ioSession = botSessionEntry.getValue();
                synchronized (ioSession) {
                    botSessionEntry.getValue().write((Object)message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTeamExcept(TCMessage message, int teamNum, UnrealId except) {
        TCTeam team = this.teams.get(teamNum);
        if (team == null) {
            return;
        }
        TCTeam tCTeam = team;
        synchronized (tCTeam) {
            Set<UnrealId> set = team.getConnectedBots();
            synchronized (set) {
                for (UnrealId target : team.getConnectedBots()) {
                    IoSession targetSession;
                    if (target == except) continue;
                    IoSession ioSession = targetSession = this.botSessions.get(target);
                    synchronized (ioSession) {
                        targetSession.write((Object)message);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChannelExcept(TCMessage message, int teamNum, int channelId, UnrealId except) {
        TCTeam team = this.teams.get(teamNum);
        if (team == null) {
            return;
        }
        TCChannel channel = team.getChannels().get(channelId);
        if (channel == null) {
            return;
        }
        TCChannel tCChannel = channel;
        synchronized (tCChannel) {
            Set<UnrealId> set = channel.getConnectedBots();
            synchronized (set) {
                for (UnrealId target : channel.getConnectedBots()) {
                    IoSession targetSession;
                    if (target == except) continue;
                    IoSession ioSession = targetSession = this.botSessions.get(target);
                    synchronized (ioSession) {
                        targetSession.write((Object)message);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPrivate(TCMessage message, UnrealId target) {
        IoSession targetSession = this.botSessions.get(target);
        if (targetSession != null) {
            IoSession ioSession = targetSession;
            synchronized (ioSession) {
                targetSession.write((Object)message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInfo(TCInfoMessage message, IoSession session) {
        IoSession ioSession = session;
        synchronized (ioSession) {
            session.write((Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureSession(UnrealId source, IoSession session) {
        if (source == null) {
            return false;
        }
        if (session == null) {
            return false;
        }
        IoSession existing = this.botSessions.get(source);
        if (existing == null) {
            Object object = this.mutex;
            synchronized (object) {
                if (!((Boolean)this.running.getFlag()).booleanValue()) {
                    return false;
                }
                existing = this.botSessions.get(source);
                if (existing == null) {
                    this.log.warning(source.getStringId() + ": Binding new session for this bot.");
                    Map<UnrealId, IoSession> map = this.botSessions;
                    synchronized (map) {
                        this.botSessions.put(source, session);
                    }
                    return true;
                }
            }
        }
        return existing == session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerBot(IoSession session, UnrealId source, PlayerMessage player, TCRequestMessage tcMessage, TCRequestRegister registerData) {
        TCTeam team = null;
        TCInfoStatus data = null;
        Object object = this.mutex;
        synchronized (object) {
            if (!((Boolean)this.running.getFlag()).booleanValue()) {
                return false;
            }
            this.log.warning(source.getStringId() + ": Registering this bot for team " + player.getTeam());
            team = this.teams.get(player.getTeam());
            Object object2 = team;
            synchronized (object2) {
                Set<UnrealId> set = team.getConnectedBots();
                synchronized (set) {
                    team.getConnectedBots().add(source);
                }
            }
            object2 = this.registeredBots;
            synchronized (object2) {
                this.registeredBots.put(source, player);
            }
            this.log.info(source.getStringId() + ": Bot joined the TC, notifying connected bots.");
            Object dataJoined = new TCInfoBotJoined(-1L, this.owner.getSimTime());
            ((TCInfoBotJoined)dataJoined).setBotId(source);
            ((TCInfoBotJoined)dataJoined).setTeam(player.getTeam());
            TCInfoMessage messageJoined = new TCInfoMessage((TCInfoData)dataJoined);
            this.sendGlobalExcept(messageJoined, source);
            this.log.info(source.getStringId() + ": Sending initial TCInfoStatus to this newly joined bot.");
            data = new TCInfoStatus(-1L, this.owner.getSimTime());
            dataJoined = this.registeredBots;
            synchronized (dataJoined) {
                data.setAllBots(new ArrayList<UnrealId>(this.registeredBots.keySet()));
            }
            dataJoined = team;
            synchronized (dataJoined) {
                data.setTeam(team.clone());
            }
            TCInfoMessage message = new TCInfoMessage(data);
            this.sendInfo(message, session);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterBot(UnrealId botId) {
        if (botId == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            Object team;
            PlayerMessage player;
            if (!((Boolean)this.running.getFlag()).booleanValue()) {
                return;
            }
            if (!this.registeredBots.containsKey(botId)) {
                return;
            }
            this.log.warning(botId.getStringId() + ": Unregistering bot.");
            Map<UnrealId, PlayerMessage> map = this.registeredBots;
            synchronized (map) {
                player = this.registeredBots.remove(botId);
            }
            if (player == null) {
                this.log.severe(botId.getStringId() + ": Could not FULLY unregister bot as we do not have PlayerMessage for it! Data structures corrupted.");
            } else {
                team = this.teams.get(player.getTeam());
                if (team == null) {
                    this.log.severe(botId.getStringId() + ": Could not FULLY unregister bot as we do not have TCTeam[" + player.getTeam() + "] for it!");
                } else {
                    TCTeam tCTeam = team;
                    synchronized (tCTeam) {
                        ((TCTeam)team).getConnectedBots().remove(botId);
                        HashSet<TCChannel> toRemove = new HashSet<TCChannel>();
                        Map<Integer, TCChannel> map2 = ((TCTeam)team).getChannels();
                        synchronized (map2) {
                            for (TCChannel channel : ((TCTeam)team).getChannels().values()) {
                                if (channel.getCreator().equals((Object)botId)) {
                                    toRemove.add(channel);
                                    continue;
                                }
                                TCChannel tCChannel = channel;
                                synchronized (tCChannel) {
                                    channel.getConnectedBots().remove(botId);
                                }
                            }
                            for (TCChannel channel : toRemove) {
                                ((TCTeam)team).getChannels().remove(channel.getChannelId());
                                TCInfoTeamChannelDestroyed infoDataTeam = new TCInfoTeamChannelDestroyed(-1L, this.owner.getSimTime());
                                infoDataTeam.setChannelId(channel.getChannelId());
                                infoDataTeam.setDestroyer(botId);
                                TCInfoMessage infoMessageTeam = new TCInfoMessage(infoDataTeam);
                                this.sendTeamExcept(infoMessageTeam, player.getTeam(), botId);
                            }
                        }
                    }
                }
            }
            team = this.botSessions;
            synchronized (team) {
                IoSession session = this.botSessions.remove(botId);
                if (session == null) {
                    this.log.severe(botId.getStringId() + ": Could not FULLY unregister bot as we do not have IoSession for it! Data structures corrupted?");
                } else {
                    session.close(true);
                }
            }
            TCInfoBotLeft infoData = new TCInfoBotLeft(-1L, this.owner.getSimTime());
            infoData.setBotId(botId);
            infoData.setTeam(player == null ? -1 : player.getTeam());
            TCInfoMessage infoMessage = new TCInfoMessage(infoData);
            this.sendGlobalExcept(infoMessage, botId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidRequest(IoSession session, TCInfoRequestFailureType failureType, String reason, long requestId, UnrealId source) {
        block8: {
            if (session == null) {
                return;
            }
            if (failureType == null) {
                failureType = TCInfoRequestFailureType.GENERIC_FAILURE;
            }
            if (reason == null || reason.isEmpty()) {
                reason = "No info.";
            }
            this.log.warning((source == null ? "" : source.getStringId()) + ": InvalidRequest[" + (Object)((Object)failureType) + "] " + reason);
            TCInfoRequestFailed data = new TCInfoRequestFailed(requestId, this.owner.getSimTime());
            data.setFailureType(failureType);
            TCInfoMessage message = new TCInfoMessage(data);
            try {
                IoSession ioSession = session;
                synchronized (ioSession) {
                    session.write((Object)message);
                }
            }
            catch (Exception e) {
                if (!((Boolean)this.running.getFlag()).booleanValue()) break block8;
                this.log.warning(ExceptionToString.process((String)(source.getStringId() + ": Failed to send message to the bot: " + message), (Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionError(IoSession session, String reason) {
        if (session == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (!((Boolean)this.running.getFlag()).booleanValue()) {
                return;
            }
            this.log.warning("SessionError: " + reason);
            UnrealId source = null;
            IoSession ioSession = this.botSessions;
            synchronized (ioSession) {
                for (Map.Entry<UnrealId, IoSession> entry : this.botSessions.entrySet()) {
                    if (entry.getValue() != session) continue;
                    source = entry.getKey();
                    break;
                }
            }
            if (source != null) {
                this.botLeft(source);
            } else {
                ioSession = session;
                synchronized (ioSession) {
                    try {
                        session.close(true);
                    }
                    catch (Exception e) {
                        this.log.warning(ExceptionToString.process((String)"Could not close the session... ???", (Throwable)e));
                    }
                }
            }
        }
    }
}

