/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.hideandseek.server;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.custom.ICustomControlMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.KillBot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendControlMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerJoinsGame;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerLeft;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerMessage;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ObserverFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ObserverModule;
import cz.cuni.amis.pogamut.ut2004.hideandseek.observer.HSObserver;
import cz.cuni.amis.pogamut.ut2004.hideandseek.observer.HSObserverModule;
import cz.cuni.amis.pogamut.ut2004.hideandseek.observer.HSObserverParams;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.HSBotState;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.HSGameConfig;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.HSGameState;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.HSMessages;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.HSScoreChangeReason;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSAssignSeeker;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSBotStateChanged;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSGameEnd;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSGameStart;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSMessage;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSPlayerScoreChanged;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRoundStart;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRoundState;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerCaptured;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerSafe;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerSpotted;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerSurvived;
import cz.cuni.amis.pogamut.ut2004.hideandseek.server.HSBotRecord;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.maps.LazyMap;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class UT2004HSServer
extends UT2004Server
implements IUT2004Server {
    public static final UnrealId SERVER_UNREAL_ID = UnrealId.get((String)"HSSERVER");
    public static final long ROUND_STATE_BROADCAST_PERIOD_SECS = 5L;
    private Random random = new Random(System.currentTimeMillis());
    private Object mutex = new Object();
    private NumberFormat nf;
    private IWorldEventListener<BeginMessage> myBeginMessageListener = new IWorldEventListener<BeginMessage>(){

        public void notify(BeginMessage event) {
            UT2004HSServer.this.timeUpdate(event);
        }
    };
    private IWorldEventListener<EndMessage> myEndMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            UT2004HSServer.this.batchEnd(event);
        }
    };
    private IWorldEventListener<PlayerJoinsGame> myPlayerJoinsGameMessageListener = new IWorldEventListener<PlayerJoinsGame>(){

        public void notify(PlayerJoinsGame event) {
            UT2004HSServer.this.playerJoinsGame(event);
        }
    };
    private IWorldEventListener<PlayerLeft> myPlayerLeftMessageListener = new IWorldEventListener<PlayerLeft>(){

        public void notify(PlayerLeft event) {
            UT2004HSServer.this.playerLeft(event);
        }
    };
    private IWorldObjectListener<PlayerMessage> myPlayerListener = new IWorldObjectListener<PlayerMessage>(){

        public void notify(IWorldObjectEvent<PlayerMessage> event) {
            UT2004HSServer.this.playerUpdate((IWorldObjectEvent<PlayerMessage>)event);
        }
    };
    private HSMessages messages = new HSMessages();
    private Flag<Boolean> gameRunning = new Flag((Object)false);
    private Flag<Boolean> gameFailed = new Flag((Object)false);
    private Flag<HSGameState> gameState = new Flag((Object)HSGameState.NOT_RUNNING);
    private int subState = 0;
    private HSGameConfig config;
    private boolean roundRunning = false;
    private double utTimeCurrent = -1.0;
    private double utTimeLast = -1.0;
    private double utTimeDelta = -1.0;
    private long utSendNextRoundStateTimeLeft = 5L;
    private int roundLeft = -1;
    private int roundNumber = -1;
    private double roundTimeLeft = -1.0;
    private double hideTimeLeft = -1.0;
    private double restrictedAreaTimeLeft = -1.0;
    private HSBotRecord<PlayerMessage> seeker;
    private Map<UnrealId, HSBotRecord<PlayerMessage>> records = new LazyMap<UnrealId, HSBotRecord<PlayerMessage>>(){

        protected HSBotRecord<PlayerMessage> create(UnrealId key) {
            return new HSBotRecord<PlayerMessage>(key);
        }
    };
    Object observersMutex = new Object();
    HSObserver seekerObserver;
    Map<UnrealId, HSObserver> observers = new HashMap<UnrealId, HSObserver>();
    Map<UnrealId, HSObserverStarter> observerStarters = new HashMap<UnrealId, HSObserverStarter>();

    private NumberFormat getNumberFormat() {
        if (this.nf == null) {
            this.nf = NumberFormat.getNumberInstance();
            this.nf.setMaximumFractionDigits(2);
        }
        return this.nf;
    }

    @Inject
    public UT2004HSServer(UT2004AgentParameters params, IAgentLogger agentLogger, IComponentBus bus, SocketConnection connection, UT2004WorldView worldView, IAct act) {
        super(params, agentLogger, bus, connection, worldView, act);
        ((UT2004WorldView)this.getWorldView()).addEventListener(BeginMessage.class, this.myBeginMessageListener);
        ((UT2004WorldView)this.getWorldView()).addEventListener(EndMessage.class, this.myEndMessageListener);
        ((UT2004WorldView)this.getWorldView()).addEventListener(PlayerJoinsGame.class, this.myPlayerJoinsGameMessageListener);
        ((UT2004WorldView)this.getWorldView()).addEventListener(PlayerLeft.class, this.myPlayerLeftMessageListener);
        ((UT2004WorldView)this.getWorldView()).addObjectListener(PlayerMessage.class, this.myPlayerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        super.init();
        Object object = this.mutex;
        synchronized (object) {
            this.getAct().act((CommandMessage)new StartPlayers(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)));
            this.getAct().act((CommandMessage)new Configuration().setVisionTime(Double.valueOf(0.1)));
        }
    }

    protected void reset() {
        super.reset();
    }

    protected void failure(String reason) {
        this.gameFailed.setFlag((Object)true);
        this.gameRunning.setFlag((Object)false);
        throw new RuntimeException(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startGame(HSGameConfig config) {
        NullCheck.check((Object)config, (String)"config");
        if (config.getTargetMap() == null) {
            this.failure("TargetMap is not specified within the configuration!");
            return;
        }
        if (!config.getTargetMap().equalsIgnoreCase(this.getMapName())) {
            this.failure("HSGameConfig is configured for '" + config.getTargetMap() + "', but currently the UT2004 server is running map '" + this.getMapName() + "'.");
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (((Boolean)this.gameRunning.getFlag()).booleanValue()) {
                this.failure("Cannot start the game, game is already running!");
                return;
            }
            this.config = config;
            this.resetHSGame();
            this.gameRunning.setFlag((Object)true);
            this.speak("Game STARTed!");
            HSGameStart startMsg = new HSGameStart(config);
            this.send(startMsg);
            this.roundLeft = config.getRoundCount();
            this.setState(HSGameState.GAME_STARTED);
            for (HSBotRecord<PlayerMessage> record : this.getInGameBots()) {
                if (!record.isBot()) continue;
                this.botStateChanged(record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endGame() {
        Object object = this.mutex;
        synchronized (object) {
            if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
                this.failure("Cannot end game, game is not running!");
                return;
            }
            HSGameEnd endMsg = new HSGameEnd();
            this.send(endMsg);
            long finishTime = System.currentTimeMillis();
            for (HSBotRecord<PlayerMessage> record : this.records.values()) {
                if (!record.isInGame()) continue;
                record.setFinishTime(finishTime);
            }
            this.speak("Game ENDed!");
            this.setState(HSGameState.NOT_RUNNING);
            this.gameRunning.setFlag((Object)false);
        }
    }

    public Flag<Boolean> isGameRunning() {
        return this.gameRunning;
    }

    public boolean isRoundRunning() {
        return this.roundRunning;
    }

    public Flag<HSGameState> getGameState() {
        return this.gameState;
    }

    public Flag<Boolean> getGameFailed() {
        return this.gameFailed;
    }

    public Map<UnrealId, HSBotRecord<PlayerMessage>> getBotRecords() {
        return this.records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playerUpdate(IWorldObjectEvent<PlayerMessage> event) {
        Object object = this.mutex;
        synchronized (object) {
            PlayerMessage player = (PlayerMessage)event.getObject();
            HSBotRecord<PlayerMessage> record = this.ensurePlayer(player.getId());
            record.setPlayer(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playerJoinsGame(PlayerJoinsGame event) {
        Object object = this.mutex;
        synchronized (object) {
            this.ensurePlayer(event.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playerLeft(PlayerLeft event) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.records.containsKey(event.getId())) {
                return;
            }
            HSBotRecord<PlayerMessage> record = this.records.get(event.getId());
            record.setInGame(false);
            record.setFinishTime(System.currentTimeMillis());
            if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
                return;
            }
            if (this.seeker == null) {
                return;
            }
            if (event.getId() == this.seeker.getPlayer().getId()) {
                this.failure("Seeker has left the game!");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeUpdate(BeginMessage event) {
        Object object = this.mutex;
        synchronized (object) {
            this.utTimeLast = this.utTimeCurrent;
            this.utTimeCurrent = event.getTime();
            this.utTimeDelta = this.utTimeLast > 0.0 ? this.utTimeCurrent - this.utTimeLast : -1.0;
            if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
                return;
            }
            if (this.utTimeLast > 0.0 && this.utTimeCurrent > 0.0 && this.utTimeDelta > 0.0) {
                this.utSendNextRoundStateTimeLeft = (long)((double)this.utSendNextRoundStateTimeLeft - this.utTimeDelta);
                if (this.utSendNextRoundStateTimeLeft < 0L) {
                    HSRoundState msg = new HSRoundState();
                    msg.setGameState(((HSGameState)((Object)this.gameState.getFlag())).stateNumber);
                    msg.setHideTimeLeftUT(this.hideTimeLeft);
                    msg.setRestrictedAreaTimeLeftUT(this.restrictedAreaTimeLeft);
                    if (this.roundNumber >= 0) {
                        msg.setRoundLeft(this.config.getRoundCount() - 1 - this.roundNumber);
                    } else {
                        msg.setRoundLeft(this.config.getRoundCount());
                    }
                    msg.setRoundTimeLeftUT(this.roundTimeLeft);
                    msg.setSafeArea(this.config.getSafeArea());
                    msg.setSeekerBotId(this.seeker == null ? null : this.seeker.getPlayer().getId());
                    this.send(msg);
                    this.utSendNextRoundStateTimeLeft = 5L;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchEnd(EndMessage event) {
        Object object = this.mutex;
        synchronized (object) {
            if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
                return;
            }
            if (this.utTimeDelta <= 0.0) {
                return;
            }
            this.tick();
        }
    }

    private void setState(HSGameState state) {
        if (state == this.gameState.getFlag()) {
            return;
        }
        this.gameState.setFlag((Object)state);
        this.subState = 0;
        if (state == HSGameState.NOT_RUNNING) {
            return;
        }
        HSRoundState msg = new HSRoundState();
        msg.setGameState(state.stateNumber);
        msg.setHideTimeLeftUT(this.hideTimeLeft);
        msg.setRestrictedAreaTimeLeftUT(this.restrictedAreaTimeLeft);
        msg.setRoundLeft(this.roundLeft);
        msg.setRoundNumber(this.roundNumber);
        msg.setRoundTimeLeftUT(this.roundTimeLeft);
        msg.setSafeArea(this.config.getSafeArea());
        msg.setSeekerBotId(this.seeker == null ? null : this.seeker.getBotId());
        this.send(msg);
    }

    private void tick() {
        assert (this.utTimeDelta > 0.0);
        if (this.roundRunning) {
            this.roundTimeLeft -= this.utTimeDelta;
            if (this.roundTimeLeft < 0.0) {
                this.roundTimeLeft = -1.0;
                this.roundRunning = false;
                this.speak("Round ENDING!");
                this.setState(HSGameState.ROUND_ENDED);
            }
        }
        switch ((HSGameState)((Object)this.gameState.getFlag())) {
            case NOT_RUNNING: {
                this.stateNotRunning();
                break;
            }
            case GAME_STARTED: {
                this.stateGameStarted();
                break;
            }
            case START_NEXT_ROUND: {
                this.stateStartNextRound();
                break;
            }
            case ROUND_STARTING: {
                this.stateRoundStarting();
                break;
            }
            case HIDING_TIME: {
                this.stateHidingTime();
                break;
            }
            case SPAWNING_SEEKER: {
                this.stateSpawningSeeker();
                break;
            }
            case RESTRICTED_AREA_ACTIVE: {
                this.stateRestrictedAreaActive();
                break;
            }
            case ROUND_RUNNING: {
                this.stateRoundRunning();
                break;
            }
            case ROUND_ENDED: {
                this.stateRoundEnded();
                break;
            }
            default: {
                this.failure("Unexpected HSGameState: " + this.gameState.getFlag());
                return;
            }
        }
    }

    private void stateNotRunning() {
    }

    private void stateGameStarted() {
        if (this.config.getRoundCount() <= 0) {
            this.endGame();
            return;
        }
        this.resetHSRound();
        this.roundNumber = -1;
        this.roundLeft = this.config.getRoundCount();
        this.setState(HSGameState.START_NEXT_ROUND);
    }

    private void stateStartNextRound() {
        if (this.roundLeft > 0) {
            --this.roundLeft;
            ++this.roundNumber;
            this.speak("STARTING ROUND " + (this.roundNumber + 1) + " / " + this.config.getRoundCount() + " !!!");
            this.setState(HSGameState.ROUND_STARTING);
        } else {
            this.endGame();
        }
    }

    private void stateRoundStarting() {
        if (this.getInGameBots().size() < 2) {
            if (this.subState == 0) {
                this.speak("Not enough players in the game, waiting...");
                return;
            }
            this.speakError("Some player has left the game during round-starting, unsupported!");
            this.failure("Some player has left the game during round-starting, unsupported!");
            return;
        }
        switch (this.subState) {
            case 0: {
                if (this.getInGameBots().size() < 1) {
                    this.speak("Not enought BOTS in the game, waiting...");
                    return;
                }
                this.send(new HSRoundStart());
                if (this.config.isFixedSeeker() ? !this.assignFixedSeeker() : !this.assignRandomSeeker()) {
                    return;
                }
                for (HSBotRecord<PlayerMessage> record : this.getInGameBots()) {
                    if (record.getBotId() == this.seeker.getBotId()) continue;
                    record.setRunnerForThisRound();
                    this.botStateChanged(record);
                }
                this.subState = 1;
                break;
            }
            case 1: {
                this.speak("Configuring all bots to MANUAL SPAWN...");
                for (HSBotRecord<PlayerMessage> botRecord : this.getInGameBots()) {
                    this.configManualSpawn(botRecord);
                }
                this.subState = 2;
                break;
            }
            case 2: {
                this.speak("Killing all bots...");
                for (HSBotRecord<PlayerMessage> botRecord : this.getInGameBots()) {
                    this.killBot(botRecord);
                }
                this.subState = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                ++this.subState;
                break;
            }
            case 6: {
                this.speak("Waiting for seeker-observer to initialize...");
                ++this.subState;
                break;
            }
            case 7: {
                if (!this.ensureSeekerObserver()) break;
                this.subState = 8;
                this.speak("Seeker-observer to initialized.");
                break;
            }
            case 8: {
                this.spawnRunners();
                this.subState = 9;
                break;
            }
            case 9: 
            case 10: {
                ++this.subState;
                break;
            }
            case 11: {
                this.speak("ALL RUNNERS SHOULD START HIDING!");
                this.roundRunning = true;
                this.roundTimeLeft = this.config.getRoundTimeUT();
                this.hideTimeLeft = this.config.getHideTimeUT();
                this.restrictedAreaTimeLeft = -1.0;
                this.setState(HSGameState.HIDING_TIME);
            }
        }
    }

    private boolean assignFixedSeeker() {
        List<HSBotRecord<PlayerMessage>> botRecords = this.getInGameBots();
        for (HSBotRecord<PlayerMessage> botRecord : botRecords) {
            if (!botRecord.getPlayer().getName().startsWith(this.config.getFixedSeekerName())) continue;
            this.assignSeeker(botRecord);
            return true;
        }
        this.speak("Could not assign fixed seeker, cannot find player with name '" + this.config.getFixedSeekerName() + "', waiting ...");
        return false;
    }

    private boolean assignRandomSeeker() {
        List<HSBotRecord<PlayerMessage>> botRecords = this.getInGameBots();
        HSBotRecord<PlayerMessage> randomBot = botRecords.get(this.random.nextInt(botRecords.size()));
        this.assignSeeker(randomBot);
        return true;
    }

    private void assignSeeker(HSBotRecord<PlayerMessage> botRecord) {
        this.seeker = botRecord;
        this.seeker.setSeekerForThisRound();
        HSAssignSeeker msg = new HSAssignSeeker();
        msg.setBotId(this.seeker.getBotId());
        this.send(msg);
        this.botStateChanged(this.seeker);
        this.speak("Seeker assigned to: " + botRecord.getPlayer().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureSeekerObserver() {
        Object object = this.observersMutex;
        synchronized (object) {
            if (this.observers.containsKey(this.seeker.getBotId())) {
                this.seekerObserver = this.observers.get(this.seeker.getBotId());
                return true;
            }
            this.ensureSingleObserver(this.seeker);
            return false;
        }
    }

    private void spawnRunners() {
        this.speak("Spawning all RUNNERs...");
        List<HSBotRecord<PlayerMessage>> runners = this.getInGameRunners();
        double angleDelta = Math.PI * 2 / (double)runners.size();
        double currentAngle = 0.0;
        if (runners.size() == 0) {
            this.failure("There are ZERO runners in the game! Invalid state.");
            return;
        }
        for (HSBotRecord<PlayerMessage> botRecord : runners) {
            Location spawnAngle = new Location(1.0, 0.0, 0.0).rotateXY(currentAngle);
            spawnAngle = spawnAngle.scale((double)this.config.getSpawnRadiusForRunners());
            Location start = this.config.getSafeArea().add(spawnAngle);
            this.respawn(botRecord, start);
            currentAngle += angleDelta;
        }
    }

    private void stateHidingTime() {
        this.hideTimeLeft -= this.utTimeDelta;
        if (this.hideTimeLeft < 0.0) {
            this.restrictedAreaTimeLeft = this.config.getRestrictedAreaTimeUT();
            this.setState(HSGameState.SPAWNING_SEEKER);
        }
    }

    private void stateSpawningSeeker() {
        switch (this.subState) {
            case 0: {
                this.speak("Spawning SEEKER!");
                this.respawn(this.seeker, this.config.getSafeArea());
                this.subState = 1;
                break;
            }
            case 1: {
                this.speak("Restricted area activated! Runners are not allowed to move near the safe area, radius: " + this.config.getRestrictedAreaRadius());
                this.hideTimeLeft = -1.0;
                this.restrictedAreaTimeLeft = this.config.getRestrictedAreaTimeUT();
                this.setState(HSGameState.RESTRICTED_AREA_ACTIVE);
            }
        }
    }

    private void stateRestrictedAreaActive() {
        this.killRunnersInRestrictedArea();
        this.restrictedAreaTimeLeft -= this.utTimeDelta;
        if (this.restrictedAreaTimeLeft < 0.0) {
            this.speak("Restricted are DEactivated! Runners now may reach safe area, radius: " + this.config.getSafeAreaRadius());
            this.restrictedAreaTimeLeft = -1.0;
            this.setState(HSGameState.ROUND_RUNNING);
        }
        this.roundRunning();
    }

    private void killRunnersInRestrictedArea() {
        List<HSBotRecord<PlayerMessage>> runners = this.getInGameAliveRunners();
        for (HSBotRecord<PlayerMessage> runner : runners) {
            double distance = runner.getPlayer().getLocation().getDistance(this.config.getSafeArea());
            if (!(distance < (double)this.config.getRestrictedAreaRadius())) continue;
            this.foulRunner(runner, distance);
        }
    }

    private void foulRunner(HSBotRecord<PlayerMessage> runner, double distanceFromSafeArea) {
        this.speak("Fouling runner " + runner.getBotName() + ", its distance from safe area = " + this.getNumberFormat().format(distanceFromSafeArea) + " < " + this.config.getRestrictedAreaRadius() + " = restricted area radius.");
        runner.runnerFauled(this.config.getRunnerFouled(), this.seeker.getBotId());
        this.botStateChanged(runner);
        this.scoreChanged(runner, HSScoreChangeReason.RUNNER_FAULED_DUE_TO_BEING_IN_RESTRICTED_AREA);
        this.killBot(runner);
    }

    private void stateRoundRunning() {
        this.roundRunning();
    }

    private void roundRunning() {
        this.checkSeekerObserverRunning();
        this.checkSpotRunners();
        this.checkRunnersSafe();
        this.checkRunnersCapture();
        this.checkAnyRunnersAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSeekerObserverRunning() {
        Object object = this.observersMutex;
        synchronized (object) {
            if (!this.seekerObserver.inState(new Class[]{IAgentStateRunning.class})) {
                this.log.severe("Seeker-Observer for bot " + this.seeker.getBotId().getStringId() + " has died out.");
                this.speakError("Seeker-Observer for bot " + this.seeker.getBotId().getStringId() + " has died out.");
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSpotRunners() {
        Object object = this.observersMutex;
        synchronized (object) {
            List<Player> spottedBySeeker = this.seekerObserver.getPlayersVisibleMoreThanMillis(this.config.getSpotTimeMillis());
            for (Player spottedPlayer : spottedBySeeker) {
                HSBotRecord<PlayerMessage> spotted = this.records.get(spottedPlayer.getId());
                if (spotted.getBotState() != HSBotState.RUNNER) continue;
                this.runnerSpotted(spotted);
            }
        }
    }

    private void runnerSpotted(HSBotRecord<PlayerMessage> runner) {
        HSRunnerSpotted msg = new HSRunnerSpotted();
        msg.setBotId(runner.getBotId());
        this.send(msg);
        runner.runnerSpottedBySeeker(this.config.getRunnerSpotted(), this.seeker.getBotId());
        this.botStateChanged(runner);
        this.scoreChanged(runner, HSScoreChangeReason.RUNNER_SPOTTED_BY_SEEKER);
        this.seeker.seekerSpottedRunner(this.config.getSeekerSpottedRunner(), runner.getBotId());
        this.scoreChanged(runner, HSScoreChangeReason.SEEKER_SPOTTED_RUNNER);
    }

    private void checkRunnersSafe() {
        List<HSBotRecord<PlayerMessage>> aliveRunners = this.getInGameAliveRunners();
        for (HSBotRecord<PlayerMessage> aliveRunner : aliveRunners) {
            double safeAreaDistance = aliveRunner.getPlayer().getLocation().getDistance(this.config.getSafeArea());
            if (!(safeAreaDistance < (double)this.config.getSafeAreaRadius())) continue;
            this.runnerSafe(aliveRunner, safeAreaDistance);
        }
    }

    private void runnerSafe(HSBotRecord<PlayerMessage> runner, double safeAreaDistance) {
        this.speak("Runner " + runner.getBotName() + " reached safe area! Distance from safe area = " + this.getNumberFormat().format(safeAreaDistance) + " < " + this.config.getSafeAreaRadius() + " = safe area radius.");
        HSRunnerSafe msg = new HSRunnerSafe();
        msg.setBotId(runner.getBotId());
        this.send(msg);
        runner.runnerSafe(this.config.getRunnerSafe(), this.seeker.getBotId());
        this.botStateChanged(runner);
        this.scoreChanged(runner, HSScoreChangeReason.RUNNER_REACHED_SAFE_AREA);
        this.seeker.seekerLetRunnerEscape(this.config.getSeekerLetRunnerEscape(), runner.getBotId());
        this.scoreChanged(this.seeker, HSScoreChangeReason.SEEKER_LET_RUNNER_ESCAPE);
        this.killBot(runner);
    }

    private void checkRunnersCapture() {
        double seekerSafeAreaDistance = this.seeker.getPlayer().getLocation().getDistance(this.config.getSafeArea());
        if (seekerSafeAreaDistance < (double)this.config.getSafeAreaRadius()) {
            List<HSBotRecord<PlayerMessage>> spottedRunners = this.getInGameSpottedRunners();
            for (HSBotRecord<PlayerMessage> spottedRunner : spottedRunners) {
                this.captureRunner(spottedRunner);
            }
        }
    }

    private void captureRunner(HSBotRecord<PlayerMessage> spottedRunner) {
        HSRunnerCaptured msg = new HSRunnerCaptured();
        msg.setBotId(spottedRunner.getBotId());
        this.send(msg);
        spottedRunner.runnerCapturedBySeeker(this.config.getRunnerCaptured(), this.seeker.getBotId());
        this.botStateChanged(spottedRunner);
        this.scoreChanged(spottedRunner, HSScoreChangeReason.RUNNER_CAPTURED_BY_SEEKER);
        this.seeker.seekerCapturedRunner(this.config.getSeekerCapturedRunner(), spottedRunner.getBotId());
        this.scoreChanged(this.seeker, HSScoreChangeReason.SEEKER_HAS_CAPTURED_RUNNER);
        this.killBot(spottedRunner);
    }

    private void checkAnyRunnersAlive() {
        List<HSBotRecord<PlayerMessage>> aliveRunners = this.getInGameAliveRunners();
        if (aliveRunners.size() == 0) {
            this.speak("No runners remaining... ending the round.");
            this.setState(HSGameState.ROUND_ENDED);
        }
    }

    private void stateRoundEnded() {
        switch (this.subState) {
            case 0: {
                this.surviveAllAliveRunners();
                this.killAllAliveBots();
                this.speak("Round ENDed!");
                this.subState = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                ++this.subState;
                break;
            }
            case 5: {
                this.setState(HSGameState.START_NEXT_ROUND);
            }
        }
    }

    private void surviveAllAliveRunners() {
        List<HSBotRecord<PlayerMessage>> aliveRunners = this.getInGameAliveRunners();
        for (HSBotRecord<PlayerMessage> aliveRunner : aliveRunners) {
            this.surviveRunner(aliveRunner);
        }
    }

    private void surviveRunner(HSBotRecord<PlayerMessage> survivedRunner) {
        survivedRunner.runnerSurvived(this.config.getRunnerSurvived(), this.seeker.getBotId());
        HSRunnerSurvived msg = new HSRunnerSurvived();
        msg.setBotId(survivedRunner.getBotId());
        this.send(msg);
        this.botStateChanged(survivedRunner);
        this.scoreChanged(survivedRunner, HSScoreChangeReason.RUNNER_SURVIVED_THE_ROUND);
    }

    private void killAllAliveBots() {
        this.speak("Killing all remaining bots...");
        List<HSBotRecord<PlayerMessage>> aliveBots = this.getInGameAliveBots();
        for (HSBotRecord<PlayerMessage> aliveBot : aliveBots) {
            this.killBot(aliveBot);
        }
    }

    private void respawn(HSBotRecord<PlayerMessage> botRecord, Location spawningPoint) {
        botRecord.setSpawned(true);
        Respawn respawn = new Respawn();
        respawn.setId(botRecord.getBotId());
        respawn.setStartLocation(spawningPoint);
        this.send((CommandMessage)respawn);
    }

    private void botStateChanged(HSBotRecord<PlayerMessage> botRecord) {
        HSBotStateChanged msg = new HSBotStateChanged();
        msg.setBotId(botRecord.getBotId());
        msg.setNewState(botRecord.getBotState());
        this.send(msg);
    }

    private void configManualSpawn(HSBotRecord<PlayerMessage> botRecord) {
        Configuration conf = new Configuration();
        conf.setId(botRecord.getBotId());
        conf.setManualSpawn(Boolean.valueOf(true));
        this.send((CommandMessage)conf);
    }

    private void killBot(HSBotRecord<PlayerMessage> botRecord) {
        botRecord.setSpawned(false);
        KillBot cmd = new KillBot();
        cmd.setId(botRecord.getBotId());
        this.send((CommandMessage)cmd);
    }

    private HSBotRecord<PlayerMessage> ensurePlayer(UnrealId botId) {
        if (botId == null) {
            return null;
        }
        HSBotRecord<PlayerMessage> record = this.records.get(botId);
        if (record.isInGame()) {
            return record;
        }
        record.reset();
        record.setInGame(true);
        if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
            return record;
        }
        this.botStateChanged(record);
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSingleObserver(HSBotRecord<PlayerMessage> record) {
        Object object = this.observersMutex;
        synchronized (object) {
            if (!this.observers.containsKey(record.getBotId()) && !this.observerStarters.containsKey(record.getBotId())) {
                this.ensureObserver(record);
            }
            ArrayList<UnrealId> toKill = new ArrayList<UnrealId>();
            for (Map.Entry<UnrealId, HSObserver> entry : this.observers.entrySet()) {
                if (entry.getKey() == record.getBotId()) continue;
                toKill.add(entry.getKey());
            }
            for (UnrealId unrealId : toKill) {
                new HSObserverKiller(this.observers.remove(unrealId)).start();
            }
            for (Map.Entry<Object, Object> entry : this.observerStarters.entrySet()) {
                if (entry.getKey() == record.getBotId()) continue;
                ((HSObserverStarter)entry.getValue()).observerValid = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureObserver(HSBotRecord<PlayerMessage> record) {
        if (this.observers.containsKey(record.getBotId())) {
            return;
        }
        if (this.observerStarters.containsKey(record.getBotId())) {
            return;
        }
        HSObserverStarter starter = null;
        Object object = this.observersMutex;
        synchronized (object) {
            if (this.observers.containsKey(record.getBotId())) {
                return;
            }
            if (this.observerStarters.containsKey(record.getBotId())) {
                return;
            }
            starter = new HSObserverStarter(record, this.config.getObserverPort());
            this.observerStarters.put(record.getBotId(), starter);
        }
        starter.start();
    }

    private List<HSBotRecord<PlayerMessage>> getInGameBots() {
        ArrayList<HSBotRecord<PlayerMessage>> result = new ArrayList<HSBotRecord<PlayerMessage>>();
        for (HSBotRecord<PlayerMessage> record : this.records.values()) {
            if (!record.isInGame() || record.getPlayer().getJmx() == null) continue;
            result.add(record);
        }
        return result;
    }

    private List<HSBotRecord<PlayerMessage>> getInGameRunners() {
        ArrayList<HSBotRecord<PlayerMessage>> result = new ArrayList<HSBotRecord<PlayerMessage>>();
        for (HSBotRecord<PlayerMessage> record : this.records.values()) {
            if (!record.isInGame() || record.getPlayer().getJmx() == null || record.getBotState() == HSBotState.SEEKER) continue;
            result.add(record);
        }
        return result;
    }

    private List<HSBotRecord<PlayerMessage>> getInGameAliveRunners() {
        ArrayList<HSBotRecord<PlayerMessage>> result = new ArrayList<HSBotRecord<PlayerMessage>>();
        for (HSBotRecord<PlayerMessage> record : this.records.values()) {
            if (!record.isInGame() || record.getPlayer().getJmx() == null || record.getBotState() != HSBotState.RUNNER && record.getBotState() != HSBotState.RUNNER_SPOTTED) continue;
            result.add(record);
        }
        return result;
    }

    private List<HSBotRecord<PlayerMessage>> getInGameAliveBots() {
        ArrayList<HSBotRecord<PlayerMessage>> result = new ArrayList<HSBotRecord<PlayerMessage>>();
        for (HSBotRecord<PlayerMessage> record : this.records.values()) {
            if (!record.isInGame() || record.getPlayer().getJmx() == null || !record.isSpawned()) continue;
            result.add(record);
        }
        return result;
    }

    private List<HSBotRecord<PlayerMessage>> getInGameSpottedRunners() {
        ArrayList<HSBotRecord<PlayerMessage>> result = new ArrayList<HSBotRecord<PlayerMessage>>();
        for (HSBotRecord<PlayerMessage> record : this.records.values()) {
            if (!record.isInGame() || record.getPlayer().getJmx() == null || record.getBotState() != HSBotState.RUNNER_SPOTTED) continue;
            result.add(record);
        }
        return result;
    }

    private void scoreChanged(HSBotRecord<PlayerMessage> botRecord, HSScoreChangeReason reason) {
        HSPlayerScoreChanged msg = new HSPlayerScoreChanged();
        msg.setBotId(botRecord.getBotId());
        msg.setScore(botRecord.getScore());
        msg.setScoreChangeReason(reason.number);
        this.send(msg);
    }

    private void send(HSMessage message) {
        if (((Boolean)this.gameRunning.getFlag()).booleanValue()) {
            SendControlMessage command = this.messages.write((ICustomControlMessage)message);
            command.setSendAll(Boolean.valueOf(true));
            this.getAct().act((CommandMessage)command);
        }
    }

    private void send(CommandMessage command) {
        if (((Boolean)this.gameRunning.getFlag()).booleanValue()) {
            this.getAct().act(command);
        }
    }

    private void speak(String message) {
        if (((Boolean)this.gameRunning.getFlag()).booleanValue()) {
            this.getAct().act((CommandMessage)new SendMessage().setGlobal(Boolean.valueOf(true)).setText("[HS] " + message));
        }
    }

    private void speakError(String message) {
        if (((Boolean)this.gameRunning.getFlag()).booleanValue()) {
            this.getAct().act((CommandMessage)new SendMessage().setGlobal(Boolean.valueOf(true)).setText("[HS] [ERROR] " + message));
        }
    }

    private void resetHSRound() {
        this.roundRunning = false;
        this.roundTimeLeft = this.config.getRoundTimeUT();
        this.hideTimeLeft = -1.0;
        this.restrictedAreaTimeLeft = -1.0;
    }

    private void resetHSGame() {
        this.gameRunning.setFlag((Object)false);
        this.roundLeft = -1;
        this.roundNumber = -1;
        this.seeker = null;
        this.utSendNextRoundStateTimeLeft = 5L;
        Iterator<HSBotRecord<PlayerMessage>> recordIter = this.records.values().iterator();
        while (recordIter.hasNext()) {
            HSBotRecord<PlayerMessage> record = recordIter.next();
            if (!record.isInGame()) {
                recordIter.remove();
                continue;
            }
            record.reset();
            record.setInGame(true);
        }
    }

    protected void stopAgent() {
        super.stopAgent();
        this.cleanUp();
    }

    protected void killAgent() {
        super.killAgent();
        try {
            this.cleanUp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        Object object = this.observersMutex;
        synchronized (object) {
            for (HSObserver observer : this.observers.values()) {
                try {
                    new HSObserverKiller(observer);
                }
                catch (Exception e) {}
            }
            this.observers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void observerFailedToStart(HSBotRecord botToObserve, Exception e) {
        Map<UnrealId, HSObserverStarter> map = this.observerStarters;
        synchronized (map) {
            this.observerStarters.remove(botToObserve.getBotId());
        }
        this.log.severe(ExceptionToString.process((String)("Failed to start observer for bot: " + botToObserve.getBotId()), (Throwable)e));
        this.kill();
    }

    private class HSObserverKiller
    extends Thread {
        private HSObserver observer;

        public HSObserverKiller(HSObserver observer) {
            this.observer = observer;
        }

        @Override
        public void run() {
            if (this.observer == null) {
                return;
            }
            this.observer.kill();
        }
    }

    private class HSObserverStarter
    extends Thread {
        private HSBotRecord botToObserve;
        private int observerPort;
        public boolean observerValid = true;

        public HSObserverStarter(HSBotRecord botToObserve, int observerPort) {
            this.botToObserve = botToObserve;
            this.observerPort = observerPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HSObserverParams params = new HSObserverParams();
                params.setAgentId((IAgentId)new AgentId("Observer-" + this.botToObserve.getBotId().getStringId()));
                URI worldAddress = UT2004HSServer.this.getWorldAddress();
                params.setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(worldAddress.getHost(), this.observerPort));
                params.setBotIDToObserve(this.botToObserve.getBotId().getStringId());
                HSObserverModule module = new HSObserverModule();
                UT2004ObserverFactory observerFactory = new UT2004ObserverFactory((UT2004ObserverModule)module);
                HSObserver observer = (HSObserver)observerFactory.newAgent((IAgentParameters)params);
                try {
                    observer.start();
                }
                catch (Exception e) {
                    UT2004HSServer.this.observerFailedToStart(this.botToObserve, e);
                    return;
                }
                Object object = UT2004HSServer.this.observersMutex;
                synchronized (object) {
                    if (this.observerValid && UT2004HSServer.this.inState(new Class[]{IAgentStateRunning.class})) {
                        UT2004HSServer.this.observers.put(this.botToObserve.getBotId(), observer);
                        UT2004HSServer.this.observerStarters.remove(this.botToObserve.getBotId());
                    } else {
                        new HSObserverKiller(observer).start();
                    }
                }
            }
            catch (Exception e) {
                Object object = UT2004HSServer.this.observersMutex;
                synchronized (object) {
                    UT2004HSServer.this.observerStarters.remove(this.botToObserve.getBotId());
                }
            }
        }
    }
}

