/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.data;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.Path;

public class PathResult {
    private Path path;
    private ResultType type;
    private long duration;
    private Location failedAt = null;
    private NavPoint nearestNavPoint = null;

    public PathResult(Path path, ResultType type) {
        this(path, type, 0L);
    }

    public PathResult(Path path, ResultType type, long duration) {
        this.path = path;
        this.type = type;
        this.duration = duration;
    }

    public PathResult(Path path, ResultType type, long duration, Location failedAt, NavPoint nearest) {
        this(path, type, duration);
        this.failedAt = failedAt;
        this.nearestNavPoint = nearest;
    }

    public String export() {
        return String.format("%s;%s;%s;%s;%d;%f;%d;%d;%s;%s", new Object[]{this.path.getId(), this.path.getStart().getId().getStringId(), this.path.getEnd().getId().getStringId(), this.type, this.duration, this.path.getLength(), this.path.getJumps(), this.path.getLifts(), this.failedAt == null ? "" : this.failedAt.toString().replace(";", "|"), this.nearestNavPoint == null ? "" : this.nearestNavPoint.getId().getStringId()});
    }

    public static enum ResultType {
        NotBuilt,
        Failed,
        Completed,
        FailedToStart,
        FailedInNavigate,
        FailedToStartInNavigate;

    }
}

