/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.BotNavigationParameters;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.EvaluatingBot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.NavigationEvaluatingBot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.PathContainer;
import java.io.File;

public class NavigationFactory {
    public static IPathPlanner getPathPlanner(EvaluatingBot bot, UT2004Bot utBot, String pathPlannerType) {
        if (pathPlannerType != null) {
            if (pathPlannerType.equals("fwMap")) {
                return bot.getFwMap();
            }
            if (pathPlannerType.equals("navMesh")) {
                return bot.getNavMeshModule().getAStarPathPlanner();
            }
            if (pathPlannerType.equals("oldNavMesh")) {
                return bot.getOldNavMeshModule().getNavMesh();
            }
        }
        return null;
    }

    public static IUT2004Navigation getNavigation(EvaluatingBot bot, UT2004Bot utBot, String navigationType) {
        if (navigationType.equals("acc")) {
            return bot.getNMNav();
        }
        return bot.getNavigation();
    }

    static void initializePathContainer(PathContainer pathContainer, NavigationEvaluatingBot bot) {
        BotNavigationParameters params = bot.getParams();
        if (params.isRepeatTask()) {
            File file = new File(params.getRepeatFile());
            pathContainer.buildFromFile(file, true);
        } else if (params.isOnlyRelevantPaths()) {
            pathContainer.buildRelevant(bot.getParams().getLimit());
        } else {
            pathContainer.build(bot.getParams().getLimit());
        }
    }
}

