/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d.transform;

import java.util.ArrayList;
import java.util.Collection;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import math.geom3d.Point3D;
import math.geom3d.Shape3D;
import math.geom3d.Vector3D;
import math.geom3d.transform.Bijection3D;

public class AffineTransform3D
implements Bijection3D {
    protected Matrix4d matrix;
    static final Matrix4d identity = new Matrix4d();

    public static AffineTransform3D createTranslation(Vector3D vec) {
        return AffineTransform3D.createTranslation(vec.getX(), vec.getY(), vec.getZ());
    }

    public static AffineTransform3D createTranslation(double x, double y, double z) {
        return new AffineTransform3D(1.0, 0.0, 0.0, x, 0.0, 1.0, 0.0, y, 0.0, 0.0, 1.0, z);
    }

    public static AffineTransform3D createRotationOx(double theta) {
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.rotX(theta);
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.set(matrix3d);
        return new AffineTransform3D(matrix4d);
    }

    public static AffineTransform3D createRotationOy(double theta) {
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.rotY(theta);
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.set(matrix3d);
        return new AffineTransform3D(matrix4d);
    }

    public static AffineTransform3D createRotationOz(double theta) {
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.rotZ(theta);
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.set(matrix3d);
        return new AffineTransform3D(matrix4d);
    }

    public static AffineTransform3D createScaling(double s) {
        return AffineTransform3D.createScaling(s, s, s);
    }

    public static AffineTransform3D createScaling(Vector3D scalingVector) {
        return AffineTransform3D.createScaling(scalingVector.getX(), scalingVector.getY(), scalingVector.getZ());
    }

    public static AffineTransform3D createScaling(double sx, double sy, double sz) {
        return new AffineTransform3D(sx, 0.0, 0.0, 0.0, 0.0, sy, 0.0, 0.0, 0.0, 0.0, sz, 0.0);
    }

    public AffineTransform3D() {
        this.matrix = new Matrix4d();
        this.matrix.setIdentity();
    }

    public AffineTransform3D(double[] coeficients) {
        this.matrix = new Matrix4d();
        if (coeficients.length == 9) {
            this.matrix.set(new Matrix3d(coeficients));
        } else if (coeficients.length == 12) {
            double[] extendedCoeficients = new double[16];
            for (int i = 0; i < coeficients.length; ++i) {
                extendedCoeficients[i] = coeficients[i];
            }
            extendedCoeficients[12] = 0.0;
            extendedCoeficients[13] = 0.0;
            extendedCoeficients[14] = 0.0;
            extendedCoeficients[15] = 1.0;
            this.matrix.set(extendedCoeficients);
        }
    }

    public AffineTransform3D(double xx, double yx, double zx, double tx, double xy, double yy, double zy, double ty, double xz, double yz, double zz, double tz) {
        this.matrix = new Matrix4d();
        this.matrix.m00 = xx;
        this.matrix.m01 = yx;
        this.matrix.m02 = zx;
        this.matrix.m03 = tx;
        this.matrix.m10 = xy;
        this.matrix.m11 = yy;
        this.matrix.m12 = zy;
        this.matrix.m13 = ty;
        this.matrix.m20 = xz;
        this.matrix.m21 = yz;
        this.matrix.m22 = zz;
        this.matrix.m23 = tz;
        this.matrix.m30 = 0.0;
        this.matrix.m31 = 0.0;
        this.matrix.m32 = 0.0;
        this.matrix.m33 = 1.0;
    }

    protected AffineTransform3D(Matrix4d matrix) {
        this.matrix = matrix;
    }

    public boolean isIdentity() {
        return this.matrix.equals(identity);
    }

    public Matrix4d getMatrix() {
        return new Matrix4d(this.matrix);
    }

    @Override
    public AffineTransform3D getInverseTransform() {
        Matrix4d invertedMatrix = new Matrix4d(this.matrix);
        invertedMatrix.invert();
        return new AffineTransform3D(invertedMatrix);
    }

    @Deprecated
    public void setTransform(double n00, double n01, double n02, double n03, double n10, double n11, double n12, double n13, double n20, double n21, double n22, double n23) {
        this.matrix.m00 = n00;
        this.matrix.m01 = n01;
        this.matrix.m02 = n02;
        this.matrix.m03 = n03;
        this.matrix.m10 = n10;
        this.matrix.m11 = n11;
        this.matrix.m12 = n12;
        this.matrix.m13 = n13;
        this.matrix.m20 = n20;
        this.matrix.m21 = n21;
        this.matrix.m22 = n22;
        this.matrix.m23 = n23;
    }

    @Deprecated
    public void setTransform(AffineTransform3D trans) {
        this.matrix.set(trans.matrix);
    }

    @Deprecated
    public void setToIdentity() {
        this.matrix.setIdentity();
    }

    public AffineTransform3D concatenate(AffineTransform3D second) {
        Matrix4d concatenatedMatrix = new Matrix4d(second.matrix);
        concatenatedMatrix.mul(this.matrix);
        return new AffineTransform3D(concatenatedMatrix);
    }

    @Deprecated
    public Shape3D transform(Shape3D shape) {
        return shape.transform(this);
    }

    @Override
    public ArrayList<Point3D> transformPoints(Collection<Point3D> points) {
        ArrayList<Point3D> retval = new ArrayList<Point3D>(points.size());
        for (Point3D point : points) {
            retval.add(this.transformPoint(point));
        }
        return retval;
    }

    @Override
    public Point3D transformPoint(Point3D point) {
        Point3d retval = new Point3d(point.getX(), point.getY(), point.getZ());
        this.matrix.transform(retval);
        return new Point3D(retval);
    }

    public Vector3D transformVector(Vector3D vector) {
        return new Vector3D(this.transformPoint(new Point3D(vector)));
    }

    public boolean equals(Object other) {
        if (other instanceof AffineTransform3D) {
            Matrix4d otherMatrix = ((AffineTransform3D)other).matrix;
            return Math.abs(this.matrix.m00 - otherMatrix.m00) <= 1.0E-12 && Math.abs(this.matrix.m01 - otherMatrix.m01) <= 1.0E-12 && Math.abs(this.matrix.m02 - otherMatrix.m02) <= 1.0E-12 && Math.abs(this.matrix.m03 - otherMatrix.m03) <= 1.0E-12 && Math.abs(this.matrix.m10 - otherMatrix.m10) <= 1.0E-12 && Math.abs(this.matrix.m11 - otherMatrix.m11) <= 1.0E-12 && Math.abs(this.matrix.m12 - otherMatrix.m12) <= 1.0E-12 && Math.abs(this.matrix.m13 - otherMatrix.m13) <= 1.0E-12 && Math.abs(this.matrix.m20 - otherMatrix.m20) <= 1.0E-12 && Math.abs(this.matrix.m21 - otherMatrix.m21) <= 1.0E-12 && Math.abs(this.matrix.m22 - otherMatrix.m22) <= 1.0E-12 && Math.abs(this.matrix.m23 - otherMatrix.m23) <= 1.0E-12;
        }
        return false;
    }

    static {
        identity.setIdentity();
    }
}

