/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.line;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.JavaGeomMath;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.UnboundedShapeException;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CircleLine2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.domain.ContinuousBoundary2D;
import math.geom2d.domain.Domain2D;
import math.geom2d.domain.GenericDomain2D;
import math.geom2d.domain.SmoothBoundary2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.polygon.Polyline2D;
import math.geom2d.transform.CircleInversion2D;

public class StraightLine2D
extends AbstractLine2D
implements SmoothBoundary2D,
Cloneable,
CircleLine2D {
    private static final long serialVersionUID = 7121417900301006740L;

    public static final StraightLine2D create(java.awt.geom.Point2D point, double angle) {
        return new StraightLine2D(point.getX(), point.getY(), Math.cos(angle), Math.sin(angle));
    }

    public static final StraightLine2D create(java.awt.geom.Point2D p1, java.awt.geom.Point2D p2) {
        return new StraightLine2D(p1, p2);
    }

    public static final StraightLine2D create(java.awt.geom.Point2D origin, Vector2D direction) {
        return new StraightLine2D(origin, direction);
    }

    @Deprecated
    public static final StraightLine2D createStraightLine2D(java.awt.geom.Point2D p1, java.awt.geom.Point2D p2) {
        return new StraightLine2D(p1, p2);
    }

    public static final StraightLine2D createMedian(java.awt.geom.Point2D p1, java.awt.geom.Point2D p2) {
        Point2D mid = Point2D.midPoint(p1, p2);
        StraightLine2D line = StraightLine2D.create(p1, p2);
        return StraightLine2D.createPerpendicular(line, mid);
    }

    @Deprecated
    public static final StraightLine2D createMedian2D(java.awt.geom.Point2D p1, java.awt.geom.Point2D p2) {
        Point2D mid = Point2D.midPoint(p1, p2);
        StraightLine2D line = StraightLine2D.create(p1, p2);
        return StraightLine2D.createPerpendicular(line, mid);
    }

    @Deprecated
    public static final StraightLine2D createStraightLine2D(java.awt.geom.Point2D point, double dx, double dy) {
        return new StraightLine2D(point, dx, dy);
    }

    public static final StraightLine2D createParallel(LinearShape2D line, java.awt.geom.Point2D point) {
        return new StraightLine2D(line, point);
    }

    @Deprecated
    public static final StraightLine2D createParallelLine2D(LinearShape2D line, java.awt.geom.Point2D point) {
        return new StraightLine2D(line, point);
    }

    public static final StraightLine2D createParallel(LinearShape2D linear, double d) {
        StraightLine2D line = linear.getSupportingLine();
        double dd = JavaGeomMath.hypot(line.dx, line.dy);
        return new StraightLine2D(line.x0 + line.dy * d / dd, line.y0 - line.dx * d / dd, line.dx, line.dy);
    }

    @Deprecated
    public static final StraightLine2D createParallelLine2D(LinearShape2D linear, double d) {
        StraightLine2D line = linear.getSupportingLine();
        double dd = JavaGeomMath.hypot(line.dx, line.dy);
        return new StraightLine2D(line.x0 + line.dy * d / dd, line.y0 - line.dx * d / dd, line.dx, line.dy);
    }

    public static final StraightLine2D createPerpendicular(LinearShape2D linear, Point2D point) {
        StraightLine2D line = linear.getSupportingLine();
        return new StraightLine2D(point, -line.dy, line.dx);
    }

    @Deprecated
    public static final StraightLine2D createOrthogonalLine2D(LinearShape2D linear, Point2D point) {
        StraightLine2D line = linear.getSupportingLine();
        return new StraightLine2D(point, -line.dy, line.dx);
    }

    public static final StraightLine2D createCartesian(double a, double b, double c) {
        return new StraightLine2D(a, b, c);
    }

    @Deprecated
    public static final StraightLine2D createCartesianLine2D(double a, double b, double c) {
        return new StraightLine2D(a, b, c);
    }

    public static final Point2D getIntersection(java.awt.geom.Point2D p1, java.awt.geom.Point2D p2, java.awt.geom.Point2D p3, java.awt.geom.Point2D p4) {
        StraightLine2D line1 = new StraightLine2D(p1, p2);
        StraightLine2D line2 = new StraightLine2D(p3, p4);
        return line1.getIntersection(line2);
    }

    @Override
    public boolean containsParametric(double t) {
        return true;
    }

    public StraightLine2D() {
        this(0.0, 0.0, 1.0, 0.0);
    }

    public StraightLine2D(java.awt.geom.Point2D point1, java.awt.geom.Point2D point2) {
        this(point1, new Vector2D(point1, point2));
    }

    public StraightLine2D(java.awt.geom.Point2D point, Vector2D direction) {
        this(point.getX(), point.getY(), direction.getX(), direction.getY());
    }

    public StraightLine2D(java.awt.geom.Point2D point, double dx, double dy) {
        this(point.getX(), point.getY(), dx, dy);
    }

    public StraightLine2D(java.awt.geom.Point2D point, double angle) {
        this(point.getX(), point.getY(), Math.cos(angle), Math.sin(angle));
    }

    public StraightLine2D(LinearShape2D line) {
        super(line);
    }

    public StraightLine2D(double xp, double yp, double dx, double dy) {
        super(xp, yp, dx, dy);
    }

    public StraightLine2D(LinearShape2D line, java.awt.geom.Point2D point) {
        this(point, line.getVector());
    }

    public StraightLine2D(double a, double b, double c) {
        this(0.0, 0.0, 1.0, 0.0);
        double d = a * a + b * b;
        this.x0 = -a * c / d;
        this.y0 = -b * c / d;
        double theta = Math.atan2(-a, b);
        this.dx = Math.cos(theta);
        this.dy = Math.sin(theta);
    }

    @Deprecated
    public void setLine(double x0, double y0, double dx, double dy) {
        this.x0 = x0;
        this.y0 = y0;
        this.dx = dx;
        this.dy = dy;
    }

    @Deprecated
    public void setPoints(double x1, double y1, double x2, double y2) {
        this.x0 = x1;
        this.y0 = y1;
        this.dx = x2 - x1;
        this.dy = y2 - y1;
    }

    @Deprecated
    public void setLine(java.awt.geom.Point2D p1, java.awt.geom.Point2D p2) {
        this.x0 = p1.getX();
        this.y0 = p1.getY();
        this.dx = p2.getX() - this.x0;
        this.dy = p2.getY() - this.y0;
    }

    @Deprecated
    public void setLine(LinearShape2D linear) {
        StraightLine2D line = linear.getSupportingLine();
        this.x0 = line.x0;
        this.y0 = line.y0;
        this.dx = line.dx;
        this.dy = line.dy;
    }

    @Deprecated
    public void setCartesianEquation(double a, double b, double c) {
        this.dx = -b;
        this.dy = a;
        this.x0 = -a * c / (a * a + b * b);
        this.y0 = -b * c / (a * a + b * b);
    }

    public StraightLine2D getParallel(java.awt.geom.Point2D point) {
        return new StraightLine2D(point, this.dx, this.dy);
    }

    @Override
    public StraightLine2D getParallel(double d) {
        double dd = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        return new StraightLine2D(this.x0 + this.dy * d / dd, this.y0 - this.dx * d / dd, this.dx, this.dy);
    }

    @Override
    public StraightLine2D getPerpendicular(Point2D point) {
        return new StraightLine2D(point, -this.dy, this.dx);
    }

    @Override
    public CircleLine2D transform(CircleInversion2D inv) {
        Point2D center = inv.getCenter();
        double r = inv.getRadius();
        Point2D po = this.getProjectedPoint(center);
        double d = this.getDistance(po);
        if (Math.abs(d) < 1.0E-12) {
            return new StraightLine2D(this);
        }
        double angle = Angle2D.getHorizontalAngle(center, po);
        double r2 = r * r / d / 2.0;
        Point2D c2 = Point2D.createPolar(center, r2, angle);
        boolean direct = !this.isInside(center);
        return new Circle2D(c2, r2, direct);
    }

    public Collection<ContinuousBoundary2D> getBoundaryCurves() {
        ArrayList<ContinuousBoundary2D> list = new ArrayList<ContinuousBoundary2D>(1);
        list.add(this);
        return list;
    }

    @Override
    public Domain2D getDomain() {
        return new GenericDomain2D(this);
    }

    @Override
    public void fill(Graphics2D g2) {
        g2.fill(this.getGeneralPath());
    }

    @Override
    public double getWindingAngle(java.awt.geom.Point2D point) {
        double angle1 = Angle2D.getHorizontalAngle(-this.dx, -this.dy);
        double angle2 = Angle2D.getHorizontalAngle(this.dx, this.dy);
        if (this.isInside(point)) {
            if (angle2 > angle1) {
                return angle2 - angle1;
            }
            return Math.PI * 2 - angle1 + angle2;
        }
        if (angle2 > angle1) {
            return angle2 - angle1 - Math.PI * 2;
        }
        return angle2 - angle1;
    }

    @Override
    public Polyline2D getAsPolyline(int n) {
        throw new UnboundedShapeException(this);
    }

    @Override
    public Point2D getFirstPoint() {
        throw new UnboundedShapeException(this);
    }

    @Override
    public Point2D getLastPoint() {
        throw new UnboundedShapeException(this);
    }

    @Override
    public Collection<Point2D> getSingularPoints() {
        return new ArrayList<Point2D>(0);
    }

    @Override
    public boolean isSingular(double pos) {
        return false;
    }

    @Override
    public double getT0() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getT1() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Point2D getPoint(double t) {
        return new Point2D(this.x0 + this.dx * t, this.y0 + this.dy * t);
    }

    public Collection<? extends StraightLine2D> getContinuousCurves() {
        ArrayList<StraightLine2D> list = new ArrayList<StraightLine2D>(1);
        list.add(this);
        return list;
    }

    @Override
    public StraightLine2D getReverseCurve() {
        return new StraightLine2D(this.x0, this.y0, -this.dx, -this.dy);
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        throw new UnboundedShapeException(this);
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public double getDistance(double x, double y) {
        Point2D proj = super.getProjectedPoint(x, y);
        return proj.distance(x, y);
    }

    @Override
    public Box2D getBoundingBox() {
        if (Math.abs(this.dx) < 0.0) {
            return new Box2D(this.x0, this.x0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        if (Math.abs(this.dy) < 0.0) {
            return new Box2D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, this.x0, this.y0);
        }
        return new Box2D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public StraightLine2D transform(AffineTransform2D trans) {
        double[] tab = trans.getCoefficients();
        return new StraightLine2D(this.x0 * tab[0] + this.y0 * tab[1] + tab[2], this.x0 * tab[3] + this.y0 * tab[4] + tab[5], this.dx * tab[0] + this.dy * tab[1], this.dx * tab[3] + this.dy * tab[4]);
    }

    @Override
    public boolean contains(double x, double y) {
        return super.supportContains(x, y);
    }

    @Override
    public boolean contains(java.awt.geom.Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public GeneralPath getGeneralPath() {
        throw new UnboundedShapeException(this);
    }

    public String toString() {
        return new String("StraightLine2D(" + this.x0 + "," + this.y0 + "," + this.dx + "," + this.dy + ")");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StraightLine2D)) {
            return false;
        }
        StraightLine2D line = (StraightLine2D)obj;
        if (Math.abs(this.x0 - line.x0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.y0 - line.y0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.dx - line.dx) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(this.dy - line.dy) > 1.0E-12);
    }

    @Override
    public StraightLine2D clone() {
        return new StraightLine2D(this.x0, this.y0, this.dx, this.dy);
    }
}

