/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.conic;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.UnboundedShapeException;
import math.geom2d.Vector2D;
import math.geom2d.conic.Parabola2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.domain.SmoothOrientedCurve2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;

public class ParabolaArc2D
extends AbstractSmoothCurve2D
implements SmoothOrientedCurve2D,
Cloneable {
    protected Parabola2D parabola = new Parabola2D();
    protected double t0 = -10.0;
    protected double t1 = 10.0;

    public ParabolaArc2D(Parabola2D parabola, double t0, double t1) {
        this.parabola = parabola;
        this.t0 = t0;
        this.t1 = t1;
    }

    public Parabola2D getParabola() {
        return this.parabola;
    }

    @Override
    public double getWindingAngle(java.awt.geom.Point2D point) {
        boolean direct = this.parabola.isDirect();
        boolean inside = this.isInside(point);
        double angle0 = Double.isInfinite(this.t0) ? this.parabola.getAngle() + (double)(direct ? 1 : -1) * Math.PI / 2.0 : Angle2D.getHorizontalAngle(point, this.parabola.getPoint(this.t0));
        double angle1 = Double.isInfinite(this.t1) ? this.parabola.getAngle() + (double)(direct ? 1 : -1) * Math.PI / 2.0 : Angle2D.getHorizontalAngle(point, this.parabola.getPoint(this.t1));
        if (inside) {
            if (angle0 > angle1) {
                return Math.PI * 2 - angle0 + angle1;
            }
            return angle1 - angle0;
        }
        if (angle0 > angle1) {
            return angle1 - angle0;
        }
        return angle1 - angle0 - Math.PI * 2;
    }

    @Override
    public double getSignedDistance(java.awt.geom.Point2D p) {
        return this.getSignedDistance(p.getX(), p.getY());
    }

    @Override
    public double getSignedDistance(double x, double y) {
        if (this.isInside(new Point2D(x, y))) {
            return -this.getDistance(x, y);
        }
        return -this.getDistance(x, y);
    }

    @Override
    public boolean isInside(java.awt.geom.Point2D point) {
        boolean direct = this.parabola.isDirect();
        boolean inside = this.parabola.isInside(point);
        if (inside && direct) {
            return true;
        }
        if (!inside && !direct) {
            return false;
        }
        double pos = this.parabola.project(point);
        if (pos < this.t0) {
            Point2D p0 = this.parabola.getPoint(this.t0);
            Vector2D v0 = this.parabola.getTangent(this.t0);
            StraightLine2D line0 = new StraightLine2D((java.awt.geom.Point2D)p0, v0);
            return line0.isInside(point);
        }
        if (pos > this.t1) {
            Point2D p1 = this.parabola.getPoint(this.t1);
            Vector2D v1 = this.parabola.getTangent(this.t1);
            StraightLine2D line1 = new StraightLine2D((java.awt.geom.Point2D)p1, v1);
            return line1.isInside(point);
        }
        return !direct;
    }

    @Override
    public Vector2D getTangent(double t) {
        return this.parabola.getTangent(t);
    }

    @Override
    public double getCurvature(double t) {
        return this.parabola.getCurvature(t);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public double getT0() {
        return this.t0;
    }

    @Override
    public double getT1() {
        return this.t1;
    }

    @Override
    public Point2D getPoint(double t) {
        t = Math.min(Math.max(t, this.t0), this.t1);
        return this.parabola.getPoint(t);
    }

    @Override
    public double getPosition(java.awt.geom.Point2D point) {
        if (!this.parabola.contains(point)) {
            return Double.NaN;
        }
        double t = this.parabola.getPosition(point);
        if (t - this.t0 < -1.0E-12) {
            return Double.NaN;
        }
        if (this.t1 - t < 1.0E-12) {
            return Double.NaN;
        }
        return t;
    }

    @Override
    public double project(java.awt.geom.Point2D point) {
        double t = this.parabola.project(point);
        return Math.min(Math.max(t, this.t0), this.t1);
    }

    @Override
    public Collection<Point2D> getIntersections(LinearShape2D line) {
        Collection<Point2D> inters0 = this.parabola.getIntersections(line);
        ArrayList<Point2D> inters = new ArrayList<Point2D>();
        for (Point2D point : inters0) {
            double pos = this.parabola.getPosition(point);
            if (!(pos > this.t0) || !(pos < this.t1)) continue;
            inters.add(point);
        }
        return inters;
    }

    @Override
    public ParabolaArc2D getReverseCurve() {
        return new ParabolaArc2D(this.parabola.getReverseCurve(), -this.t1, -this.t0);
    }

    @Override
    public ParabolaArc2D getSubCurve(double t0, double t1) {
        if (t1 < t0) {
            return null;
        }
        t0 = Math.max(this.t0, t0);
        t1 = Math.min(this.t1, t1);
        return new ParabolaArc2D(this.parabola, t0, t1);
    }

    @Override
    public double getDistance(java.awt.geom.Point2D p) {
        return this.getDistance(p.getX(), p.getY());
    }

    @Override
    public double getDistance(double x, double y) {
        return this.getAsPolyline(100).getDistance(x, y);
    }

    @Override
    public boolean isBounded() {
        if (this.t0 == Double.NEGATIVE_INFINITY) {
            return false;
        }
        return this.t1 != Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isEmpty() {
        return this.t1 <= this.t0;
    }

    @Override
    public CurveSet2D<? extends ParabolaArc2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curve2DUtils.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<ParabolaArc2D> result = new CurveArray2D<ParabolaArc2D>(set.getCurveNumber());
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof ParabolaArc2D)) continue;
            result.addCurve((ParabolaArc2D)curve2D);
        }
        return result;
    }

    @Override
    public Box2D getBoundingBox() {
        return this.getAsPolyline(100).getBoundingBox();
    }

    @Override
    public ParabolaArc2D transform(AffineTransform2D trans) {
        Parabola2D par = this.parabola.transform(trans);
        double startPos = Double.isInfinite(this.t0) ? Double.NEGATIVE_INFINITY : par.project(this.getFirstPoint().transform(trans));
        double endPos = Double.isInfinite(this.t1) ? Double.POSITIVE_INFINITY : par.project(this.getLastPoint().transform(trans));
        return new ParabolaArc2D(par, startPos, endPos);
    }

    @Override
    public boolean contains(double x, double y) {
        if (!this.parabola.contains(x, y)) {
            return false;
        }
        double t = this.parabola.getPosition(new Point2D(x, y));
        if (t < this.t0) {
            return false;
        }
        return !(t > this.t1);
    }

    @Override
    public boolean contains(java.awt.geom.Point2D point) {
        return this.contains(point.getX(), point.getY());
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        if (!this.isBounded()) {
            throw new UnboundedShapeException(this);
        }
        Point2D p1 = this.getFirstPoint();
        Point2D p2 = this.getLastPoint();
        Vector2D v1 = this.getTangent(this.getT0());
        Vector2D v2 = this.getTangent(this.getT1());
        StraightLine2D line1 = new StraightLine2D((java.awt.geom.Point2D)p1, v1);
        StraightLine2D line2 = new StraightLine2D((java.awt.geom.Point2D)p2, v2);
        Point2D pc = line1.getIntersection(line2);
        path.quadTo(pc.getX(), pc.getY(), p2.getX(), p2.getY());
        return path;
    }

    public GeneralPath getGeneralPath() {
        if (!this.isBounded()) {
            throw new UnboundedShapeException(this);
        }
        return this.getAsPolyline(32).getGeneralPath();
    }

    public String toString() {
        return String.format("ParabolaArc2D(%f,%f,%f,%f,%f,%f)", this.parabola.xv, this.parabola.yv, this.parabola.a, this.parabola.theta, this.t0, this.t1);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParabolaArc2D)) {
            return false;
        }
        ParabolaArc2D arc = (ParabolaArc2D)obj;
        if (!this.parabola.equals(arc.parabola)) {
            return false;
        }
        if (Math.abs(this.t0 - arc.t0) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(this.t1 - arc.t1) > 1.0E-12);
    }

    @Override
    public ParabolaArc2D clone() {
        return new ParabolaArc2D(this.parabola.clone(), this.t0, this.t1);
    }
}

