/*
 * Decompiled with CFR 0.152.
 */
package math.bsp.algorithm.raycast.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import math.bsp.algorithm.raycast.BspRayCaster;
import math.bsp.algorithm.raycast.internal.BoundaryIntersection;
import math.bsp.node.IConstBspInternalNode;
import math.bsp.node.IConstBspNode;

public class CollisionIterator<TData, TBoundary, TRay, TCollision>
implements Iterator<TCollision> {
    protected BspRayCaster<TData, TBoundary, TRay, TCollision> rayCaster;
    protected TRay ray;
    protected Iterator<TCollision> currentDataCollisionIterator = null;
    protected List<BoundaryIntersection<TData, TBoundary>> intersections = Lists.newArrayList();
    protected Set<TCollision> previousCollision = Sets.newHashSet();
    protected TCollision next;
    protected boolean hasNext;
    protected boolean nextLoaded = false;
    protected double resumeDistanceSquare = 0.0;
    protected double nextIntersectionDistanceSquare = Double.POSITIVE_INFINITY;
    protected Comparator<BoundaryIntersection<TData, TBoundary>> intersectionDistanceComparator = new Comparator<BoundaryIntersection<TData, TBoundary>>(){

        @Override
        public int compare(BoundaryIntersection<TData, TBoundary> lhs, BoundaryIntersection<TData, TBoundary> rhs) {
            return Double.compare(Math.abs(lhs.sideSignedDistanceSquare), Math.abs(rhs.sideSignedDistanceSquare));
        }
    };

    public CollisionIterator(BspRayCaster<TData, TBoundary, TRay, TCollision> rayCaster, TRay ray) {
        this.rayCaster = rayCaster;
        this.ray = ray;
        this.descent(rayCaster.tree.getRoot());
    }

    @Override
    public boolean hasNext() {
        this.loadNext();
        return this.hasNext;
    }

    @Override
    public TCollision next() {
        this.loadNext();
        if (this.hasNext) {
            return this.next;
        }
        throw new NoSuchElementException();
    }

    protected void loadNext() {
        while (!this.nextLoaded) {
            if (this.currentDataCollisionIterator != null && this.currentDataCollisionIterator.hasNext()) {
                this.next = this.currentDataCollisionIterator.next();
                if (this.rayCaster.doDuplicateCollisionsOccur) {
                    if (this.previousCollision.contains(this.next)) continue;
                    this.previousCollision.add(this.next);
                }
                this.hasNext = true;
                this.nextLoaded = true;
                continue;
            }
            if (this.intersections.isEmpty()) {
                this.hasNext = false;
                this.nextLoaded = true;
                continue;
            }
            IConstBspNode<TData, TBoundary> node = this.backtrack();
            this.descent(node);
        }
    }

    protected void descent(IConstBspNode<TData, TBoundary> node) {
        while (node.isInternal()) {
            IConstBspInternalNode<TData, TBoundary> internalNode = node.asInternal();
            double signedDistanceSquare = this.rayCaster.computeSideSignedDistanceSquare(internalNode.getBoundary(), this.ray);
            if (!Double.isInfinite(signedDistanceSquare) && Math.abs(signedDistanceSquare) > this.resumeDistanceSquare) {
                this.intersections.add(new BoundaryIntersection<TData, TBoundary>(internalNode, signedDistanceSquare));
                this.nextIntersectionDistanceSquare = Math.min(this.nextIntersectionDistanceSquare, Math.abs(signedDistanceSquare));
            }
            if (0.0 <= signedDistanceSquare == this.resumeDistanceSquare < Math.abs(signedDistanceSquare)) {
                node = internalNode.getPositiveChild();
                continue;
            }
            node = internalNode.getNegativeChild();
        }
        this.currentDataCollisionIterator = this.rayCaster.getCollisions(this.ray, this.resumeDistanceSquare, this.nextIntersectionDistanceSquare, node.asLeaf().getData()).iterator();
    }

    protected IConstBspNode<TData, TBoundary> backtrack() {
        this.nextIntersectionDistanceSquare = Double.POSITIVE_INFINITY;
        BoundaryIntersection<TData, TBoundary> closestIntersection = Collections.min(this.intersections, this.intersectionDistanceComparator);
        this.resumeDistanceSquare = Math.abs(closestIntersection.sideSignedDistanceSquare);
        Iterator<BoundaryIntersection<TData, TBoundary>> iterator = this.intersections.iterator();
        while (iterator.hasNext()) {
            BoundaryIntersection<TData, TBoundary> intersection = iterator.next();
            if (intersection.node.getDepth() >= closestIntersection.node.getDepth()) {
                iterator.remove();
                continue;
            }
            this.nextIntersectionDistanceSquare = Math.min(this.nextIntersectionDistanceSquare, Math.abs(intersection.sideSignedDistanceSquare));
        }
        return closestIntersection.getFarSideNode();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Unsupported operation: remove()");
    }
}

