/*
 * Decompiled with CFR 0.152.
 */
package math.bsp.algorithm;

import math.bsp.BspOccupation;
import math.bsp.IConstBspTree;
import math.bsp.node.IConstBspInternalNode;
import math.bsp.node.IConstBspLeafNode;
import math.bsp.node.IConstBspNode;

public abstract class BspDataSelector<TVolume, TData, TBoundary> {
    protected IConstBspTree<TData, TBoundary> tree;

    public BspDataSelector(IConstBspTree<TData, TBoundary> tree) {
        this.tree = tree;
    }

    public TData select(TVolume volume) {
        return this.selectAdditionalData(this.tree.getRoot(), null, volume);
    }

    protected TData selectAdditionalData(IConstBspNode<TData, TBoundary> node, TData dataFoundSoFar, TVolume volume) {
        if (node.isLeaf()) {
            IConstBspLeafNode<TData, TBoundary> leafNode = node.asLeaf();
            TData filteredData = this.filterDataByVolume(volume, leafNode.getData());
            return this.tree.getStrategy().joinData(dataFoundSoFar, filteredData);
        }
        IConstBspInternalNode<TData, TBoundary> parentNode = node.asInternal();
        BspOccupation occupation = this.determineVolumeOccupation(parentNode.getBoundary(), volume);
        TData retval = dataFoundSoFar;
        if (occupation.intersectsNegative()) {
            retval = this.selectAdditionalData(parentNode.getNegativeChild(), retval, volume);
        }
        if (occupation.intersectsPositive()) {
            retval = this.selectAdditionalData(parentNode.getPositiveChild(), retval, volume);
        }
        return retval;
    }

    public abstract BspOccupation determineVolumeOccupation(TBoundary var1, TVolume var2);

    protected abstract TData filterDataByVolume(TVolume var1, TData var2);
}

