/*
 * Decompiled with CFR 0.152.
 */
package math.bsp;

import java.io.Serializable;
import math.bsp.IBspStrategy;
import math.bsp.IConstBspTree;
import math.bsp.SplitData;
import math.bsp.node.BspInternalNode;
import math.bsp.node.BspLeafNode;
import math.bsp.node.IBspNode;

public class BspTree<TData, TBoundary>
implements IConstBspTree<TData, TBoundary>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected IBspNode<TData, TBoundary> root;
    protected IBspStrategy<TData, TBoundary> strategy;

    public static <TData, TBoundary> BspTree<TData, TBoundary> make(IBspStrategy<TData, TBoundary> strategy, TData data) {
        BspTree<TData, TBoundary> tree = new BspTree<TData, TBoundary>(strategy);
        tree.addData(data);
        return tree;
    }

    public static <TData, TBoundary> BspTree<TData, TBoundary> make(IBspStrategy<TData, TBoundary> strategy) {
        return BspTree.make(strategy, null);
    }

    public BspTree(IBspStrategy<TData, TBoundary> strategy) {
        this.strategy = strategy;
        this.root = this.makeLeafNode();
    }

    public IConstBspTree<TData, TBoundary> asConst() {
        return this;
    }

    @Override
    public IBspNode<TData, TBoundary> getRoot() {
        return this.root;
    }

    public void setRoot(IBspNode<TData, TBoundary> value) {
        assert (value.getTree() == this);
        this.root = value;
        value.setParent(null);
        this.setDepthRecursively(this.root, 0);
    }

    @Override
    public IBspStrategy<TData, TBoundary> getStrategy() {
        return this.strategy;
    }

    public void addData(TData data) {
        this.addData(this.root, data);
    }

    public void addData(IBspNode<TData, TBoundary> node, TData data) {
        if (data == null) {
            return;
        }
        if (node.isLeaf()) {
            BspLeafNode<TData, TBoundary> leafNode = node.asLeaf();
            TData joinedData = this.strategy.joinData(leafNode.getData(), data);
            leafNode.setData(joinedData);
            this.optimize(leafNode);
        } else {
            BspInternalNode<TData, TBoundary> internalNode = node.asInternal();
            SplitData<TData> splitData = this.strategy.splitData(internalNode.getBoundary(), data);
            this.addData((IBspNode<TData, TBoundary>)internalNode.getPositiveChild(), splitData.positiveData);
            this.addData((IBspNode<TData, TBoundary>)internalNode.getNegativeChild(), splitData.negativeData);
        }
    }

    public void removeData(TData dataToRemove) {
        this.removeData(this.root, dataToRemove);
    }

    public void removeData(IBspNode<TData, TBoundary> node, TData dataToRemove) {
        if (dataToRemove == null) {
            return;
        }
        if (node.isLeaf()) {
            BspLeafNode<TData, TBoundary> leafNode = node.asLeaf();
            TData prunedData = this.strategy.removeData(leafNode.getData(), dataToRemove);
            leafNode.setData(prunedData);
        } else {
            BspInternalNode<TData, TBoundary> internalNode = node.asInternal();
            SplitData<TData> splitDataToRemove = this.strategy.splitData(internalNode.getBoundary(), dataToRemove);
            this.removeData((IBspNode<TData, TBoundary>)internalNode.getPositiveChild(), splitDataToRemove.positiveData);
            this.removeData((IBspNode<TData, TBoundary>)internalNode.getNegativeChild(), splitDataToRemove.negativeData);
        }
    }

    public void optimize(BspLeafNode<TData, TBoundary> nodeToOptimize) {
        Object boundary = null;
        if (this.strategy.shouldSplit(nodeToOptimize)) {
            boundary = this.strategy.findBoundary(nodeToOptimize);
        }
        if (boundary == null) {
            return;
        }
        SplitData<TData> splitData = this.strategy.splitData(boundary, nodeToOptimize.getData());
        BspInternalNode<TData, TBoundary> splitNode = this.makeInternalNode();
        splitNode.setBoundary(boundary);
        BspLeafNode negativeChild = this.makeLeafNode();
        splitNode.setNegativeChild(negativeChild);
        negativeChild.setParent((BspInternalNode)splitNode);
        negativeChild.setData(splitData.negativeData);
        negativeChild.setDepth(splitNode.getDepth() + 1);
        BspLeafNode positiveChild = this.makeLeafNode();
        splitNode.setPositiveChild(positiveChild);
        positiveChild.setParent((BspInternalNode)splitNode);
        positiveChild.setData(splitData.positiveData);
        positiveChild.setDepth(splitNode.getDepth() + 1);
        this.replace(nodeToOptimize, splitNode);
        this.optimize(positiveChild);
        this.optimize(negativeChild);
    }

    public BspLeafNode<TData, TBoundary> makeLeafNode() {
        return new BspLeafNode(this);
    }

    public BspInternalNode<TData, TBoundary> makeInternalNode() {
        return new BspInternalNode(this);
    }

    public void replace(IBspNode<TData, TBoundary> oldNode, IBspNode<TData, TBoundary> newNode) {
        this.setDepthRecursively(newNode, oldNode.getDepth());
        BspInternalNode<TData, TBoundary> parent = oldNode.getParent();
        newNode.setParent(parent);
        if (parent != null) {
            if (parent.getPositiveChild() == oldNode) {
                parent.setPositiveChild(newNode);
            } else {
                parent.setNegativeChild(newNode);
            }
        } else {
            assert (this.root == oldNode);
            this.root = newNode;
        }
    }

    public void clear() {
        this.setRoot(this.makeLeafNode());
    }

    protected void setDepthRecursively(IBspNode<TData, TBoundary> node, int depth) {
        if (node == null) {
            return;
        }
        node.setDepth(depth);
        if (node.isInternal()) {
            this.setDepthRecursively((IBspNode<TData, TBoundary>)node.asInternal().getNegativeChild(), depth + 1);
            this.setDepthRecursively((IBspNode<TData, TBoundary>)node.asInternal().getPositiveChild(), depth + 1);
        }
    }
}

