/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AccUT2004TimeStuckDetector
implements IStuckDetector {
    private static final double NO_MOVEMENT_SIZE = 10.0;
    private static int DEFAULT_TIMEOUT = 3000;
    private static int DEFAULT_WAITING_TIMEOUT = 10000;
    private UT2004Bot bot;
    private double timeout;
    private double waitingTimeout;
    private boolean botWaiting = false;
    private boolean bWasIsStuckCalled = false;
    private long currentTime;
    private String stuckDetails;
    private SelfListener selfListener;
    private EndListener endListener;
    private Double lastMovementTime = null;
    private boolean stuck = false;
    private boolean enabled;
    private Logger log;

    public AccUT2004TimeStuckDetector(UT2004Bot bot) {
        this(bot, DEFAULT_TIMEOUT, DEFAULT_WAITING_TIMEOUT);
    }

    public AccUT2004TimeStuckDetector(UT2004Bot bot, double timeoutMillis, double waitingTimeoutMillis) {
        if (this.log == null) {
            this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        }
        this.bot = bot;
        this.timeout = timeoutMillis;
        this.waitingTimeout = waitingTimeoutMillis;
        this.selfListener = new SelfListener(bot.getWorldView());
        this.endListener = new EndListener(bot.getWorldView());
    }

    public void eventSelf(IWorldObjectEvent<Self> event) {
        if (!this.enabled) {
            return;
        }
        long simTime = event.getObject().getSimTime();
        if (simTime == 0L) {
            return;
        }
        this.currentTime = simTime;
        if (!this.bWasIsStuckCalled) {
            return;
        }
        if (event.getObject().getVelocity().size() > 10.0 || this.lastMovementTime == null) {
            this.lastMovementTime = event.getObject().getSimTime();
        } else {
            this.log.info("Bot not moving. Velocity: " + event.getObject().getVelocity().size());
        }
    }

    public void eventEndMessage(EndMessage event) {
        if (!this.enabled || this.lastMovementTime == null) {
            return;
        }
        this.currentTime = event.getSimTime();
        if (!this.bWasIsStuckCalled) {
            return;
        }
        if (this.botWaiting) {
            if ((double)this.currentTime - this.lastMovementTime >= this.waitingTimeout) {
                this.stuck = true;
                this.stuckDetails = "Bot is WAITING for more than " + this.waitingTimeout + " ms, considering that it has stuck.";
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.stuckDetails);
                }
            }
        } else if ((double)this.currentTime - this.lastMovementTime >= this.timeout) {
            this.stuck = true;
            this.stuckDetails = "Bot should be moving but it is standing still for more than " + this.timeout + " ms, considering that it has stuck.";
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(this.stuckDetails);
            }
        }
    }

    @Override
    public void setEnabled(boolean state) {
        if (this.enabled == state) {
            return;
        }
        this.enabled = state;
    }

    @Override
    public void setBotWaiting(boolean state) {
        this.botWaiting = state;
        this.lastMovementTime = null;
    }

    @Override
    public boolean isStuck() {
        if (!this.bWasIsStuckCalled) {
            this.lastMovementTime = this.currentTime;
            this.bWasIsStuckCalled = true;
            return false;
        }
        return this.stuck;
    }

    @Override
    public void reset() {
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Reset.");
        }
        this.lastMovementTime = Double.NEGATIVE_INFINITY;
        this.bWasIsStuckCalled = false;
        this.stuck = false;
    }

    @Override
    public void setBotTarget(ILocated target) {
    }

    @Override
    public String getStuckDetails() {
        return this.stuckDetails;
    }

    private class EndListener
    implements IWorldEventListener<EndMessage> {
        public EndListener(IWorldView worldView) {
            worldView.addEventListener(EndMessage.class, this);
        }

        @Override
        public void notify(EndMessage event) {
            AccUT2004TimeStuckDetector.this.eventEndMessage(event);
        }
    }

    private class SelfListener
    implements IWorldObjectListener<Self> {
        public SelfListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, this);
        }

        @Override
        public void notify(IWorldObjectEvent<Self> event) {
            AccUT2004TimeStuckDetector.this.eventSelf(event);
        }
    }
}

