/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshClearanceComputer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshModule;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.grounder.NavMeshDropGrounder;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing.BorderPoint;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing.JumpBoundaries;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Vector2d;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;

public class JumpModule {
    public static final double MAX_DOUBLE_JUMP_POWER = 755.0;
    public static final double MAX_SINGLE_JUMP_POWER = 340.0;
    private NavMeshDropGrounder dropGrounder;
    private NavMeshClearanceComputer clearanceComputer;
    private Logger log;
    public static final double MAX_JUMP_HEIGHT = 130.0;
    private static final double MAX_SINGLE_JUMP_HEIGHT = 60.0;
    private static final double NAVMESH_Z_COORD_CORRECTION = 20.0;
    private static final double SPEED_BOOST_DELAY = 0.1;
    private static final double BOT_RADIUS = 70.0;
    private static final double JUMP_PEEK_TIME = 0.39;
    private static final int BOUNDARY_THRESHOLD = 50;
    private static final double JUMP_SPEED_BOOST = 1.08959;

    public JumpModule(NavMeshModule navMeshModule, Logger log) {
        this.dropGrounder = navMeshModule.getDropGrounder();
        this.clearanceComputer = navMeshModule.getClearanceComputer();
        this.log = log;
    }

    public JumpBoundaries computeJumpBoundaries(NavPointNeighbourLink jumpLink) {
        boolean borderToBorder;
        if (jumpLink == null) {
            return new JumpBoundaries(null);
        }
        NavPoint startNavPoint = jumpLink.getFromNavPoint();
        NavPoint endNavPoint = jumpLink.getToNavPoint();
        Location startLocation = startNavPoint.getLocation();
        Location endLocation = endNavPoint.getLocation();
        Location linkDirection3d = endLocation.sub(startLocation);
        Vector2d linkDirection = new Vector2d(linkDirection3d.x, linkDirection3d.y);
        BorderPoint startBorder = this.getBorderPoint(startLocation, endLocation);
        Location startBorderPoint = startBorder.getPoint();
        Vector2d negatedLinkDirection = new Vector2d(linkDirection);
        negatedLinkDirection.negate();
        BorderPoint endBorderPoint = this.getBorderPoint(endLocation, startLocation);
        if (!endBorderPoint.getPoint().equals(endNavPoint.getLocation(), 1.0)) {
            endBorderPoint.setPoint(endBorderPoint.getPoint().addZ(20.0));
        }
        if (!(borderToBorder = this.isJumpable(startBorderPoint, endBorderPoint.getPoint(), 439.5))) {
            return new JumpBoundaries(jumpLink);
        }
        Location testBoundary = startLocation;
        Location currentBoundary = startBorderPoint;
        boolean boundaryFound = false;
        double distanceToSearch = 0.0;
        do {
            boolean isJumpable;
            if ((isJumpable = this.isJumpable(testBoundary, endBorderPoint.getPoint(), 439.5)) && distanceToSearch < 50.0) {
                currentBoundary = testBoundary;
                boundaryFound = true;
                continue;
            }
            if (isJumpable) {
                currentBoundary = testBoundary;
                testBoundary = this.getNavMeshPoint(testBoundary, startLocation, distanceToSearch /= 2.0);
                continue;
            }
            if (distanceToSearch < 50.0 && distanceToSearch > 0.0) {
                boundaryFound = true;
                continue;
            }
            if (distanceToSearch == 0.0) {
                distanceToSearch = testBoundary.getDistance2D(startBorderPoint);
            }
            testBoundary = this.getNavMeshPoint(testBoundary, startBorderPoint, distanceToSearch /= 2.0);
        } while (!boundaryFound);
        return new JumpBoundaries(jumpLink, currentBoundary, startBorderPoint, startBorder.getDirection(), endBorderPoint.getPoint(), endBorderPoint.getDirection(), endLocation);
    }

    public BorderPoint getBorderPoint(Location start, Location end) {
        Vector2D direction = new Vector2D(new Point2D(start.x, start.y), new Point2D(end.x, end.y));
        NavMeshClearanceComputer.ClearanceLimit clearanceLimit = this.clearanceComputer.findEdge(start, direction, direction.getNorm(), 100.0);
        if (clearanceLimit == null) {
            return new BorderPoint(end, null);
        }
        if (clearanceLimit.getLocation() == start) {
            return new BorderPoint(start, null);
        }
        return new BorderPoint(clearanceLimit.getLocation().addZ(NavMeshConstants.liftPolygonLocation), null);
    }

    public boolean needsJump(NavPointNeighbourLink link) {
        if (link == null) {
            return false;
        }
        if ((link.getFlags() & LinkFlag.JUMP.get()) != 0) {
            return true;
        }
        if (link.isForceDoubleJump()) {
            return true;
        }
        return link.getNeededJump() != null;
    }

    public Double computeJump(Location start, JumpBoundaries boundaries, double velocity, double jumpAngleCos) {
        Location collisionLocation;
        int jumpKoef;
        Location end = boundaries.getLandingTarget();
        double distance2d = this.getDistance2D(start, boundaries.getLandingTarget(), jumpAngleCos);
        double targetZ = end.z - start.z;
        this.debug("Jump {0} --(D3D:{1}|D2D:{2}|D2DC:{3}|DZ:{4})--> {5} [Velocity {6}]", start, end.getDistance(start), end.getDistance2D(start), distance2d, targetZ, end, velocity);
        double timeToPassDistance = this.getTimeToPassDistance(distance2d, velocity) - 0.055;
        Double force = this.computeJump(targetZ, timeToPassDistance, jumpAngleCos);
        double originalTime = timeToPassDistance;
        int n = jumpKoef = originalTime > 0.39 ? 2 : 1;
        if (force.equals(Double.NaN) && timeToPassDistance < (double)jumpKoef * 0.39 && targetZ > 0.0) {
            force = this.getPowerForJumpByZDiff(targetZ);
        }
        if (force.equals(Double.NaN) || force < 0.0) {
            return force;
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.debug("Computed force before collision adjustment: {0}", force);
        }
        if ((collisionLocation = this.getCollisionLocation(boundaries)) == null) {
            return force;
        }
        double collisionDistance = this.getDistance2D(start, collisionLocation, jumpAngleCos);
        double timeToCollision = this.getTimeToPassDistance(collisionDistance, velocity);
        double collidingTime = 0.39 * (double)(force <= 340.0 ? 1 : 2) - timeToCollision;
        if (collidingTime > 0.0) {
            Location edgeDirection = boundaries.getTargetEdgeDirection().setZ(0.0).getNormalized();
            Location computedDirection = boundaries.getLandingTarget().sub(boundaries.getTakeOffMax()).setZ(0.0).getNormalized();
            Location verticalDirection = new Location(edgeDirection.y, -edgeDirection.x);
            double angleCos = verticalDirection.dot(computedDirection);
            double collisionCoef = 1.0 + collidingTime / 0.39 * (1.0 - angleCos);
            force = Math.min(755.0, force * collisionCoef);
            this.debug("Possible jump collision detected, adjusting power. NEW POWER: {0}, Angle cos: {1}, Colliding time: {2}", force, angleCos, collidingTime);
        }
        return force;
    }

    public Double computeJump(double targetZ, double timeToPassDistance, double jumpAngleCos) {
        if (!this.isJumpable(timeToPassDistance, targetZ)) {
            this.debug("We are not able to jump there! Time: {0} Z: {1}", timeToPassDistance, targetZ);
            return Double.NaN;
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.debug("Computing jump. Time to pass the distance: {0}", timeToPassDistance);
        }
        Double power = Double.NaN;
        if (this.isSingleJumpable(timeToPassDistance, targetZ)) {
            this.debug("Computing jump. Single jump should suffice.");
            power = this.getSingleJumpPower(targetZ, timeToPassDistance);
        }
        if (power.equals(Double.NaN)) {
            this.debug("Computing jump. Double jump will be needed.");
            power = this.getDoubleJumpPower(targetZ, timeToPassDistance, 0.39);
        }
        return power;
    }

    public Double computeFall(Location start, JumpBoundaries boundaries, double velocity, double jumpAngleCos) {
        Location collisionLocation;
        int jumpKoef;
        Location end = boundaries.getLandingTarget();
        double distance2D = this.getDistance2D(start, boundaries.getLandingTarget(), jumpAngleCos);
        double targetZ = end.z - start.z;
        this.debug("Fall {0} --(D3D:{1}|D2D:{2}|D2DC:{3}|DZ:{4})--> {5} [Velocity {6}]", start, end.getDistance(start), end.getDistance2D(start), distance2D, targetZ, end, velocity);
        double fallSpeed = 430.0;
        double fallTime = Math.abs(targetZ) / fallSpeed;
        double fallDistance2D = velocity * fallTime;
        double remainingDistance2D = distance2D - fallDistance2D;
        if (remainingDistance2D < 0.0) {
            this.debug("Remaining distance after fall " + (int)remainingDistance2D + " < 0 => perform only small jump");
            return 110.0;
        }
        double timeToPassDistance = this.getTimeToPassDistance(distance2D, velocity) - 0.055;
        Double force = this.computeFall(targetZ, timeToPassDistance, jumpAngleCos);
        double originalTime = timeToPassDistance;
        int n = jumpKoef = originalTime > 0.39 ? 2 : 1;
        if (force.equals(Double.NaN) && timeToPassDistance < (double)jumpKoef * 0.39 && targetZ > 0.0) {
            force = this.getPowerForJumpByZDiff(targetZ);
        }
        if (force.equals(Double.NaN) || force < 0.0) {
            return force;
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.debug("Computed force before collision adjustment: {0}", force);
        }
        if ((collisionLocation = this.getCollisionLocation(boundaries)) == null) {
            return force;
        }
        double collisionDistance = this.getDistance2D(start, collisionLocation, jumpAngleCos);
        double timeToCollision = this.getTimeToPassDistance(collisionDistance, velocity);
        double collidingTime = 0.39 * (double)(force <= 340.0 ? 1 : 2) - timeToCollision;
        if (collidingTime > 0.0) {
            Location edgeDirection = boundaries.getTargetEdgeDirection().setZ(0.0).getNormalized();
            Location computedDirection = boundaries.getLandingTarget().sub(boundaries.getTakeOffMax()).setZ(0.0).getNormalized();
            Location verticalDirection = new Location(edgeDirection.y, -edgeDirection.x);
            double angleCos = verticalDirection.dot(computedDirection);
            double collisionCoef = 1.0 + collidingTime / 0.39 * (1.0 - angleCos);
            force = Math.min(755.0, force * collisionCoef);
            this.debug("Possible jump collision detected, adjusting power. NEW POWER: {0}, Angle cos: {1}, Colliding time: {2}", force, angleCos, collidingTime);
        }
        return force;
    }

    public Double computeFall(double targetZ, double timeToPassDistance, double jumpAngleCos) {
        if (!this.isJumpable(timeToPassDistance, targetZ)) {
            this.debug("We are not able to jump there! Time: {0} Z: {1}", timeToPassDistance, targetZ);
            return Double.NaN;
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.debug("Computing jump. Time to pass the distance: {0}", timeToPassDistance);
        }
        Double power = Double.NaN;
        if (this.isSingleJumpable(timeToPassDistance, targetZ)) {
            this.debug("Computing jump. Single jump should suffice.");
            power = this.getSingleJumpPower(targetZ, timeToPassDistance);
        }
        if (power.equals(Double.NaN)) {
            this.debug("Computing jump. Double jump will be needed.");
            power = this.getDoubleJumpPower(targetZ, timeToPassDistance, 0.39);
        }
        return power;
    }

    private double getDistance2D(Location start, Location end, double jumpAngleCos) {
        double distance2d = start.getDistance2D(end);
        if (jumpAngleCos > 0.0) {
            distance2d = start.getDistance2D(end) / jumpAngleCos;
        }
        return distance2d;
    }

    public boolean isJumpable(Location start, Location end, double velocity) {
        if (start == null || end == null) {
            return false;
        }
        if (end.z - start.z > 130.0) {
            return false;
        }
        double distance2d = start.getDistance2D(end);
        return this.isJumpable(distance2d, velocity, end.z - start.z);
    }

    private boolean isJumpable(double distance2d, double velocity, double zDiff) {
        double timeToPassDistance = this.getTimeToPassDistance(distance2d, velocity);
        return this.isJumpable(timeToPassDistance, zDiff);
    }

    private boolean isJumpable(double timeToPassDistance, double zDiff) {
        double maxTime = 0.78;
        double computedZDiff = timeToPassDistance < maxTime ? 130.0 : this.getZDiffForJump(755.0, timeToPassDistance, true, 0.39);
        return computedZDiff >= zDiff;
    }

    private double getTimeToPassDistance(double distance2d, double velocity) {
        if (distance2d < velocity * 0.1) {
            return distance2d / velocity;
        }
        return 0.1 + (distance2d - velocity * 0.1) / (velocity * 1.08959);
    }

    private double getZDiffForJump(double power, double deltaTime, boolean isDoubleJump, double delay) {
        double z = 0.0;
        z += -475.0 * (deltaTime * deltaTime) + Math.min(power, 340.0) * deltaTime;
        if (isDoubleJump) {
            z += ((power - 340.0) * 1.066 + 2.0) * (deltaTime - delay);
        }
        return z;
    }

    private double getSingleJumpPower(double targetZ, double time2) {
        double power = (targetZ + 475.0 * time2 * time2) / time2;
        if (power > 340.0) {
            return Double.NaN;
        }
        return power;
    }

    private double getDoubleJumpPower(double targetZ, double time2, double delay) {
        double power = 0.0;
        if (time2 < delay) {
            this.debug("Computing double jump power. Time is lower than delay, postponing result.");
            power = this.getPowerForJumpByZDiff(targetZ);
            if (power < 0.0) {
                return power;
            }
            return Double.NaN;
        }
        power = (targetZ + 475.0 * time2 * time2 + 20.0 * time2 - 140.0) / (1.066 * (time2 - delay));
        this.debug("Computing double jump power. targetZ: {0}, Time: {1}, Delay: {2}, POWER: {3}", targetZ, time2, delay, power);
        if (power > 755.0) {
            return Double.NaN;
        }
        return power;
    }

    private Location getNavMeshPoint(Location from, Location direction, double distance) {
        return from.interpolate(direction, distance / from.getDistance2D(direction));
    }

    private boolean isSingleJumpable(double timeToPassDistance, double zDiff) {
        if (zDiff > 60.0) {
            return false;
        }
        if (timeToPassDistance < 0.39) {
            return true;
        }
        double computedZDiff = this.getZDiffForJump(340.0, timeToPassDistance, false, 0.0);
        return computedZDiff >= zDiff;
    }

    public Location getCollisionLocation(JumpBoundaries boundaries) {
        if (!boundaries.isJumpUp()) {
            return null;
        }
        if (boundaries.getTargetEdgeDirection() == null) {
            return null;
        }
        Location edgeDirection = boundaries.getTargetEdgeDirection().setZ(0.0).getNormalized();
        Location computedDirection = boundaries.getLandingTarget().sub(boundaries.getTakeOffMax()).setZ(0.0).getNormalized();
        Location verticalDirection = new Location(edgeDirection.y, -edgeDirection.x);
        double angleCos = verticalDirection.dot(computedDirection);
        double xAngle = edgeDirection.dot(computedDirection);
        if (Math.abs(xAngle) < Math.cos(1.0471975511965976)) {
            this.debug("Computing collision. Ignoring collision. Edge to mesh angle cos: {0}", xAngle);
            return null;
        }
        this.debug("Computing collision. Angle cos: {0}", angleCos);
        double correctionDistance = 140.0 / angleCos;
        double koef = correctionDistance / boundaries.getLandingTarget().getDistance2D(boundaries.getTakeOffMax());
        Location collisionLocation = koef > 1.0 ? boundaries.getTakeOffMax() : boundaries.getLandingTarget().interpolate(boundaries.getTakeOffMax(), koef);
        return collisionLocation;
    }

    public double getCorrectedVelocity(double velocity, boolean isAccelerating) {
        if (!isAccelerating) {
            return velocity;
        }
        return Math.min(439.5, 0.9788 * velocity + 111.0);
    }

    public double getCorrectedAngle(double angleCos, boolean isFirstStep) {
        if (isFirstStep) {
            return angleCos;
        }
        return Math.cos(Math.acos(angleCos) / 2.0);
    }

    private double getPowerForJumpByZDiff(double zDiff) {
        if ((zDiff += 5.0) < 60.0) {
            return 3.87 * zDiff + 111.0;
        }
        return 3.136 * zDiff + 287.0;
    }

    private void debug(String msg) {
        this.log.finer("      +-- " + msg);
    }

    private void debug(String msg, Object ... objects) {
        this.log.log(Level.FINER, "      +-- " + msg, objects);
    }
}

