/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer;

import com.google.common.base.Predicate;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer.IPathTraceContext;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer.RayPath;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer.XyProjectionNavMeshPathTraceContext;
import java.awt.geom.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.Ray2D;
import math.geom3d.line.LineSegment3D;

public class NavMeshPathTracer {
    public static RayPath<NavMeshPolygon, NavMeshEdge> trace(NavMeshPolygon startPolygon, Location start, Vector2D direction2d, Predicate<RayPath<NavMeshPolygon, NavMeshEdge>> keepGoingCondition) {
        return NavMeshPathTracer.trace(startPolygon, start, direction2d, XyProjectionNavMeshPathTraceContext.getInstance(), keepGoingCondition);
    }

    public static <TPolygon, TEdge> RayPath<TPolygon, TEdge> trace(TPolygon startPolygon, Location start, Vector2D direction2d, IPathTraceContext<TPolygon, TEdge> context, Predicate<RayPath<TPolygon, TEdge>> keepGoingCondition) {
        RayPath<TPolygon, Object> rayPath = new RayPath<TPolygon, Object>(startPolygon);
        math.geom2d.Point2D start2d = context.project(start);
        Ray2D ray = new Ray2D(start2d, start2d.plus(direction2d));
        TPolygon currentPolygon = startPolygon;
        Object previousPolygon = null;
        do {
            Object intersectingEdge = null;
            AbstractLine2D intersectingEdge2d = null;
            math.geom2d.Point2D intersection2d = null;
            for (TEdge edge : context.getEdges(currentPolygon)) {
                LineSegment2D edge2d;
                if (previousPolygon != null && previousPolygon.equals(context.getAdjacentPolygonByEdge(currentPolygon, edge)) || (intersection2d = ray.getIntersection(edge2d = new LineSegment2D((Point2D)context.project(context.getSourceVertex(edge)), context.project(context.getDestinationVertex(edge))))) == null) continue;
                intersectingEdge = edge;
                intersectingEdge2d = edge2d;
                break;
            }
            assert (intersectingEdge != null);
            assert (intersectingEdge2d != null);
            assert (intersection2d != null);
            LineSegment3D edge3d = new LineSegment3D(context.getSourceVertex(intersectingEdge).asPoint3D(), context.getDestinationVertex(intersectingEdge).asPoint3D());
            Location intersection = new Location(edge3d.getPoint(intersectingEdge2d.project(intersection2d)));
            previousPolygon = currentPolygon;
            currentPolygon = context.getAdjacentPolygonByEdge(currentPolygon, intersectingEdge);
            rayPath.addStep(intersection, intersectingEdge, currentPolygon);
        } while (currentPolygon != null && keepGoingCondition.apply(rayPath));
        return rayPath;
    }
}

