/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.grounder;

import com.google.common.base.Function;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.grounder.INavMeshGrounder;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.INavMeshAtom;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import java.util.ArrayList;
import java.util.List;
import math.bsp.BspOccupation;
import math.bsp.IConstBspTree;
import math.bsp.algorithm.BspDataSelector;
import math.geom2d.Point2D;
import math.geom2d.line.StraightLine2D;
import math.geom3d.Point3D;
import math.geom3d.Vector3D;
import math.geom3d.line.StraightLine3D;
import math.geom3d.polygon.SimplePlanarPolygon3D;

public class NavMeshDropGrounder
implements INavMeshGrounder {
    public static final double DEFAULT_GROUND_DISTANCE = 100.0;
    protected NavMesh navMesh;
    protected Function<NavMeshPolygon, SimplePlanarPolygon3D> shapeToPolygonFunction = new Function<NavMeshPolygon, SimplePlanarPolygon3D>(){

        @Override
        public SimplePlanarPolygon3D apply(NavMeshPolygon polygon) {
            return polygon.getShape();
        }
    };

    public NavMeshDropGrounder(NavMesh navMesh) {
        this.navMesh = navMesh;
    }

    @Override
    public NavMeshPolygon tryGround(ILocated located) {
        return NavMeshDropGrounder.getPolygonBelow(located.getLocation(), this.navMesh.getXyProjectionBsp(), this.shapeToPolygonFunction);
    }

    @Override
    public INavMeshAtom forceGround(ILocated located) {
        NavMeshPolygon retval = NavMeshDropGrounder.getPolygonBelow(located.getLocation(), this.navMesh.getXyProjectionBsp(), this.shapeToPolygonFunction);
        if (retval != null) {
            return retval;
        }
        return DistanceUtils.getNearest(this.navMesh.getAtoms(), located);
    }

    public NavMeshPolygon getPolygonBelow(Location location) {
        return NavMeshDropGrounder.getPolygonBelow(location, 100.0, this.navMesh.getXyProjectionBsp(), this.shapeToPolygonFunction);
    }

    public NavMeshPolygon getPolygonBelow(Location location, double maxDropDistance) {
        return NavMeshDropGrounder.getPolygonBelow(location, maxDropDistance, this.navMesh.getXyProjectionBsp(), this.shapeToPolygonFunction);
    }

    public static <PolygonElement> PolygonElement getPolygonBelow(Location location, IConstBspTree<ArrayList<PolygonElement>, StraightLine2D> xyProjectionBsp, Function<PolygonElement, SimplePlanarPolygon3D> polygonToShape) {
        return NavMeshDropGrounder.getPolygonBelow(location, 100.0, xyProjectionBsp, polygonToShape);
    }

    public static <PolygonElement> PolygonElement getPolygonBelow(Location location, double maxDropDistance, IConstBspTree<ArrayList<PolygonElement>, StraightLine2D> xyProjectionBsp, Function<PolygonElement, SimplePlanarPolygon3D> polygonToShape) {
        Point3D point = location.asPoint3D();
        StraightLine3D gravityLine = new StraightLine3D(point, point.plus(new Vector3D(0.0, 0.0, -1.0)));
        BspDataSelector selectorByLocation = new BspDataSelector<Location, ArrayList<PolygonElement>, StraightLine2D>((IConstBspTree)xyProjectionBsp){

            @Override
            public BspOccupation determineVolumeOccupation(StraightLine2D boundary, Location volume) {
                Point2D point = new Point2D(volume.getX(), volume.getY());
                if (boundary.getSignedDistance(point) >= 0.0) {
                    return BspOccupation.POSITIVE;
                }
                return BspOccupation.NEGATIVE;
            }

            @Override
            protected ArrayList<PolygonElement> filterDataByVolume(Location volume, ArrayList<PolygonElement> data) {
                return data;
            }
        };
        List candidates = (List)selectorByLocation.select(location);
        PolygonElement bestCandidate = null;
        double bestDropDistance = Double.POSITIVE_INFINITY;
        for (Object candidate : candidates) {
            double dropDistance;
            Point3D gravityLineIntersection;
            SimplePlanarPolygon3D polygon = polygonToShape.apply(candidate);
            if (polygon.getDistance(gravityLineIntersection = gravityLine.getPlaneIntersection(polygon.getPlane())) > 1.0E-12 || (dropDistance = point.getZ() - gravityLineIntersection.getZ()) < -100.0 || maxDropDistance < dropDistance || !(dropDistance < bestDropDistance)) continue;
            bestDropDistance = dropDistance;
            bestCandidate = (PolygonElement)candidate;
        }
        return bestCandidate;
    }
}

