/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.file;

import com.google.common.collect.Lists;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RawNavMeshFile {
    public static final String VERTEX_ENTRY_TYPE = "v";
    public static final String POLYGON_ENTRY_TYPE = "p";
    public ArrayList<Location> vertices = Lists.newArrayList();
    public ArrayList<ArrayList<Integer>> polygons = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawNavMeshFile(File file) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            this.parseFile(br);
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    protected void parseFile(BufferedReader br) throws IOException {
        String line = br.readLine();
        while (line != null) {
            ArrayList<String> tokens = Lists.newArrayList(Arrays.asList(line.split("[ \\t]")));
            String entryType = tokens.remove(0);
            this.parseEntry(entryType, tokens, line);
            line = br.readLine();
        }
    }

    protected void parseEntry(String entryType, List<String> tokens, String line) throws IOException {
        if (entryType.equals(VERTEX_ENTRY_TYPE)) {
            this.parseVertexEntry(tokens, line);
        } else if (entryType.equals(POLYGON_ENTRY_TYPE)) {
            this.parsePolygonEntry(tokens, line);
        } else if (entryType != "" || tokens.size() != 1) {
            throw new IOException("Invalid file format - unrecognized entry: " + line);
        }
    }

    protected void parseVertexEntry(List<String> tokens, String line) throws IOException {
        if (tokens.size() != 3) {
            throw new IOException("Invalid file format - vertex entry should contain exactly three coordinates: " + line);
        }
        try {
            this.vertices.add(new Location(Double.parseDouble(tokens.get(0)), Double.parseDouble(tokens.get(1)), Double.parseDouble(tokens.get(2))));
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid file format - unreadable coordinate: " + line, e);
        }
    }

    protected void parsePolygonEntry(List<String> tokens, String line) throws IOException {
        ArrayList<Integer> polygon = Lists.newArrayList();
        for (String token : tokens) {
            int vertexIndex;
            try {
                vertexIndex = Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid file format - unreadable vertex: " + token + " in polygon entry: " + line);
            }
            if (vertexIndex < 0 || this.vertices.size() <= vertexIndex) {
                throw new IOException("Invalid file format - bad vertex index " + vertexIndex + " in polygon entry: " + line);
            }
            polygon.add(vertexIndex);
        }
        this.polygons.add(polygon);
    }
}

