/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.inject.internal.Lists;
import com.google.inject.internal.Sets;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004EdgeChecker;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.LineSegmentAnalysis;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.NavMeshBoundaryInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.PolygonAnalysis;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer.IPathTraceContext;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer.NavMeshPathTracer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer.RayPath;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;

public class NavGraphAnalysis {
    protected HashMap<Integer, ArrayList<NavPoint>> polygonIdToOffMeshPointsMap = Maps.newHashMap();
    public HashMap<NavPoint, NavPointInfo> navPointToInfoMap = Maps.newHashMap();
    public HashSet<NavPoint> offMeshNavPoints = Sets.newHashSet();
    public HashSet<NavPointNeighbourLink> offMeshNavLinks = Sets.newHashSet();

    public NavGraphAnalysis(Map<UnrealId, NavPoint> navGraph, PolygonAnalysis polygonAnalysis, LineSegmentAnalysis lineSegmentAnalysis) {
        Integer polygonId;
        for (NavPoint navPoint : navGraph.values()) {
            polygonId = null;
            if (!navPoint.isLiftCenter()) {
                polygonId = polygonAnalysis.getPolygonIdBelow(navPoint.getLocation());
            }
            if (polygonId == null) {
                this.offMeshNavPoints.add(navPoint);
                continue;
            }
            this.getNavPointInfo((NavPoint)navPoint).polygonId = polygonId;
        }
        for (NavPoint navPoint : navGraph.values()) {
            for (NavPointNeighbourLink link : navPoint.getOutgoingEdges().values()) {
                if (!UT2004EdgeChecker.checkLink(link) || !this.isOffMeshEdge(link, polygonAnalysis, lineSegmentAnalysis)) continue;
                this.offMeshNavLinks.add(link);
                this.offMeshNavPoints.add(link.getFromNavPoint());
                this.offMeshNavPoints.add(link.getToNavPoint());
            }
        }
        for (NavPoint navPoint : this.offMeshNavPoints) {
            this.getNavPointInfo((NavPoint)navPoint).isOffMeshPoint = true;
            polygonId = this.getNavPointInfo((NavPoint)navPoint).polygonId;
            if (polygonId == null) continue;
            this.getOffMeshPointsByPolygonId(polygonId).add(navPoint);
        }
        for (NavPointNeighbourLink link : this.offMeshNavLinks) {
            this.getNavPointInfo((NavPoint)link.getFromNavPoint()).outgoingOffMeshEdges.add(link);
            this.getNavPointInfo((NavPoint)link.getToNavPoint()).incommingOffMeshEdges.add(link);
        }
    }

    public ArrayList<NavPoint> getOffMeshPointsByPolygonId(int polygonId) {
        if (!this.polygonIdToOffMeshPointsMap.containsKey(polygonId)) {
            this.polygonIdToOffMeshPointsMap.put(polygonId, new ArrayList());
        }
        return this.polygonIdToOffMeshPointsMap.get(polygonId);
    }

    protected boolean isOffMeshEdge(NavPointNeighbourLink link, PolygonAnalysis polygonAnalysis, LineSegmentAnalysis lineSegmentAnalysis) {
        NavPoint fromNav = link.getFromNavPoint();
        NavPoint toNav = link.getToNavPoint();
        Integer startPolygonId = this.getNavPointInfo((NavPoint)fromNav).polygonId;
        final Integer destinationPolygonId = this.getNavPointInfo((NavPoint)toNav).polygonId;
        if (startPolygonId == null || destinationPolygonId == null) {
            return true;
        }
        Location direction3d = toNav.getLocation().sub(fromNav.getLocation());
        Vector2D direction = new Vector2D(direction3d.x, direction3d.y);
        AnalysisPathTracingContext pathTracingContext = new AnalysisPathTracingContext(polygonAnalysis, lineSegmentAnalysis);
        Predicate<RayPath<Integer, EdgeDescriptor>> keepTracingPredicate = new Predicate<RayPath<Integer, EdgeDescriptor>>(){

            @Override
            public boolean apply(RayPath<Integer, EdgeDescriptor> rayPath) {
                return !rayPath.asPolygons().contains(destinationPolygonId);
            }
        };
        RayPath<Integer, EdgeDescriptor> rayPath = NavMeshPathTracer.trace(startPolygonId, fromNav.getLocation(), direction, pathTracingContext, keepTracingPredicate);
        return !rayPath.asPolygons().contains(destinationPolygonId);
    }

    public NavPointInfo getNavPointInfo(NavPoint navPoint) {
        if (!this.navPointToInfoMap.containsKey(navPoint)) {
            this.navPointToInfoMap.put(navPoint, new NavPointInfo());
        }
        return this.navPointToInfoMap.get(navPoint);
    }

    protected class AnalysisPathTracingContext
    implements IPathTraceContext<Integer, EdgeDescriptor> {
        protected PolygonAnalysis polygonAnalysis;
        protected LineSegmentAnalysis lineSegmentAnalysis;

        public AnalysisPathTracingContext(PolygonAnalysis polygonAnalysis, LineSegmentAnalysis lineSegmentAnalysis) {
            this.polygonAnalysis = polygonAnalysis;
            this.lineSegmentAnalysis = lineSegmentAnalysis;
        }

        @Override
        public List<EdgeDescriptor> getEdges(Integer polygon) {
            ArrayList<EdgeDescriptor> retval = Lists.newArrayList();
            for (int i = 0; i < this.polygonAnalysis.polygonIdToInfoMap.get((Object)polygon).vertexIds.size(); ++i) {
                retval.add(new EdgeDescriptor(polygon, i));
            }
            return retval;
        }

        @Override
        public Location getSourceVertex(EdgeDescriptor edge) {
            PolygonAnalysis.PolygonInfo polygonInfo = this.polygonAnalysis.polygonIdToInfoMap.get(edge.getPolygonId());
            int vertexId = polygonInfo.vertexIds.get(edge.getEdgeIndex());
            return this.polygonAnalysis.vertexIdToInfoMap.get((Object)Integer.valueOf((int)vertexId)).location;
        }

        @Override
        public Location getDestinationVertex(EdgeDescriptor edge) {
            PolygonAnalysis.PolygonInfo polygonInfo = this.polygonAnalysis.polygonIdToInfoMap.get(edge.getPolygonId());
            int vertexId = polygonInfo.vertexIds.get((edge.getEdgeIndex() + 1) % polygonInfo.vertexIds.size());
            return this.polygonAnalysis.vertexIdToInfoMap.get((Object)Integer.valueOf((int)vertexId)).location;
        }

        @Override
        public Integer getAdjacentPolygonByEdge(Integer polygon, EdgeDescriptor edge) {
            NavMeshBoundaryInfo boundaryInfo = this.lineSegmentAnalysis.getPolygonInfo((int)polygon.intValue()).edgeIndexToBoundaryInfoMap.get(edge.edgeIndex);
            if (boundaryInfo == null) {
                return null;
            }
            if (boundaryInfo.polygonAId != polygon) {
                return boundaryInfo.polygonAId;
            }
            return boundaryInfo.polygonBId;
        }

        @Override
        public Point2D project(Location location) {
            return new Point2D(location.getX(), location.getY());
        }
    }

    protected class EdgeDescriptor {
        protected int polygonId;
        protected int edgeIndex;

        public EdgeDescriptor(int polygonId, int edgeIndex) {
            this.polygonId = polygonId;
            this.edgeIndex = edgeIndex;
        }

        public int getPolygonId() {
            return this.polygonId;
        }

        public int getEdgeIndex() {
            return this.edgeIndex;
        }
    }

    public static class NavPointInfo {
        public Integer polygonId = null;
        public boolean isOffMeshPoint = false;
        public HashSet<NavPointNeighbourLink> outgoingOffMeshEdges = Sets.newHashSet();
        public HashSet<NavPointNeighbourLink> incommingOffMeshEdges = Sets.newHashSet();
    }
}

